/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.codegenerator.generateproperties;

import java.util.ArrayList;
import java.util.List;
import org.python.pydev.refactoring.ast.adapters.IClassDefAdapter;
import org.python.pydev.refactoring.ast.adapters.INodeAdapter;
import org.python.pydev.refactoring.ast.adapters.PropertyTextAdapter;
import org.python.pydev.refactoring.codegenerator.generateproperties.request.GeneratePropertiesRequest;
import org.python.pydev.refactoring.core.request.IRequestProcessor;
import org.python.pydev.refactoring.ui.model.generateproperties.TreeAttributeNode;
import org.python.pydev.refactoring.ui.model.generateproperties.TreeClassNode;
import org.python.pydev.refactoring.ui.model.tree.TreeNodeSimple;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratePropertiesRequestProcessor
implements IRequestProcessor<GeneratePropertiesRequest> {
    private Object[] checked;
    private int offsetMethodStrategy;
    private int offsetPropertyStrategy;
    private int accessModifier;
    private String endLineDelim;

    public GeneratePropertiesRequestProcessor(String endLineDelim) {
        this.endLineDelim = endLineDelim;
        this.checked = new Object[0];
        this.offsetMethodStrategy = 1;
        this.offsetPropertyStrategy = 4;
        this.accessModifier = 1;
    }

    public void setCheckedElements(Object[] checked) {
        this.checked = checked;
    }

    private List<TreeAttributeNode> getAttributes() {
        ArrayList<TreeAttributeNode> attrs = new ArrayList<TreeAttributeNode>();
        Object[] objectArray = this.checked;
        int n = this.checked.length;
        int n2 = 0;
        while (n2 < n) {
            Object elem = objectArray[n2];
            if (elem instanceof TreeAttributeNode) {
                attrs.add((TreeAttributeNode)elem);
            }
            ++n2;
        }
        return attrs;
    }

    private List<PropertyTextAdapter> getProperties(TreeAttributeNode attr) {
        ArrayList<PropertyTextAdapter> props = new ArrayList<PropertyTextAdapter>();
        Object[] objectArray = this.checked;
        int n = this.checked.length;
        int n2 = 0;
        while (n2 < n) {
            TreeNodeSimple propertyNode;
            Object elem = objectArray[n2];
            if (elem instanceof TreeNodeSimple && (propertyNode = (TreeNodeSimple)elem).getParent() == attr) {
                props.add((PropertyTextAdapter)propertyNode.getAdapter());
            }
            ++n2;
        }
        return props;
    }

    @Override
    public List<GeneratePropertiesRequest> getRefactoringRequests() {
        List<GeneratePropertiesRequest> requests = this.generateRequests();
        return requests;
    }

    private List<GeneratePropertiesRequest> generateRequests() {
        ArrayList<GeneratePropertiesRequest> requests = new ArrayList<GeneratePropertiesRequest>();
        for (TreeAttributeNode elem : this.getAttributes()) {
            GeneratePropertiesRequest request = this.extractRequest(elem);
            if (request == null) continue;
            requests.add(request);
        }
        return requests;
    }

    private GeneratePropertiesRequest extractRequest(TreeAttributeNode attr) {
        if (attr.getParent() != null && attr.getParent() instanceof TreeClassNode) {
            TreeClassNode classNode = (TreeClassNode)attr.getParent();
            return new GeneratePropertiesRequest((IClassDefAdapter)classNode.getAdapter(), (INodeAdapter)attr.getAdapter(), this.getProperties(attr), this.offsetMethodStrategy, this.offsetPropertyStrategy, this.accessModifier, this.endLineDelim);
        }
        return null;
    }

    public void setMethodDestination(int strat) {
        this.offsetMethodStrategy = strat;
    }

    public void setPropertyDestination(int strat) {
        this.offsetPropertyStrategy = strat;
    }

    public void setAccessModifier(int accessModifier) {
        this.accessModifier = accessModifier;
    }
}

