/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.ReflectedCallData;

class ReflectedArgs {
    public static final int StandardCall = 0;
    public static final int PyArgsCall = 1;
    public static final int PyArgsKeywordsCall = 2;
    public static final int REPLACE = 1998;
    public Class[] args;
    public Object data;
    public Class declaringClass;
    public boolean isStatic;
    public int flags;
    private static /* synthetic */ Class array$Lorg$python$core$PyObject;
    private static /* synthetic */ Class array$Ljava$lang$String;
    private static /* synthetic */ Class class$Ljava$lang$Object;
    private static /* synthetic */ Class class$Ljava$lang$String;

    public boolean matches(PyObject self, PyObject[] pyArgs, String[] keywords, ReflectedCallData callData) {
        Object tmp;
        if (this.flags != 2 && keywords != null && keywords.length != 0) {
            return false;
        }
        if (this.isStatic) {
            if (self != null) {
                self = null;
            }
        } else if (self == null) {
            if (pyArgs.length == 0) {
                return false;
            }
            self = pyArgs[0];
            PyObject[] newArgs = new PyObject[pyArgs.length - 1];
            System.arraycopy(pyArgs, 1, newArgs, 0, newArgs.length);
            pyArgs = newArgs;
        }
        if (this.flags == 2) {
            callData.setLength(2);
            callData.args[0] = pyArgs;
            callData.args[1] = keywords;
            callData.self = self;
            if (self != null && (tmp = self.__tojava__(this.declaringClass)) != Py.NoConversion) {
                callData.self = tmp;
            }
            return true;
        }
        if (this.flags == 1) {
            callData.setLength(1);
            callData.args[0] = pyArgs;
            callData.self = self;
            if (self != null && (tmp = self.__tojava__(this.declaringClass)) != Py.NoConversion) {
                callData.self = tmp;
            }
            return true;
        }
        int n = this.args.length;
        if (pyArgs.length != n) {
            return false;
        }
        callData.errArg = -1;
        if (self != null) {
            Object tmp2 = self.__tojava__(this.declaringClass);
            if (tmp2 == Py.NoConversion) {
                return false;
            }
            callData.self = tmp2;
        } else {
            callData.self = null;
        }
        callData.setLength(n);
        Object[] javaArgs = callData.args;
        int i = 0;
        while (i < n) {
            javaArgs[i] = pyArgs[i].__tojava__(this.args[i]);
            if (javaArgs[i] == Py.NoConversion) {
                if (i > callData.errArg) {
                    callData.errArg = i;
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int precedence(Class arg) {
        if (arg == (class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = ReflectedArgs.class$("java.lang.Object")))) {
            return 3000;
        }
        if (arg.isPrimitive()) {
            if (arg == Long.TYPE) {
                return 10;
            }
            if (arg == Integer.TYPE) {
                return 11;
            }
            if (arg == Short.TYPE) {
                return 12;
            }
            if (arg == Character.TYPE) {
                return 13;
            }
            if (arg == Byte.TYPE) {
                return 14;
            }
            if (arg == Double.TYPE) {
                return 20;
            }
            if (arg == Float.TYPE) {
                return 21;
            }
            if (arg == Boolean.TYPE) {
                return 30;
            }
        }
        if (arg == (class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = ReflectedArgs.class$("java.lang.String")))) {
            return 40;
        }
        if (arg.isArray()) {
            Class<?> componentType = arg.getComponentType();
            if (componentType == (class$Ljava$lang$Object != null ? class$Ljava$lang$Object : (class$Ljava$lang$Object = ReflectedArgs.class$("java.lang.Object")))) {
                return 2500;
            }
            return 100 + ReflectedArgs.precedence(componentType);
        }
        return 2000;
    }

    public static int compare(Class arg1, Class arg2) {
        int p1 = ReflectedArgs.precedence(arg1);
        int p2 = ReflectedArgs.precedence(arg2);
        if (p1 >= 2000 && p2 >= 2000) {
            if (arg1.isAssignableFrom(arg2)) {
                if (arg2.isAssignableFrom(arg1)) {
                    return 0;
                }
                return 2;
            }
            if (arg2.isAssignableFrom(arg1)) {
                return -2;
            }
            int cmp = arg1.getName().compareTo(arg2.getName());
            return cmp > 0 ? 1 : -1;
        }
        return p1 > p2 ? 2 : (p1 == p2 ? 0 : -2);
    }

    public int compareTo(ReflectedArgs other) {
        Class[] oargs = other.args;
        if (other.flags != this.flags) {
            return other.flags < this.flags ? -1 : 1;
        }
        int n = this.args.length;
        if (n < oargs.length) {
            return -1;
        }
        if (n > oargs.length) {
            return 1;
        }
        if (this.isStatic && !other.isStatic) {
            return 1;
        }
        if (!this.isStatic && other.isStatic) {
            return -1;
        }
        int cmp = 0;
        int i = 0;
        while (i < n) {
            int tmp = ReflectedArgs.compare(this.args[i], oargs[i]);
            if (tmp == 2 || tmp == -2) {
                cmp = tmp;
            }
            if (cmp == 0) {
                cmp = tmp;
            }
            ++i;
        }
        if (cmp != 0) {
            return cmp > 0 ? 1 : -1;
        }
        boolean replace = other.declaringClass.isAssignableFrom(this.declaringClass);
        if (!this.isStatic) {
            replace = !replace;
        }
        return replace ? 1998 : 0;
    }

    public String toString() {
        String s = "" + this.declaringClass + ", " + this.isStatic + ", " + this.flags + ", " + this.data + "\n";
        s = s + "\t(";
        int j = 0;
        while (j < this.args.length) {
            s = s + this.args[j].getName() + ", ";
            ++j;
        }
        s = s + ")";
        return s;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ReflectedArgs(Object data, Class[] args, Class declaringClass, boolean isStatic) {
        this.data = data;
        this.args = args;
        this.declaringClass = declaringClass;
        this.isStatic = isStatic;
        this.flags = args.length == 1 && args[0] == (array$Lorg$python$core$PyObject != null ? array$Lorg$python$core$PyObject : (array$Lorg$python$core$PyObject = ReflectedArgs.class$("[Lorg.python.core.PyObject;"))) ? 1 : (args.length == 2 && args[0] == (array$Lorg$python$core$PyObject != null ? array$Lorg$python$core$PyObject : (array$Lorg$python$core$PyObject = ReflectedArgs.class$("[Lorg.python.core.PyObject;"))) && args[1] == (array$Ljava$lang$String != null ? array$Ljava$lang$String : (array$Ljava$lang$String = ReflectedArgs.class$("[Ljava.lang.String;"))) ? 2 : 0);
    }
}

