/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.aggregates;

import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SharedFormulaRecord;
import org.apache.poi.hssf.record.StringRecord;

public class FormulaRecordAggregate
extends Record
implements Comparable,
CellValueRecordInterface {
    public static final short sid = -2000;
    private FormulaRecord formulaRecord;
    private StringRecord stringRecord;
    private SharedFormulaRecord sharedFormulaRecord;

    public FormulaRecordAggregate(FormulaRecord formulaRecord, StringRecord stringRecord) {
        this.formulaRecord = formulaRecord;
        this.stringRecord = stringRecord;
    }

    public FormulaRecordAggregate(FormulaRecord formulaRecord, StringRecord stringRecord, SharedFormulaRecord sharedRecord) {
        this.formulaRecord = formulaRecord;
        this.stringRecord = stringRecord;
        this.sharedFormulaRecord = sharedRecord;
    }

    protected void validateSid(short id) {
    }

    protected void fillFields(byte[] data, short size, int offset) {
    }

    public int serialize(int offset, byte[] data) {
        int pos = offset;
        pos += this.formulaRecord.serialize(pos, data);
        if (this.getSharedFormulaRecord() != null) {
            pos += this.getSharedFormulaRecord().serialize(pos, data);
        }
        if (this.stringRecord != null) {
            pos += this.stringRecord.serialize(pos, data);
        }
        return pos - offset;
    }

    public int getRecordSize() {
        int size = this.formulaRecord.getRecordSize() + (this.stringRecord == null ? 0 : this.stringRecord.getRecordSize());
        return size += this.getSharedFormulaRecord() == null ? 0 : this.getSharedFormulaRecord().getRecordSize();
    }

    public short getSid() {
        return -2000;
    }

    public void setStringRecord(StringRecord stringRecord) {
        this.stringRecord = stringRecord;
    }

    public void setFormulaRecord(FormulaRecord formulaRecord) {
        this.formulaRecord = formulaRecord;
    }

    public FormulaRecord getFormulaRecord() {
        return this.formulaRecord;
    }

    public StringRecord getStringRecord() {
        return this.stringRecord;
    }

    public boolean isEqual(CellValueRecordInterface i) {
        return this.formulaRecord.isEqual(i);
    }

    public boolean isAfter(CellValueRecordInterface i) {
        return this.formulaRecord.isAfter(i);
    }

    public boolean isBefore(CellValueRecordInterface i) {
        return this.formulaRecord.isBefore(i);
    }

    public short getXFIndex() {
        return this.formulaRecord.getXFIndex();
    }

    public void setXFIndex(short xf) {
        this.formulaRecord.setXFIndex(xf);
    }

    public void setColumn(short col) {
        this.formulaRecord.setColumn(col);
    }

    public void setRow(int row) {
        this.formulaRecord.setRow(row);
    }

    public short getColumn() {
        return this.formulaRecord.getColumn();
    }

    public int getRow() {
        return this.formulaRecord.getRow();
    }

    public int compareTo(Object o) {
        return this.formulaRecord.compareTo(o);
    }

    public boolean equals(Object obj) {
        return this.formulaRecord.equals(obj);
    }

    public String toString() {
        return this.formulaRecord.toString();
    }

    public Object clone() {
        StringRecord clonedString = this.stringRecord == null ? null : (StringRecord)this.stringRecord.clone();
        SharedFormulaRecord clonedShared = this.sharedFormulaRecord == null ? null : (SharedFormulaRecord)this.sharedFormulaRecord.clone();
        return new FormulaRecordAggregate((FormulaRecord)this.formulaRecord.clone(), clonedString, clonedShared);
    }

    public SharedFormulaRecord getSharedFormulaRecord() {
        return this.sharedFormulaRecord;
    }

    public void setSharedFormulaRecord(SharedFormulaRecord sharedFormulaRecord) {
        this.sharedFormulaRecord = sharedFormulaRecord;
    }

    public boolean isInValueSection() {
        return true;
    }

    public String getStringValue() {
        if (this.stringRecord == null) {
            return null;
        }
        return this.stringRecord.getString();
    }
}

