/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import groovy.lang.GroovyObjectSupport;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.MetaClass;
import groovy.lang.MissingPropertyException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.codehaus.groovy.runtime.CurriedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;

public abstract class Closure
extends GroovyObjectSupport
implements Cloneable,
Runnable {
    private static final Object[] noParameters = new Object[]{null};
    private static final Object[] emptyArray = new Object[0];
    private static final Object[] emptyArrayParameter = new Object[]{emptyArray};
    private Object delegate;
    private final Object owner;
    private Class[] parameterTypes;
    protected int maximumNumberOfParameters;
    private final Object thisObject;
    private int directive = 0;

    public Closure(Object owner, Object thisObject) {
        Class<?> closureClass;
        this.owner = owner;
        this.delegate = owner;
        this.thisObject = thisObject;
        final Class<?> clazz = closureClass = this.getClass();
        Method[] methods = (Method[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return clazz.getDeclaredMethods();
            }
        });
        this.maximumNumberOfParameters = -1;
        for (int j = 0; j < methods.length; ++j) {
            if (!"doCall".equals(methods[j].getName()) || methods[j].getParameterTypes().length <= this.maximumNumberOfParameters) continue;
            this.parameterTypes = methods[j].getParameterTypes();
            this.maximumNumberOfParameters = this.parameterTypes.length;
        }
        this.maximumNumberOfParameters = Math.max(this.maximumNumberOfParameters, 0);
    }

    public Closure(Object owner) {
        this(owner, null);
    }

    public Object getProperty(String property) {
        if ("delegate".equals(property)) {
            return this.getDelegate();
        }
        if ("owner".equals(property)) {
            return this.getOwner();
        }
        if ("getMaximumNumberOfParameters".equals(property)) {
            return new Integer(this.getMaximumNumberOfParameters());
        }
        if ("parameterTypes".equals(property)) {
            return this.getParameterTypes();
        }
        if ("metaClass".equals(property)) {
            return this.getMetaClass();
        }
        if ("class".equals(property)) {
            return this.getClass();
        }
        try {
            return InvokerHelper.getProperty(this.owner, property);
        }
        catch (MissingPropertyException e1) {
            if (this.delegate != null && this.delegate != this && this.delegate != this.owner) {
                try {
                    return InvokerHelper.getProperty(this.delegate, property);
                }
                catch (GroovyRuntimeException groovyRuntimeException) {
                    // empty catch block
                }
            }
            throw e1;
        }
    }

    public void setProperty(String property, Object newValue) {
        if ("delegate".equals(property)) {
            this.setDelegate(newValue);
        } else if ("metaClass".equals(property)) {
            this.setMetaClass((MetaClass)newValue);
        } else {
            try {
                InvokerHelper.setProperty(this.owner, property, newValue);
                return;
            }
            catch (GroovyRuntimeException e1) {
                if (this.delegate != null && this.delegate != this && this.delegate != this.owner) {
                    try {
                        InvokerHelper.setProperty(this.delegate, property, newValue);
                        return;
                    }
                    catch (GroovyRuntimeException e2) {
                        // empty catch block
                    }
                }
                throw e1;
            }
        }
    }

    public Object call() {
        return this.call(new Object[0]);
    }

    public Object call(Object[] args) {
        try {
            return this.getMetaClass().invokeMethod((Object)this, "doCall", args);
        }
        catch (Exception e) {
            return Closure.throwRuntimeException(e);
        }
    }

    public Object call(Object arguments) {
        return this.call(new Object[]{arguments});
    }

    protected static Object throwRuntimeException(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw new GroovyRuntimeException(throwable.getMessage(), throwable);
    }

    public Object getOwner() {
        return this.owner;
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public void setDelegate(Object delegate) {
        this.delegate = delegate;
    }

    public Class[] getParameterTypes() {
        return this.parameterTypes;
    }

    public int getMaximumNumberOfParameters() {
        return this.maximumNumberOfParameters;
    }

    public void run() {
        this.call();
    }

    public Closure curry(Object[] arguments) {
        return new CurriedClosure(this, arguments);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

