/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.planner;

import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.Duration;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.planner.schema.Allocation;
import net.sf.mpxj.planner.schema.Allocations;
import net.sf.mpxj.planner.schema.Calendar;
import net.sf.mpxj.planner.schema.Calendars;
import net.sf.mpxj.planner.schema.Constraint;
import net.sf.mpxj.planner.schema.Days;
import net.sf.mpxj.planner.schema.DefaultWeek;
import net.sf.mpxj.planner.schema.Interval;
import net.sf.mpxj.planner.schema.OverriddenDayType;
import net.sf.mpxj.planner.schema.OverriddenDayTypes;
import net.sf.mpxj.planner.schema.Predecessor;
import net.sf.mpxj.planner.schema.Predecessors;
import net.sf.mpxj.planner.schema.Project;
import net.sf.mpxj.planner.schema.Resources;
import net.sf.mpxj.planner.schema.Tasks;
import net.sf.mpxj.reader.AbstractProjectReader;
import net.sf.mpxj.utility.NumberUtility;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public final class PlannerReader
extends AbstractProjectReader {
    private ProjectFile m_projectFile;
    private ProjectCalendar m_defaultCalendar;
    private NumberFormat m_twoDigitFormat = new DecimalFormat("00");
    private NumberFormat m_fourDigitFormat = new DecimalFormat("0000");
    private List<DateRange> m_defaultWorkingHours = new LinkedList<DateRange>();
    private List<ProjectListener> m_projectListeners;
    private static Map<String, RelationType> RELATIONSHIP_TYPES = new HashMap<String, RelationType>();
    private static JAXBContext CONTEXT;
    private static JAXBException CONTEXT_EXCEPTION;

    public void addProjectListener(ProjectListener projectListener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(projectListener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ProjectFile read(InputStream inputStream) throws MPXJException {
        try {
            try {
                this.m_projectFile = new ProjectFile();
                this.m_projectFile.addProjectListeners(this.m_projectListeners);
                this.m_projectFile.setAutoTaskUniqueID(false);
                this.m_projectFile.setAutoResourceUniqueID(false);
                this.m_projectFile.setAutoOutlineLevel(false);
                this.m_projectFile.setAutoOutlineNumber(false);
                this.m_projectFile.setAutoWBS(false);
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                sAXParserFactory.setNamespaceAware(true);
                SAXParser sAXParser = sAXParserFactory.newSAXParser();
                XMLReader xMLReader = sAXParser.getXMLReader();
                SAXSource sAXSource = new SAXSource(xMLReader, new InputSource(inputStream));
                if (CONTEXT == null) {
                    throw CONTEXT_EXCEPTION;
                }
                Unmarshaller unmarshaller = CONTEXT.createUnmarshaller();
                Project project = (Project)unmarshaller.unmarshal((Source)sAXSource);
                this.readProjectHeader(project);
                this.readCalendars(project);
                this.readResources(project);
                this.readTasks(project);
                this.readAssignments(project);
                this.m_projectFile.updateUniqueCounters();
                ProjectFile projectFile = this.m_projectFile;
                Object var10_12 = null;
                this.m_projectFile = null;
                this.m_defaultCalendar = null;
                return projectFile;
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new MPXJException("Failed to parse file", parserConfigurationException);
            }
            catch (JAXBException jAXBException) {
                throw new MPXJException("Failed to parse file", (Exception)((Object)jAXBException));
            }
            catch (SAXException sAXException) {
                throw new MPXJException("Failed to parse file", sAXException);
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            this.m_projectFile = null;
            this.m_defaultCalendar = null;
            throw throwable;
        }
    }

    private void readProjectHeader(Project project) throws MPXJException {
        ProjectHeader projectHeader = this.m_projectFile.getProjectHeader();
        projectHeader.setCompany(project.getCompany());
        projectHeader.setManager(project.getManager());
        projectHeader.setName(project.getName());
        projectHeader.setStartDate(this.getDateTime(project.getProjectStart()));
    }

    private void readCalendars(Project project) throws MPXJException {
        Calendars calendars = project.getCalendars();
        if (calendars != null) {
            for (Calendar calendar : calendars.getCalendar()) {
                this.readCalendar(calendar, null);
            }
            Integer n = this.getInteger(project.getCalendar());
            this.m_defaultCalendar = this.m_projectFile.getBaseCalendarByUniqueID(n);
            if (this.m_defaultCalendar != null) {
                this.m_projectFile.getProjectHeader().setCalendarName(this.m_defaultCalendar.getName());
            }
        }
    }

    private void readCalendar(Calendar calendar, ProjectCalendar projectCalendar) throws MPXJException {
        ProjectCalendar projectCalendar2 = projectCalendar == null ? this.m_projectFile.addBaseCalendar() : this.m_projectFile.addResourceCalendar();
        projectCalendar2.setUniqueID(this.getInteger(calendar.getId()));
        projectCalendar2.setName(calendar.getName());
        projectCalendar2.setParent(projectCalendar);
        DefaultWeek defaultWeek = calendar.getDefaultWeek();
        this.setWorkingDay(projectCalendar2, Day.MONDAY, defaultWeek.getMon());
        this.setWorkingDay(projectCalendar2, Day.TUESDAY, defaultWeek.getTue());
        this.setWorkingDay(projectCalendar2, Day.WEDNESDAY, defaultWeek.getWed());
        this.setWorkingDay(projectCalendar2, Day.THURSDAY, defaultWeek.getThu());
        this.setWorkingDay(projectCalendar2, Day.FRIDAY, defaultWeek.getFri());
        this.setWorkingDay(projectCalendar2, Day.SATURDAY, defaultWeek.getSat());
        this.setWorkingDay(projectCalendar2, Day.SUNDAY, defaultWeek.getSun());
        this.processWorkingHours(projectCalendar2, calendar);
        this.processExceptionDays(projectCalendar2, calendar);
        this.m_projectFile.fireCalendarReadEvent(projectCalendar2);
        List<Calendar> list = calendar.getCalendar();
        if (list != null) {
            for (Calendar calendar2 : list) {
                this.readCalendar(calendar2, projectCalendar2);
            }
        }
    }

    private void setWorkingDay(ProjectCalendar projectCalendar, Day day, String string) {
        DayType dayType = DayType.DEFAULT;
        if (string != null) {
            switch (this.getInt(string)) {
                case 0: {
                    dayType = DayType.WORKING;
                    break;
                }
                case 1: {
                    dayType = DayType.NON_WORKING;
                }
            }
        }
        projectCalendar.setWorkingDay(day, dayType);
    }

    private void processWorkingHours(ProjectCalendar projectCalendar, Calendar calendar) throws MPXJException {
        List<OverriddenDayType> list;
        OverriddenDayTypes overriddenDayTypes = calendar.getOverriddenDayTypes();
        if (overriddenDayTypes != null && (list = overriddenDayTypes.getOverriddenDayType()) != null) {
            List<Interval> list2;
            Iterator<OverriddenDayType> iterator = list.iterator();
            OverriddenDayType overriddenDayType = null;
            while (iterator.hasNext() && this.getInt((overriddenDayType = iterator.next()).getId()) != 0) {
                overriddenDayType = null;
            }
            if (overriddenDayType != null && (list2 = overriddenDayType.getInterval()) != null) {
                ProjectCalendarHours projectCalendarHours = null;
                ProjectCalendarHours projectCalendarHours2 = null;
                ProjectCalendarHours projectCalendarHours3 = null;
                ProjectCalendarHours projectCalendarHours4 = null;
                ProjectCalendarHours projectCalendarHours5 = null;
                ProjectCalendarHours projectCalendarHours6 = null;
                ProjectCalendarHours projectCalendarHours7 = null;
                if (projectCalendar.isWorkingDay(Day.MONDAY)) {
                    projectCalendarHours = projectCalendar.addCalendarHours(Day.MONDAY);
                }
                if (projectCalendar.isWorkingDay(Day.TUESDAY)) {
                    projectCalendarHours2 = projectCalendar.addCalendarHours(Day.TUESDAY);
                }
                if (projectCalendar.isWorkingDay(Day.WEDNESDAY)) {
                    projectCalendarHours3 = projectCalendar.addCalendarHours(Day.WEDNESDAY);
                }
                if (projectCalendar.isWorkingDay(Day.THURSDAY)) {
                    projectCalendarHours4 = projectCalendar.addCalendarHours(Day.THURSDAY);
                }
                if (projectCalendar.isWorkingDay(Day.FRIDAY)) {
                    projectCalendarHours5 = projectCalendar.addCalendarHours(Day.FRIDAY);
                }
                if (projectCalendar.isWorkingDay(Day.SATURDAY)) {
                    projectCalendarHours6 = projectCalendar.addCalendarHours(Day.SATURDAY);
                }
                if (projectCalendar.isWorkingDay(Day.SUNDAY)) {
                    projectCalendarHours7 = projectCalendar.addCalendarHours(Day.SUNDAY);
                }
                for (Interval interval : list2) {
                    Date date = this.getTime(interval.getStart());
                    Date date2 = this.getTime(interval.getEnd());
                    this.m_defaultWorkingHours.add(new DateRange(date, date2));
                    if (projectCalendarHours != null) {
                        projectCalendarHours.addRange(new DateRange(date, date2));
                    }
                    if (projectCalendarHours2 != null) {
                        projectCalendarHours2.addRange(new DateRange(date, date2));
                    }
                    if (projectCalendarHours3 != null) {
                        projectCalendarHours3.addRange(new DateRange(date, date2));
                    }
                    if (projectCalendarHours4 != null) {
                        projectCalendarHours4.addRange(new DateRange(date, date2));
                    }
                    if (projectCalendarHours5 != null) {
                        projectCalendarHours5.addRange(new DateRange(date, date2));
                    }
                    if (projectCalendarHours6 != null) {
                        projectCalendarHours6.addRange(new DateRange(date, date2));
                    }
                    if (projectCalendarHours7 == null) continue;
                    projectCalendarHours7.addRange(new DateRange(date, date2));
                }
            }
        }
    }

    private void processExceptionDays(ProjectCalendar projectCalendar, Calendar calendar) throws MPXJException {
        List<net.sf.mpxj.planner.schema.Day> list;
        Days days = calendar.getDays();
        if (days != null && (list = days.getDay()) != null) {
            for (net.sf.mpxj.planner.schema.Day day : list) {
                if (!day.getType().equals("day-type")) continue;
                Date date = this.getDate(day.getDate());
                ProjectCalendarException projectCalendarException = projectCalendar.addCalendarException(date, date);
                if (this.getInt(day.getId()) != 0) continue;
                for (int i = 0; i < this.m_defaultWorkingHours.size(); ++i) {
                    DateRange dateRange = this.m_defaultWorkingHours.get(i);
                    projectCalendarException.addRange(dateRange);
                }
            }
        }
    }

    private void readResources(Project project) throws MPXJException {
        Resources resources = project.getResources();
        if (resources != null) {
            for (net.sf.mpxj.planner.schema.Resource resource : resources.getResource()) {
                this.readResource(resource);
            }
        }
    }

    private void readResource(net.sf.mpxj.planner.schema.Resource resource) throws MPXJException {
        Resource resource2 = this.m_projectFile.addResource();
        resource2.setEmailAddress(resource.getEmail());
        resource2.setUniqueID(this.getInteger(resource.getId()));
        resource2.setName(resource.getName());
        resource2.setNotes(resource.getNote());
        resource2.setInitials(resource.getShortName());
        resource2.setType(this.getInt(resource.getType()) == 2 ? ResourceType.MATERIAL : ResourceType.WORK);
        ProjectCalendar projectCalendar = resource2.addResourceCalendar();
        projectCalendar.setWorkingDay(Day.SUNDAY, DayType.DEFAULT);
        projectCalendar.setWorkingDay(Day.MONDAY, DayType.DEFAULT);
        projectCalendar.setWorkingDay(Day.TUESDAY, DayType.DEFAULT);
        projectCalendar.setWorkingDay(Day.WEDNESDAY, DayType.DEFAULT);
        projectCalendar.setWorkingDay(Day.THURSDAY, DayType.DEFAULT);
        projectCalendar.setWorkingDay(Day.FRIDAY, DayType.DEFAULT);
        projectCalendar.setWorkingDay(Day.SATURDAY, DayType.DEFAULT);
        ProjectCalendar projectCalendar2 = this.m_projectFile.getBaseCalendarByUniqueID(this.getInteger(resource.getCalendar()));
        if (projectCalendar2 == null) {
            projectCalendar2 = this.m_defaultCalendar;
        }
        projectCalendar.setParent(projectCalendar2);
        this.m_projectFile.fireResourceReadEvent(resource2);
    }

    private void readTasks(Project project) throws MPXJException {
        Tasks tasks = project.getTasks();
        if (tasks != null) {
            for (net.sf.mpxj.planner.schema.Task task : tasks.getTask()) {
                this.readTask(null, task);
            }
            for (net.sf.mpxj.planner.schema.Task task : tasks.getTask()) {
                this.readPredecessors(task);
            }
        }
        this.m_projectFile.updateStructure();
    }

    private void readTask(Task task, net.sf.mpxj.planner.schema.Task task2) throws MPXJException {
        Object object;
        Task task3;
        if (task == null) {
            task3 = this.m_projectFile.addTask();
            task3.setOutlineLevel(1);
        } else {
            task3 = task.addTask();
            task3.setOutlineLevel(task.getOutlineLevel() + 1);
        }
        Integer n = this.getInteger(task2.getPercentComplete());
        task3.setFinish(this.getDateTime(task2.getEnd()));
        task3.setUniqueID(this.getInteger(task2.getId()));
        task3.setName(task2.getName());
        task3.setNotes(task2.getNote());
        task3.setPercentageComplete(n);
        task3.setPercentageWorkComplete(n);
        task3.setPriority(Priority.getInstance(this.getInt(task2.getPriority()) / 10));
        task3.setType(this.getTaskType(task2.getScheduling()));
        task3.setMilestone(task2.getType().equals("milestone"));
        task3.setWork(this.getDuration(task2.getWork()));
        task3.setStart(this.getDateTime(task2.getWorkStart()));
        ConstraintType constraintType = ConstraintType.AS_SOON_AS_POSSIBLE;
        Constraint constraint = task2.getConstraint();
        if (constraint != null) {
            if (constraint.getType().equals("start-no-earlier-than")) {
                constraintType = ConstraintType.START_NO_EARLIER_THAN;
            } else if (constraint.getType().equals("must-start-on")) {
                constraintType = ConstraintType.MUST_START_ON;
            }
            task3.setConstraintDate(this.getDateTime(constraint.getTime()));
        }
        task3.setConstraintType(constraintType);
        ProjectCalendar projectCalendar = this.m_projectFile.getCalendar();
        if (projectCalendar != null) {
            object = projectCalendar.getWork(task3.getStart(), task3.getFinish(), TimeUnit.HOURS);
            double d = ((Duration)object).getDuration() / 8.0;
            if (d > 0.0) {
                object = Duration.getInstance(d, TimeUnit.DAYS);
            }
            task3.setDuration((Duration)object);
            if (n != 0) {
                task3.setActualStart(task3.getStart());
                if (n == 100) {
                    task3.setActualFinish(task3.getFinish());
                    task3.setActualDuration((Duration)object);
                    task3.setActualWork(task3.getWork());
                    task3.setRemainingWork(Duration.getInstance(0, TimeUnit.HOURS));
                } else {
                    Duration duration = task3.getWork();
                    Duration duration2 = Duration.getInstance(duration.getDuration() * n.doubleValue() / 100.0, duration.getUnits());
                    task3.setActualDuration(Duration.getInstance(((Duration)object).getDuration() * n.doubleValue() / 100.0, ((Duration)object).getUnits()));
                    task3.setActualWork(duration2);
                    task3.setRemainingWork(Duration.getInstance(duration.getDuration() - duration2.getDuration(), duration.getUnits()));
                }
            }
        }
        task3.setEffortDriven(true);
        this.m_projectFile.fireTaskReadEvent(task3);
        object = task2.getTask();
        if (object != null) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                net.sf.mpxj.planner.schema.Task task4 = (net.sf.mpxj.planner.schema.Task)iterator.next();
                this.readTask(task3, task4);
            }
        }
    }

    private void readPredecessors(net.sf.mpxj.planner.schema.Task task) {
        List<Object> list;
        Task task2 = this.m_projectFile.getTaskByUniqueID(this.getInteger(task.getId()));
        Predecessors predecessors = task.getPredecessors();
        if (predecessors != null && (list = predecessors.getPredecessor()) != null) {
            for (Object object : list) {
                Integer n = this.getInteger(((Predecessor)object).getPredecessorId());
                Task task3 = this.m_projectFile.getTaskByUniqueID(n);
                if (task3 == null) continue;
                Duration duration = this.getDuration(((Predecessor)object).getLag());
                if (duration == null) {
                    duration = Duration.getInstance(0, TimeUnit.HOURS);
                }
                Relation relation = task2.addPredecessor(task3, RELATIONSHIP_TYPES.get(((Predecessor)object).getType()), duration);
                this.m_projectFile.fireRelationReadEvent(relation);
            }
        }
        if ((list = task.getTask()) != null) {
            for (Object object : list) {
                this.readPredecessors((net.sf.mpxj.planner.schema.Task)object);
            }
        }
    }

    private void readAssignments(Project project) {
        Allocations allocations = project.getAllocations();
        List<Allocation> list = allocations.getAllocation();
        if (list != null) {
            Duration duration;
            Duration duration2;
            List<ResourceAssignment> list2;
            HashSet hashSet = new HashSet();
            for (Allocation object : list) {
                list2 = this.getInteger(object.getTaskId());
                Integer n = this.getInteger(object.getResourceId());
                Integer n2 = this.getInteger(object.getUnits());
                Iterator iterator = this.m_projectFile.getTaskByUniqueID((Integer)((Object)list2));
                Resource resource = this.m_projectFile.getResourceByUniqueID(n);
                if (iterator == null || resource == null) continue;
                duration2 = ((Task)((Object)iterator)).getWork();
                int n3 = NumberUtility.getInt(((Task)((Object)iterator)).getPercentageComplete());
                ResourceAssignment resourceAssignment = ((Task)((Object)iterator)).addResourceAssignment(resource);
                resourceAssignment.setUnits(n2);
                resourceAssignment.setWork(duration2);
                if (n3 != 0) {
                    duration = Duration.getInstance(duration2.getDuration() * (double)n3 / 100.0, duration2.getUnits());
                    resourceAssignment.setActualWork(duration);
                    resourceAssignment.setRemainingWork(Duration.getInstance(duration2.getDuration() - duration.getDuration(), duration2.getUnits()));
                } else {
                    resourceAssignment.setRemainingWork(duration2);
                }
                resourceAssignment.setStart(((Task)((Object)iterator)).getStart());
                resourceAssignment.setFinish(((Task)((Object)iterator)).getFinish());
                hashSet.add(iterator);
                this.m_projectFile.fireAssignmentReadEvent(resourceAssignment);
            }
            for (Task task : hashSet) {
                list2 = task.getResourceAssignments();
                if (list2.size() <= 1) continue;
                double d = 0.0;
                for (ResourceAssignment resourceAssignment : list2) {
                    d += resourceAssignment.getUnits().doubleValue();
                }
                for (ResourceAssignment resourceAssignment : list2) {
                    Duration duration3;
                    duration2 = resourceAssignment.getWork();
                    double d2 = resourceAssignment.getUnits().doubleValue() / d;
                    duration2 = Duration.getInstance(duration2.getDuration() * d2, duration2.getUnits());
                    resourceAssignment.setWork(duration2);
                    duration = resourceAssignment.getActualWork();
                    if (duration != null) {
                        duration = Duration.getInstance(duration.getDuration() * d2, duration.getUnits());
                        resourceAssignment.setActualWork(duration);
                    }
                    if ((duration3 = resourceAssignment.getRemainingWork()) == null) continue;
                    duration3 = Duration.getInstance(duration3.getDuration() * d2, duration3.getUnits());
                    resourceAssignment.setRemainingWork(duration3);
                }
            }
        }
    }

    private Date getDateTime(String string) throws MPXJException {
        try {
            Number number = this.m_fourDigitFormat.parse(string.substring(0, 4));
            Number number2 = this.m_twoDigitFormat.parse(string.substring(4, 6));
            Number number3 = this.m_twoDigitFormat.parse(string.substring(6, 8));
            Number number4 = this.m_twoDigitFormat.parse(string.substring(9, 11));
            Number number5 = this.m_twoDigitFormat.parse(string.substring(11, 13));
            java.util.Calendar calendar = java.util.Calendar.getInstance();
            calendar.set(1, number.intValue());
            calendar.set(2, number2.intValue() - 1);
            calendar.set(5, number3.intValue());
            calendar.set(11, number4.intValue());
            calendar.set(12, number5.intValue());
            calendar.set(13, 0);
            calendar.set(14, 0);
            return calendar.getTime();
        }
        catch (ParseException parseException) {
            throw new MPXJException("Failed to parse date-time " + string, parseException);
        }
    }

    private Date getDate(String string) throws MPXJException {
        try {
            Number number = this.m_fourDigitFormat.parse(string.substring(0, 4));
            Number number2 = this.m_twoDigitFormat.parse(string.substring(4, 6));
            Number number3 = this.m_twoDigitFormat.parse(string.substring(6, 8));
            java.util.Calendar calendar = java.util.Calendar.getInstance();
            calendar.set(1, number.intValue());
            calendar.set(2, number2.intValue() - 1);
            calendar.set(5, number3.intValue());
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            return calendar.getTime();
        }
        catch (ParseException parseException) {
            throw new MPXJException("Failed to parse date " + string, parseException);
        }
    }

    private Date getTime(String string) throws MPXJException {
        try {
            Number number = this.m_twoDigitFormat.parse(string.substring(0, 2));
            Number number2 = this.m_twoDigitFormat.parse(string.substring(2, 4));
            java.util.Calendar calendar = java.util.Calendar.getInstance();
            calendar.set(11, number.intValue());
            calendar.set(12, number2.intValue());
            calendar.set(13, 0);
            calendar.set(14, 0);
            return calendar.getTime();
        }
        catch (ParseException parseException) {
            throw new MPXJException("Failed to parse time " + string, parseException);
        }
    }

    private Integer getInteger(String string) {
        return NumberUtility.getInteger(string);
    }

    private int getInt(String string) {
        return Integer.parseInt(string);
    }

    private long getLong(String string) {
        return Long.parseLong(string);
    }

    private TaskType getTaskType(String string) {
        TaskType taskType = TaskType.FIXED_UNITS;
        if (string != null && string.equals("fixed-duration")) {
            taskType = TaskType.FIXED_DURATION;
        }
        return taskType;
    }

    private Duration getDuration(String string) {
        Duration duration = null;
        if (string != null && string.length() != 0) {
            double d = this.getLong(string);
            double d2 = d / 3600.0;
            double d3 = d2 / 8.0;
            if (d3 < 1.0) {
                duration = Duration.getInstance(d2, TimeUnit.HOURS);
            } else {
                double d4 = d2 / 8.0;
                duration = Duration.getInstance(d4, TimeUnit.DAYS);
            }
        }
        return duration;
    }

    static {
        RELATIONSHIP_TYPES.put("FF", RelationType.FINISH_FINISH);
        RELATIONSHIP_TYPES.put("FS", RelationType.FINISH_START);
        RELATIONSHIP_TYPES.put("SF", RelationType.START_FINISH);
        RELATIONSHIP_TYPES.put("SS", RelationType.START_START);
        try {
            System.setProperty("com.sun.xml.bind.v2.runtime.JAXBContextImpl.fastBoot", "true");
            CONTEXT = JAXBContext.newInstance((String)"net.sf.mpxj.planner.schema", (ClassLoader)PlannerReader.class.getClassLoader());
        }
        catch (JAXBException jAXBException) {
            CONTEXT_EXCEPTION = jAXBException;
            CONTEXT = null;
        }
    }
}

