/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import net.sf.mpxj.utility.EnumUtility;
import net.sf.mpxj.utility.MpxjEnum;
import net.sf.mpxj.utility.NumberUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TimeUnit implements MpxjEnum
{
    MINUTES(0, "m"),
    HOURS(1, "h"),
    DAYS(2, "d"),
    WEEKS(3, "w"),
    MONTHS(4, "mo"),
    PERCENT(5, "%"),
    YEARS(6, "y"),
    ELAPSED_MINUTES(7, "em"),
    ELAPSED_HOURS(8, "eh"),
    ELAPSED_DAYS(9, "ed"),
    ELAPSED_WEEKS(10, "ew"),
    ELAPSED_MONTHS(11, "emo"),
    ELAPSED_YEARS(12, "ey"),
    ELAPSED_PERCENT(13, "e%");

    private static final TimeUnit[] TYPE_VALUES;
    private int m_value;
    private String m_name;

    private TimeUnit(int n2, String string2) {
        this.m_value = n2;
        this.m_name = string2;
    }

    public static TimeUnit getInstance(int n) {
        if (n < 0 || n >= TYPE_VALUES.length) {
            n = DAYS.getValue();
        }
        return TYPE_VALUES[n];
    }

    public static TimeUnit getInstance(Number number) {
        int n = number == null ? -1 : NumberUtility.getInt(number);
        return TimeUnit.getInstance(n);
    }

    @Override
    public int getValue() {
        return this.m_value;
    }

    public String getName() {
        return this.m_name;
    }

    public String toString() {
        return this.getName();
    }

    static {
        TYPE_VALUES = (TimeUnit[])EnumUtility.createTypeArray(TimeUnit.class);
    }
}

