/*
 * Decompiled with CFR 0.152.
 */
package com.projity.exchange;

import com.projity.pm.calendar.CalendarService;
import com.projity.pm.calendar.WorkCalendar;
import com.projity.pm.calendar.WorkingCalendar;
import java.util.HashMap;
import java.util.Iterator;
import net.sf.mpxj.ProjectCalendar;

public class ImportedCalendarService {
    private static ImportedCalendarService instance = null;
    HashMap importedCalendarMap = new HashMap();
    HashMap exportedCalendarMap = new HashMap();

    public static ImportedCalendarService getInstance() {
        if (instance == null) {
            instance = new ImportedCalendarService();
        }
        return instance;
    }

    public void addImportedCalendar(WorkingCalendar workingCalendar, ProjectCalendar projectCalendar) {
        this.importedCalendarMap.put(projectCalendar, workingCalendar);
        CalendarService calendarService = CalendarService.getInstance();
        if (workingCalendar.isBaseCalendar() && calendarService.findBaseCalendar(workingCalendar.getName(), true) != null) {
            return;
        }
        calendarService.add(workingCalendar);
    }

    public WorkCalendar findImportedCalendar(ProjectCalendar projectCalendar) {
        return (WorkCalendar)this.importedCalendarMap.get(projectCalendar);
    }

    public ProjectCalendar findImportedMPXCalendar(String string) {
        Iterator iterator = this.importedCalendarMap.keySet().iterator();
        if (string == null) {
            return null;
        }
        while (iterator.hasNext()) {
            ProjectCalendar projectCalendar = (ProjectCalendar)iterator.next();
            if (!string.equals(projectCalendar.getName())) continue;
            return projectCalendar;
        }
        return null;
    }

    public void addExportedCalendar(ProjectCalendar projectCalendar, WorkingCalendar workingCalendar) {
        this.exportedCalendarMap.put(workingCalendar, projectCalendar);
    }

    public ProjectCalendar findExportedCalendar(WorkCalendar workCalendar) {
        return (ProjectCalendar)this.exportedCalendarMap.get(workCalendar);
    }

    public static void cleanUp() {
        instance = null;
    }
}

