/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.lexer;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.php.editor.lexer.PHP5ColoringLexer;
import org.netbeans.modules.php.editor.lexer.PHPTokenId;
import org.netbeans.modules.php.project.api.PhpLanguageOptions;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;
import org.netbeans.spi.lexer.TokenFactory;
import org.openide.filesystems.FileObject;

public class GSFPHPLexer
implements Lexer<PHPTokenId> {
    private final PHP5ColoringLexer scanner;
    private TokenFactory<PHPTokenId> tokenFactory;

    private GSFPHPLexer(LexerRestartInfo<PHPTokenId> info, boolean inPHP) {
        boolean short_tag = true;
        boolean asp_tag = false;
        FileObject fileObject = (FileObject)info.getAttributeValue(FileObject.class);
        if (fileObject != null) {
            PhpLanguageOptions.Properties languageProperties = PhpLanguageOptions.getDefault().getProperties(fileObject);
            asp_tag = languageProperties.areAspTagsEnabled();
            short_tag = languageProperties.areShortTagsEnabled();
        }
        this.scanner = new PHP5ColoringLexer(info, short_tag, asp_tag, inPHP);
        this.tokenFactory = info.tokenFactory();
    }

    public static synchronized GSFPHPLexer create(LexerRestartInfo<PHPTokenId> info, boolean inPHP) {
        return new GSFPHPLexer(info, inPHP);
    }

    public Token<PHPTokenId> nextToken() {
        try {
            PHPTokenId tokenId = this.scanner.nextToken();
            Token token = null;
            if (tokenId != null) {
                token = this.tokenFactory.createToken((TokenId)tokenId);
            }
            return token;
        }
        catch (IOException ex) {
            Logger.getLogger(GSFPHPLexer.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public Object state() {
        return this.scanner.getState();
    }

    public void release() {
    }
}

