/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.elements;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.elements.TypeConstantElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.elements.IndexQueryImpl;
import org.netbeans.modules.php.editor.elements.PhpElementImpl;
import org.netbeans.modules.php.editor.index.Signature;
import org.openide.util.Parameters;

public final class TypeConstantElementImpl
extends PhpElementImpl
implements TypeConstantElement {
    public static final String IDX_FIELD = "clz.const";
    private final TypeElement enclosingType;
    private final String value;

    private TypeConstantElementImpl(TypeElement enclosingType, String constantName, String value, int offset, String fileUrl, ElementQuery elementQuery) {
        super(constantName, enclosingType.getName(), fileUrl, offset, elementQuery);
        this.enclosingType = enclosingType;
        this.value = value;
    }

    public static Set<TypeConstantElement> fromSignature(TypeElement type, IndexQueryImpl indexScopeQuery, IndexResult indexResult) {
        return TypeConstantElementImpl.fromSignature(type, NameKind.empty(), indexScopeQuery, indexResult);
    }

    public static Set<TypeConstantElement> fromSignature(TypeElement type, NameKind query, IndexQueryImpl indexScopeQuery, IndexResult indexResult) {
        String[] values = indexResult.getValues(IDX_FIELD);
        HashSet<TypeConstantElement> retval = values.length > 0 ? new HashSet<TypeConstantElement>() : Collections.emptySet();
        for (String val : values) {
            TypeConstantElement constant = TypeConstantElementImpl.fromSignature(type, query, indexScopeQuery, indexResult, Signature.get(val));
            if (constant == null) continue;
            retval.add(constant);
        }
        return retval;
    }

    private static TypeConstantElement fromSignature(TypeElement type, NameKind query, IndexQueryImpl indexScopeQuery, IndexResult indexResult, Signature signature) {
        ConstantSignatureParser signParser = new ConstantSignatureParser(signature);
        TypeConstantElementImpl retval = null;
        if (TypeConstantElementImpl.matchesQuery(query, signParser)) {
            retval = new TypeConstantElementImpl(type, signParser.getConstantName(), signParser.getValue(), signParser.getOffset(), indexResult.getUrl().toString(), indexScopeQuery);
        }
        return retval;
    }

    private static boolean matchesQuery(NameKind query, ConstantSignatureParser signParser) {
        Parameters.notNull((CharSequence)"query", (Object)query);
        return query instanceof NameKind.Empty || query.matchesName(TypeConstantElement.KIND, signParser.getConstantName());
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName().toLowerCase()).append((Object)PhpElementImpl.SEPARATOR.SEMICOLON);
        sb.append(this.getName()).append((Object)PhpElementImpl.SEPARATOR.SEMICOLON);
        sb.append(this.getOffset()).append((Object)PhpElementImpl.SEPARATOR.SEMICOLON);
        sb.append(this.getValue()).append((Object)PhpElementImpl.SEPARATOR.SEMICOLON);
        this.checkSignature(sb);
        return sb.toString();
    }

    @Override
    public final PhpElementKind getPhpElementKind() {
        return TypeConstantElement.KIND;
    }

    @Override
    public final TypeElement getType() {
        return this.enclosingType;
    }

    private void checkSignature(StringBuilder sb) {
        boolean checkEnabled = false;
        if (!$assertionsDisabled) {
            checkEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (checkEnabled) {
            String retval = sb.toString();
            ConstantSignatureParser parser = new ConstantSignatureParser(Signature.get(retval));
            assert (this.getName().equals(parser.getConstantName()));
            assert (this.getOffset() == parser.getOffset());
        }
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public final boolean isStatic() {
        return this.getPhpModifiers().isStatic();
    }

    @Override
    public final boolean isPublic() {
        return this.getPhpModifiers().isPublic();
    }

    @Override
    public final boolean isProtected() {
        return this.getPhpModifiers().isProtected();
    }

    @Override
    public final boolean isPrivate() {
        return this.getPhpModifiers().isPrivate();
    }

    @Override
    public final boolean isFinal() {
        return this.getPhpModifiers().isFinal();
    }

    @Override
    public final boolean isAbstract() {
        return this.getPhpModifiers().isAbstract();
    }

    private static class ConstantSignatureParser {
        private final Signature signature;

        ConstantSignatureParser(Signature signature) {
            this.signature = signature;
        }

        String getConstantName() {
            return this.signature.string(1);
        }

        int getOffset() {
            return this.signature.integer(2);
        }

        String getValue() {
            return this.signature.string(3);
        }
    }
}

