/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.codegen.ui;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.swing.AbstractListModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.support.DatabaseExplorerUIs;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.php.editor.codegen.DatabaseURL;
import org.netbeans.modules.php.editor.codegen.ui.CheckListener;
import org.netbeans.modules.php.editor.codegen.ui.CheckRenderer;
import org.netbeans.modules.php.editor.codegen.ui.ProgressPanel;
import org.netbeans.modules.php.editor.codegen.ui.Selectable;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class TableGeneratorPanel
extends JPanel {
    private DialogDescriptor descriptor;
    private DatabaseConnection dbconn;
    private Connection conn;
    private DatabaseMetaData dmd;
    private String table;
    private String lastErrorMessage;
    private JLabel columnLabel;
    private JList columnList;
    private JScrollPane columnScrollPane;
    private JLabel connVariableLabel;
    private JTextField connVariableTextField;
    private JComboBox dbconnComboBox;
    private JLabel dbconnLabel;
    private JComboBox tableComboBox;
    private JLabel tableLabel;

    public static TableAndColumns selectTableAndColumns(String connVariable) {
        TableGeneratorPanel panel = new TableGeneratorPanel();
        DialogDescriptor desc = new DialogDescriptor((Object)panel, NbBundle.getMessage(TableGeneratorPanel.class, (String)"MSG_SelectTableAndColumns"));
        desc.createNotificationLineSupport();
        panel.initialize(desc, connVariable);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(desc);
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TableGeneratorPanel.class, (String)"ACSD_SelectColumns"));
        dialog.setVisible(true);
        dialog.dispose();
        if (desc.getValue() == DialogDescriptor.OK_OPTION) {
            SQLIdentifiers.Quoter quoter = SQLIdentifiers.createQuoter((DatabaseMetaData)panel.dmd);
            return new TableAndColumns(quoter, panel.table, panel.getAllColumns(), panel.getSelectedColumns(), panel.getConnVariable());
        }
        return null;
    }

    private TableGeneratorPanel() {
        this.initComponents();
        this.columnList.setCellRenderer(new CheckRenderer());
        CheckListener checkListener = new CheckListener();
        this.columnList.addKeyListener(checkListener);
        this.columnList.addMouseListener(checkListener);
        this.connVariableTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                TableGeneratorPanel.this.updateErrorState();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TableGeneratorPanel.this.updateErrorState();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                TableGeneratorPanel.this.updateErrorState();
            }
        });
    }

    private void initialize(DialogDescriptor descriptor, String connVariable) {
        this.descriptor = descriptor;
        DatabaseExplorerUIs.connect((JComboBox)this.dbconnComboBox, (ConnectionManager)ConnectionManager.getDefault());
        this.connVariableTextField.setText(connVariable);
        this.updateErrorState();
    }

    private String changeDatabaseConnection(DatabaseConnection newDBConn) {
        DatabaseMetaData newDmd;
        String catalog;
        String password;
        this.dbconn = null;
        this.conn = null;
        this.dmd = null;
        this.tableComboBox.setModel(new DefaultComboBoxModel());
        this.columnList.setModel(new DefaultListModel());
        if (newDBConn == null) {
            return null;
        }
        DatabaseURL url = DatabaseURL.detect(newDBConn.getDatabaseURL());
        if (url == null || url.getServer() != DatabaseURL.Server.MYSQL) {
            return NbBundle.getMessage(TableGeneratorPanel.class, (String)"ERR_UnknownServer");
        }
        Connection newConn = newDBConn.getJDBCConnection();
        if (newConn == null) {
            ConnectionManager.getDefault().showConnectionDialog(newDBConn);
            newConn = newDBConn.getJDBCConnection();
        }
        if ((password = newDBConn.getPassword()) == null || newConn == null) {
            if (password == null) {
                return NbBundle.getMessage(TableGeneratorPanel.class, (String)"ERR_NoPassword");
            }
            return NbBundle.getMessage(TableGeneratorPanel.class, (String)"ERR_CouldNotConnect");
        }
        try {
            catalog = newConn.getCatalog();
            newDmd = newConn.getMetaData();
        }
        catch (SQLException e) {
            Exceptions.printStackTrace((Throwable)e);
            return NbBundle.getMessage(TableGeneratorPanel.class, (String)"ERR_DatabaseMetadata");
        }
        ArrayList tables = new ArrayList();
        String errorMessage = this.extractTables(tables, newDmd, catalog, newDBConn.getSchema());
        if (errorMessage != null) {
            return errorMessage;
        }
        Collections.sort(tables);
        this.dbconn = newDBConn;
        this.conn = newConn;
        this.dmd = newDmd;
        DefaultComboBoxModel<String> tableModel = new DefaultComboBoxModel<String>();
        for (String table : tables) {
            tableModel.addElement(table);
        }
        this.tableComboBox.setModel(tableModel);
        return null;
    }

    private String extractTables(final List<? super String> tables, final DatabaseMetaData dmd, final String catalog, final String schema) {
        return TableGeneratorPanel.doWithProgress(NbBundle.getMessage(TableGeneratorPanel.class, (String)"MSG_ExtractingTables"), new Callable<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String call() throws Exception {
                try {
                    ResultSet rs = dmd.getTables(catalog, schema, "%", new String[]{"TABLE"});
                    try {
                        while (rs.next()) {
                            tables.add(rs.getString("TABLE_NAME"));
                        }
                    }
                    finally {
                        rs.close();
                    }
                    return null;
                }
                catch (SQLException e) {
                    Exceptions.printStackTrace((Throwable)e);
                    return NbBundle.getMessage(TableGeneratorPanel.class, (String)"ERR_DatabaseMetadata");
                }
            }
        });
    }

    private String changeTable(String newTable) {
        ArrayList<String> columns = new ArrayList<String>();
        String errorMessage = this.extractColumns(newTable, columns);
        if (errorMessage != null) {
            return errorMessage;
        }
        this.table = newTable;
        ColumnModel model = new ColumnModel(columns);
        this.columnList.setModel(model);
        int selectedIndex = model.getSize() > 0 ? 0 : -1;
        this.columnList.setSelectedIndex(selectedIndex);
        return null;
    }

    private String extractColumns(final String table, final List<? super String> columns) {
        return TableGeneratorPanel.doWithProgress(NbBundle.getMessage(TableGeneratorPanel.class, (String)"MSG_ExtractingColumns"), new Callable<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String call() {
                try {
                    ResultSet rs = TableGeneratorPanel.this.dmd.getColumns(TableGeneratorPanel.this.conn.getCatalog(), TableGeneratorPanel.this.dbconn.getSchema(), table, "%");
                    try {
                        while (rs.next()) {
                            columns.add(rs.getString("COLUMN_NAME"));
                        }
                    }
                    finally {
                        rs.close();
                    }
                    return null;
                }
                catch (SQLException e) {
                    Exceptions.printStackTrace((Throwable)e);
                    return NbBundle.getMessage(TableGeneratorPanel.class, (String)"ERR_DatabaseMetadata");
                }
            }
        });
    }

    private void tableComboBoxSelectionChanged() {
        String table = (String)this.tableComboBox.getSelectedItem();
        this.lastErrorMessage = this.changeTable(table);
        this.updateErrorState();
    }

    private List<String> getSelectedColumns() {
        ArrayList<String> result = new ArrayList<String>();
        ListModel model = this.columnList.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            Selectable columnEl;
            Object element = model.getElementAt(i);
            if (!(element instanceof Selectable) || !(columnEl = (Selectable)element).isSelected()) continue;
            result.add(columnEl.getDisplayName());
        }
        return result;
    }

    private List<String> getAllColumns() {
        ArrayList<String> result = new ArrayList<String>();
        ListModel model = this.columnList.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            Object element = model.getElementAt(i);
            if (!(element instanceof Selectable)) continue;
            Selectable columnEl = (Selectable)element;
            result.add(columnEl.getDisplayName());
        }
        return result;
    }

    private String getConnVariable() {
        return this.connVariableTextField.getText().trim();
    }

    private void updateErrorState() {
        this.tableComboBox.setEnabled(this.dbconn != null);
        this.columnList.setEnabled(this.tableComboBox.getSelectedItem() != null);
        if (this.lastErrorMessage != null) {
            this.setErrorMessage(this.lastErrorMessage);
            return;
        }
        if (this.dbconn == null) {
            this.setErrorMessage(NbBundle.getMessage(TableGeneratorPanel.class, (String)"ERR_SelectConnection"));
            return;
        }
        if (this.tableComboBox.getSelectedItem() == null) {
            this.setErrorMessage(NbBundle.getMessage(TableGeneratorPanel.class, (String)"ERR_SelectTable"));
            return;
        }
        if (this.getConnVariable().trim().length() == 0) {
            this.setErrorMessage(NbBundle.getMessage(TableGeneratorPanel.class, (String)"ERR_EnterConnVariable"));
            return;
        }
        this.setErrorMessage(null);
    }

    private void setErrorMessage(String message) {
        this.descriptor.getNotificationLineSupport().setErrorMessage(message);
        this.descriptor.setValid(message == null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T doWithProgress(String message, final Callable<? extends T> run) {
        final ProgressPanel panel = new ProgressPanel();
        panel.setCancelVisible(false);
        panel.setText(message);
        ProgressHandle handle = ProgressHandleFactory.createHandle(null);
        JComponent progress = ProgressHandleFactory.createProgressComponent((ProgressHandle)handle);
        handle.start();
        final ArrayList result = new ArrayList(1);
        try {
            RequestProcessor.Task task = RequestProcessor.getDefault().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    if (!SwingUtilities.isEventDispatchThread()) {
                        try {
                            result.add(run.call());
                        }
                        catch (Exception e) {
                            result.add(null);
                            Exceptions.printStackTrace((Throwable)e);
                        }
                        finally {
                            SwingUtilities.invokeLater(this);
                        }
                    } else {
                        panel.close();
                    }
                }
            });
            panel.open(progress);
            task.waitFinished();
        }
        finally {
            handle.finish();
        }
        return (T)result.get(0);
    }

    private void initComponents() {
        this.dbconnLabel = new JLabel();
        this.dbconnComboBox = new JComboBox();
        this.tableLabel = new JLabel();
        this.tableComboBox = new JComboBox();
        this.columnLabel = new JLabel();
        this.columnScrollPane = new JScrollPane();
        this.columnList = new JList();
        this.connVariableLabel = new JLabel();
        this.connVariableTextField = new JTextField();
        this.setFocusTraversalPolicy(null);
        this.dbconnLabel.setLabelFor(this.dbconnComboBox);
        Mnemonics.setLocalizedText((JLabel)this.dbconnLabel, (String)NbBundle.getMessage(TableGeneratorPanel.class, (String)"ConnectionGeneratorPanel.dbconnLabel.text"));
        this.dbconnComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableGeneratorPanel.this.dbconnComboBoxActionPerformed(evt);
            }
        });
        this.tableLabel.setLabelFor(this.tableComboBox);
        Mnemonics.setLocalizedText((JLabel)this.tableLabel, (String)NbBundle.getMessage(TableGeneratorPanel.class, (String)"TableGeneratorPanel.tableLabel.text"));
        this.tableComboBox.setEnabled(false);
        this.tableComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableGeneratorPanel.this.tableComboBoxActionPerformed(evt);
            }
        });
        this.columnLabel.setLabelFor(this.columnList);
        Mnemonics.setLocalizedText((JLabel)this.columnLabel, (String)NbBundle.getMessage(TableGeneratorPanel.class, (String)"TableGeneratorPanel.columnLabel.text"));
        this.columnList.setEnabled(false);
        this.columnScrollPane.setViewportView(this.columnList);
        this.columnList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TableGeneratorPanel.class, (String)"TableGeneratorPanel.columnList.AccessibleContext.accessibleName"));
        this.columnList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TableGeneratorPanel.class, (String)"TableGeneratorPanel.columnList.AccessibleContext.accessibleDescription"));
        this.connVariableLabel.setLabelFor(this.connVariableLabel);
        Mnemonics.setLocalizedText((JLabel)this.connVariableLabel, (String)NbBundle.getMessage(TableGeneratorPanel.class, (String)"TableGeneratorPanel.connVariableLabel.text"));
        this.connVariableTextField.setColumns(16);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.columnScrollPane, GroupLayout.Alignment.LEADING, -1, 437, Short.MAX_VALUE).addComponent(this.dbconnLabel, GroupLayout.Alignment.LEADING).addComponent(this.dbconnComboBox, GroupLayout.Alignment.LEADING, 0, 437, Short.MAX_VALUE).addComponent(this.tableLabel, GroupLayout.Alignment.LEADING).addComponent(this.tableComboBox, GroupLayout.Alignment.LEADING, 0, 437, Short.MAX_VALUE).addComponent(this.columnLabel, GroupLayout.Alignment.LEADING).addComponent(this.connVariableTextField, GroupLayout.Alignment.LEADING, -2, -1, -2).addComponent(this.connVariableLabel, GroupLayout.Alignment.LEADING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.dbconnLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dbconnComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tableLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tableComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.columnLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.columnScrollPane, -1, 201, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.connVariableLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.connVariableTextField, -2, -1, -2).addGap(20, 20, 20)));
        this.dbconnLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TableGeneratorPanel.class, (String)"TableGeneratorPanel.dbconnLabel.AccessibleContext.accessibleName"));
        this.dbconnLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TableGeneratorPanel.class, (String)"TableGeneratorPanel.dbconnLabel.AccessibleContext.accessibleDescription"));
        this.dbconnComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TableGeneratorPanel.class, (String)"TableGeneratorPanel.dbconnComboBox.AccessibleContext.accessibleName"));
        this.dbconnComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TableGeneratorPanel.class, (String)"TableGeneratorPanel.dbconnComboBox.AccessibleContext.accessibleDescription"));
        this.tableLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TableGeneratorPanel.class, (String)"TableGeneratorPanel.tableLabel.AccessibleContext.accessibleName"));
        this.tableLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TableGeneratorPanel.class, (String)"TableGeneratorPanel.tableLabel.AccessibleContext.accessibleDescription"));
        this.tableComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TableGeneratorPanel.class, (String)"TableGeneratorPanel.tableComboBox.AccessibleContext.accessibleName"));
        this.tableComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TableGeneratorPanel.class, (String)"TableGeneratorPanel.tableComboBox.AccessibleContext.accessibleDescription"));
        this.columnLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TableGeneratorPanel.class, (String)"TableGeneratorPanel.columnLabel.AccessibleContext.accessibleName"));
        this.columnLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TableGeneratorPanel.class, (String)"TableGeneratorPanel.columnLabel.AccessibleContext.accessibleDescription_1"));
        this.columnScrollPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TableGeneratorPanel.class, (String)"TableGeneratorPanel.columnScrollPane.AccessibleContext.accessibleName"));
        this.columnScrollPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TableGeneratorPanel.class, (String)"TableGeneratorPanel.columnScrollPane.AccessibleContext.accessibleDescription_1"));
        this.connVariableLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TableGeneratorPanel.class, (String)"TableGeneratorPanel.connVariableLabel.AccessibleContext.accessibleName"));
        this.connVariableTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TableGeneratorPanel.class, (String)"TableGeneratorPanel.connVariableTextField.AccessibleContext.accessibleName"));
        this.connVariableTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TableGeneratorPanel.class, (String)"TableGeneratorPanel.connVariableTextField.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TableGeneratorPanel.class, (String)"TableGeneratorPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TableGeneratorPanel.class, (String)"TableGeneratorPanel.AccessibleContext.accessibleDescription"));
    }

    private void dbconnComboBoxActionPerformed(ActionEvent evt) {
        DatabaseConnection dbconn = null;
        Object selected = this.dbconnComboBox.getSelectedItem();
        if (selected instanceof DatabaseConnection) {
            dbconn = (DatabaseConnection)selected;
        }
        this.lastErrorMessage = this.changeDatabaseConnection(dbconn);
        if (this.lastErrorMessage == null && this.dbconn != null) {
            this.tableComboBoxSelectionChanged();
        }
        this.updateErrorState();
    }

    private void tableComboBoxActionPerformed(ActionEvent evt) {
        this.tableComboBoxSelectionChanged();
    }

    public static final class TableAndColumns {
        private final SQLIdentifiers.Quoter identifierQuoter;
        private final String table;
        private final List<String> allColumns;
        private final List<String> selectedColumns;
        private final String connVariable;

        private TableAndColumns(SQLIdentifiers.Quoter identifierQuoter, String table, List<String> allColumns, List<String> selectedColumns, String connVariable) {
            this.identifierQuoter = identifierQuoter;
            this.table = table;
            this.allColumns = allColumns;
            this.selectedColumns = selectedColumns;
            this.connVariable = connVariable;
        }

        public SQLIdentifiers.Quoter getIdentifierQuoter() {
            return this.identifierQuoter;
        }

        public String getTable() {
            return this.table;
        }

        public List<String> getAllColumns() {
            return this.allColumns;
        }

        public List<String> getSelectedColumns() {
            return this.selectedColumns;
        }

        public String getConnVariable() {
            return this.connVariable;
        }
    }

    private static final class ColumnModel
    extends AbstractListModel
    implements ChangeListener {
        private final List<Selectable> elements;

        public ColumnModel(List<String> columns) {
            this.elements = new ArrayList<Selectable>(columns.size());
            for (String table : columns) {
                Selectable element = new Selectable(table);
                element.addChangeListener(this);
                this.elements.add(element);
            }
        }

        @Override
        public int getSize() {
            return this.elements.size();
        }

        @Override
        public Selectable getElementAt(int index) {
            return this.elements.get(index);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            for (int i = 0; i < this.elements.size(); ++i) {
                if (this.elements.get(i) != e.getSource()) continue;
                this.fireContentsChanged(this, i, i);
                break;
            }
        }
    }
}

