/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.runtime;

import org.jruby.nb.RubyMethod;
import org.jruby.nb.RubyModule;
import org.jruby.nb.exceptions.JumpException;
import org.jruby.nb.parser.StaticScope;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.Binding;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.BlockBody;
import org.jruby.nb.runtime.DynamicScope;
import org.jruby.nb.runtime.Frame;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.runtime.callback.Callback;

public class MethodBlock
extends BlockBody {
    private final RubyMethod method;
    private final Callback callback;
    private final Arity arity;
    private final StaticScope staticScope;

    public static Block createMethodBlock(ThreadContext context, DynamicScope dynamicScope, Callback callback, RubyMethod method, IRubyObject self) {
        Binding binding = new Binding(self, context.getCurrentFrame().duplicate(), context.getCurrentFrame().getVisibility(), context.getRubyClass(), dynamicScope);
        MethodBlock body = new MethodBlock(callback, method, dynamicScope.getStaticScope());
        return new Block(body, binding);
    }

    public MethodBlock(Callback callback, RubyMethod method, StaticScope staticScope) {
        super(3);
        this.callback = callback;
        this.method = method;
        this.arity = Arity.createArity((int)method.arity().getLongValue());
        this.staticScope = staticScope;
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject[] args, Binding binding, Block.Type type) {
        return this.yield(context, context.getRuntime().newArrayNoCopy(args), null, null, true, binding, type);
    }

    protected Frame pre(ThreadContext context, RubyModule klass, Binding binding) {
        return context.preYieldNoScope(binding, klass);
    }

    protected void post(ThreadContext context, Binding binding, Frame lastFrame) {
        context.postYieldNoScope(lastFrame);
    }

    @Override
    public IRubyObject yield(ThreadContext context, IRubyObject value, Binding binding, Block.Type type) {
        return this.yield(context, value, null, null, false, binding, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IRubyObject yield(ThreadContext context, IRubyObject value, IRubyObject self, RubyModule klass, boolean aValue, Binding binding, Block.Type type) {
        if (klass == null) {
            self = binding.getSelf();
            binding.getFrame().setSelf(self);
        }
        Frame lastFrame = this.pre(context, klass, binding);
        while (true) {
            try {
                IRubyObject iRubyObject = this.callback.execute(value, new IRubyObject[]{this.method, self}, Block.NULL_BLOCK);
                return iRubyObject;
            }
            catch (JumpException.RedoJump rj) {
                try {
                    context.pollThreadEvents();
                    continue;
                    catch (JumpException.BreakJump bj) {
                        if (bj.getTarget() != null) throw bj;
                        bj.setTarget(this);
                        throw bj;
                    }
                }
                catch (JumpException.NextJump nj) {
                    IRubyObject iRubyObject = (IRubyObject)nj.getValue();
                    return iRubyObject;
                }
            }
            break;
        }
        finally {
            this.post(context, binding, lastFrame);
        }
    }

    @Override
    public StaticScope getStaticScope() {
        return this.staticScope;
    }

    @Override
    public Block cloneBlock(Binding binding) {
        binding = new Binding(binding.getSelf(), binding.getFrame().duplicate(), binding.getVisibility(), binding.getKlass(), binding.getDynamicScope().cloneScope());
        return new Block(this, binding);
    }

    @Override
    public Arity arity() {
        return this.arity;
    }
}

