/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.java.proxies;

import org.jruby.nb.Ruby;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyFixnum;
import org.jruby.nb.RubyInteger;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyRange;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.internal.runtime.methods.JavaMethod;
import org.jruby.nb.java.proxies.JavaProxy;
import org.jruby.nb.javasupport.JavaArray;
import org.jruby.nb.javasupport.JavaClass;
import org.jruby.nb.javasupport.JavaUtil;
import org.jruby.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class ArrayJavaProxy
extends JavaProxy {
    public ArrayJavaProxy(Ruby runtime, RubyClass klazz) {
        super(runtime, klazz);
    }

    public static RubyClass createArrayJavaProxy(ThreadContext context) {
        Ruby runtime = context.getRuntime();
        RubyClass arrayJavaProxy = runtime.defineClass("ArrayJavaProxy", runtime.getJavaSupport().getJavaProxyClass(), new ObjectAllocator(){

            @Override
            public IRubyObject allocate(Ruby runtime, RubyClass klazz) {
                return new ArrayJavaProxy(runtime, klazz);
            }
        });
        RubyClass singleton = arrayJavaProxy.getSingletonClass();
        DynamicMethod oldNew = singleton.searchMethod("new");
        singleton.addMethod("new", new ArrayNewMethod((RubyModule)singleton, Visibility.PUBLIC, oldNew));
        arrayJavaProxy.defineAnnotatedMethods(ArrayJavaProxy.class);
        arrayJavaProxy.includeModule(runtime.getEnumerable());
        return arrayJavaProxy;
    }

    public JavaArray getJavaArray() {
        return (JavaArray)this.dataGetStruct();
    }

    @JRubyMethod(name={"length", "size"}, backtrace=true)
    public IRubyObject length() {
        return this.getJavaArray().length();
    }

    @JRubyMethod(name={"[]"}, required=1, rest=true, backtrace=true)
    public IRubyObject op_aref(ThreadContext context, IRubyObject[] args) {
        if (args.length == 1 && args[0] instanceof RubyInteger) {
            return JavaUtil.java_to_ruby(context.getRuntime(), this.getJavaArray().aref(args[0]));
        }
        return this.getRange(context, args);
    }

    @JRubyMethod(name={"[]="}, backtrace=true)
    public IRubyObject op_aset(ThreadContext context, IRubyObject index, IRubyObject value) {
        Object converted = this.getJavaArray().getRubyConverter().convert(context, value);
        this.getJavaArray().setWithExceptionHandling((int)index.convertToInteger().getLongValue(), converted);
        return value;
    }

    @JRubyMethod(backtrace=true)
    public IRubyObject at(ThreadContext context, IRubyObject indexObj) {
        long index;
        RubyFixnum lengthF = this.getJavaArray().length();
        RubyInteger indexI = indexObj.convertToInteger();
        if (indexI.getLongValue() < 0L) {
            indexI = RubyFixnum.newFixnum(context.getRuntime(), indexI.getLongValue() + lengthF.getLongValue());
        }
        if ((index = indexI.getLongValue()) >= 0L && index < lengthF.getLongValue()) {
            return JavaUtil.java_to_ruby(context.getRuntime(), this.getJavaArray().aref(indexI));
        }
        return context.getRuntime().getNil();
    }

    public IRubyObject at(int index) {
        return this.getJavaArray().at(index);
    }

    @JRubyMethod(name={"+"}, backtrace=true)
    public IRubyObject op_plus(ThreadContext context, IRubyObject other) {
        JavaClass arrayClass = JavaClass.get(context.getRuntime(), this.getJavaArray().getComponentType());
        if (other instanceof ArrayJavaProxy) {
            JavaArray otherArray = ((ArrayJavaProxy)other).getJavaArray();
            if (this.getJavaArray().getComponentType().isAssignableFrom(otherArray.getComponentType())) {
                return arrayClass.concatArrays(context, this.getJavaArray(), otherArray);
            }
        }
        return arrayClass.concatArrays(context, this.getJavaArray(), other);
    }

    @JRubyMethod(backtrace=true)
    public IRubyObject each(ThreadContext context, Block block) {
        int length = (int)this.getJavaArray().length().getLongValue();
        for (int i = 0; i < length; ++i) {
            block.yield(context, JavaUtil.java_to_ruby(context.getRuntime(), this.at(i)));
        }
        return this;
    }

    @JRubyMethod(name={"to_a", "to_ary"}, backtrace=true)
    public IRubyObject to_a(ThreadContext context) {
        RubyModule javaArrayUtilities = context.getRuntime().getJavaSupport().getJavaArrayUtilitiesModule();
        return RuntimeHelpers.invoke(context, (IRubyObject)javaArrayUtilities, "java_to_ruby", this);
    }

    public IRubyObject getRange(ThreadContext context, IRubyObject[] args) {
        if (args.length == 1) {
            return this.getRange(context, args[0]);
        }
        if (args.length == 2) {
            return this.getRange(context, args[0], args[1]);
        }
        throw context.getRuntime().newArgumentError(args.length, 1);
    }

    public IRubyObject getRange(ThreadContext context, IRubyObject arg0) {
        int length = (int)this.getJavaArray().length().getLongValue();
        JavaClass arrayClass = JavaClass.get(context.getRuntime(), this.getJavaArray().getComponentType());
        if (arg0 instanceof RubyRange) {
            RubyRange range = (RubyRange)arg0;
            if (range.first() instanceof RubyFixnum && range.last() instanceof RubyFixnum) {
                int first = (int)((RubyFixnum)range.first()).getLongValue();
                int last = (int)((RubyFixnum)range.last()).getLongValue();
                first = first >= 0 ? first : length + first;
                last = last >= 0 ? last : length + last;
                int newLength = last - first;
                if (range.exclude_end_p().isFalse()) {
                    ++newLength;
                }
                if (newLength <= 0) {
                    return arrayClass.emptyJavaArray(context);
                }
                return arrayClass.javaArraySubarray(context, this.getJavaArray(), first, newLength);
            }
            throw context.getRuntime().newTypeError("only Fixnum ranges supported");
        }
        throw context.getRuntime().newTypeError(arg0, context.getRuntime().getRange());
    }

    public IRubyObject getRange(ThreadContext context, IRubyObject firstObj, IRubyObject lengthObj) {
        JavaClass arrayClass = JavaClass.get(context.getRuntime(), this.getJavaArray().getComponentType());
        if (firstObj instanceof RubyFixnum && lengthObj instanceof RubyFixnum) {
            int first = (int)((RubyFixnum)firstObj).getLongValue();
            int length = (int)((RubyFixnum)lengthObj).getLongValue();
            if ((long)length > this.getJavaArray().length().getLongValue()) {
                throw context.getRuntime().newIndexError("length specifed is longer than array");
            }
            int n = first = first >= 0 ? first : (int)this.getJavaArray().length().getLongValue() + first;
            if (length <= 0) {
                return arrayClass.emptyJavaArray(context);
            }
            return arrayClass.javaArraySubarray(context, this.getJavaArray(), first, length);
        }
        throw context.getRuntime().newTypeError("only Fixnum ranges supported");
    }

    public static class ArrayNewMethod
    extends JavaMethod.JavaMethodOne {
        private DynamicMethod oldNew;

        public ArrayNewMethod(RubyModule implClass, Visibility visibility, DynamicMethod oldNew) {
            super(implClass, visibility);
            this.oldNew = oldNew;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name, IRubyObject arg0) {
            Ruby runtime = context.getRuntime();
            IRubyObject proxy = this.oldNew.call(context, self, clazz, "new_proxy");
            if (arg0 instanceof JavaArray) {
                proxy.dataWrapStruct(arg0);
                return proxy;
            }
            throw runtime.newTypeError(arg0, runtime.getJavaSupport().getJavaArrayClass());
        }
    }
}

