/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.evaluator;

import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyBinding;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyProc;
import org.jruby.nb.RubyString;
import org.jruby.nb.ast.ArrayNode;
import org.jruby.nb.ast.BlockPassNode;
import org.jruby.nb.ast.IterNode;
import org.jruby.nb.ast.MultipleAsgnNode;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.util.ArgsUtil;
import org.jruby.nb.common.IRubyWarnings;
import org.jruby.nb.evaluator.AssignmentVisitor;
import org.jruby.nb.exceptions.JumpException;
import org.jruby.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.parser.StaticScope;
import org.jruby.nb.runtime.Binding;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.DynamicScope;
import org.jruby.nb.runtime.Frame;
import org.jruby.nb.runtime.InterpretedBlock;
import org.jruby.nb.runtime.MethodIndex;
import org.jruby.nb.runtime.RubyEvent;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.util.TypeConverter;

public class ASTInterpreter {
    @Deprecated
    public static IRubyObject eval(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block block) {
        assert (self != null) : "self during eval must never be null";
        if (node == null) {
            return runtime.getNil();
        }
        try {
            return node.interpret(runtime, context, self, block);
        }
        catch (StackOverflowError sfe) {
            throw runtime.newSystemStackError("stack level too deep");
        }
    }

    public static IRubyObject evalWithBinding(ThreadContext context, IRubyObject src, IRubyObject scope, String file, int lineNumber) {
        assert (!scope.isNil());
        Ruby runtime = src.getRuntime();
        String savedFile = context.getFile();
        int savedLine = context.getLine();
        if (!(scope instanceof RubyBinding)) {
            if (scope instanceof RubyProc) {
                scope = ((RubyProc)scope).binding();
            } else {
                throw runtime.newTypeError("wrong argument type " + scope.getMetaClass() + " (expected Proc/Binding)");
            }
        }
        Binding binding = ((RubyBinding)scope).getBinding();
        DynamicScope evalScope = binding.getDynamicScope().getEvalScope();
        if (file == null) {
            file = binding.getFrame().getFile();
        }
        if (lineNumber == -1) {
            lineNumber = binding.getFrame().getLine();
        }
        evalScope.getStaticScope().determineModule();
        Frame lastFrame = context.preEvalWithBinding(binding);
        try {
            IRubyObject newSelf = binding.getSelf();
            RubyString source = src.convertToString();
            Node node = runtime.parseEval(source.getByteList(), file, evalScope, lineNumber);
            IRubyObject iRubyObject = node.interpret(runtime, context, newSelf, binding.getFrame().getBlock());
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            throw runtime.newLocalJumpError("break", (IRubyObject)bj.getValue(), "unexpected break");
        }
        catch (JumpException.RedoJump rj) {
            throw runtime.newLocalJumpError("redo", (IRubyObject)rj.getValue(), "unexpected redo");
        }
        catch (StackOverflowError sfe) {
            throw runtime.newSystemStackError("stack level too deep");
        }
        finally {
            context.postEvalWithBinding(binding, lastFrame);
            context.setFile(savedFile);
            context.setLine(savedLine);
        }
    }

    public static IRubyObject evalSimple(ThreadContext context, IRubyObject self, IRubyObject src, String file, int lineNumber) {
        RubyString source = src.convertToString();
        return ASTInterpreter.evalSimple(context, self, source, file, lineNumber);
    }

    public static IRubyObject evalSimple(ThreadContext context, IRubyObject self, RubyString src, String file, int lineNumber) {
        assert (file != null);
        Ruby runtime = src.getRuntime();
        String savedFile = context.getFile();
        int savedLine = context.getLine();
        RubyString source = src.convertToString();
        DynamicScope evalScope = context.getCurrentScope().getEvalScope();
        evalScope.getStaticScope().determineModule();
        try {
            Node node = runtime.parseEval(source.getByteList(), file, evalScope, lineNumber);
            IRubyObject iRubyObject = node.interpret(runtime, context, self, Block.NULL_BLOCK);
            return iRubyObject;
        }
        catch (JumpException.BreakJump bj) {
            throw runtime.newLocalJumpError("break", (IRubyObject)bj.getValue(), "unexpected break");
        }
        catch (StackOverflowError sfe) {
            throw runtime.newSystemStackError("stack level too deep");
        }
        finally {
            context.setFile(savedFile);
            context.setLine(savedLine);
        }
    }

    public static void callTraceFunction(Ruby runtime, ThreadContext context, RubyEvent event) {
        String name = context.getFrameName();
        RubyModule type = context.getFrameKlazz();
        runtime.callEventHooks(context, event, context.getFile(), context.getLine(), name, type);
    }

    public static IRubyObject pollAndReturn(ThreadContext context, IRubyObject result) {
        context.pollThreadEvents();
        return result;
    }

    public static IRubyObject multipleAsgnArrayNode(Ruby runtime, ThreadContext context, MultipleAsgnNode iVisited, ArrayNode node, IRubyObject self, Block aBlock) {
        IRubyObject[] array = new IRubyObject[node.size()];
        for (int i = 0; i < node.size(); ++i) {
            array[i] = node.get(i).interpret(runtime, context, self, aBlock);
        }
        return AssignmentVisitor.multiAssign(runtime, context, self, iVisited, RubyArray.newArrayNoCopyLight(runtime, array), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject evalClassDefinitionBody(Ruby runtime, ThreadContext context, StaticScope scope, Node bodyNode, RubyModule type, IRubyObject self, Block block) {
        context.preClassEval(scope, type);
        try {
            if (runtime.hasEventHooks()) {
                ASTInterpreter.callTraceFunction(runtime, context, RubyEvent.CLASS);
            }
            if (bodyNode == null) {
                IRubyObject iRubyObject = runtime.getNil();
                return iRubyObject;
            }
            IRubyObject iRubyObject = bodyNode.interpret(runtime, context, type, block);
            return iRubyObject;
        }
        finally {
            if (runtime.hasEventHooks()) {
                ASTInterpreter.callTraceFunction(runtime, context, RubyEvent.END);
            }
            context.postClassEval();
        }
    }

    public static String getArgumentDefinition(Ruby runtime, ThreadContext context, Node node, String type, IRubyObject self, Block block) {
        if (node == null) {
            return type;
        }
        if (node instanceof ArrayNode) {
            ArrayNode list = (ArrayNode)node;
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                if (list.get(i).definition(runtime, context, self, block) != null) continue;
                return null;
            }
        } else if (node.definition(runtime, context, self, block) == null) {
            return null;
        }
        return type;
    }

    public static Block getBlock(Ruby runtime, ThreadContext context, IRubyObject self, Block currentBlock, Node blockNode) {
        if (blockNode == null) {
            return Block.NULL_BLOCK;
        }
        if (blockNode instanceof IterNode) {
            return ASTInterpreter.getIterNodeBlock(blockNode, context, self);
        }
        if (blockNode instanceof BlockPassNode) {
            return ASTInterpreter.getBlockPassBlock(blockNode, runtime, context, self, currentBlock);
        }
        assert (false) : "Trying to get block from something which cannot deliver";
        return null;
    }

    private static Block getBlockPassBlock(Node blockNode, Ruby runtime, ThreadContext context, IRubyObject self, Block currentBlock) {
        Node bodyNode = ((BlockPassNode)blockNode).getBodyNode();
        IRubyObject proc = bodyNode == null ? runtime.getNil() : bodyNode.interpret(runtime, context, self, currentBlock);
        return RuntimeHelpers.getBlockFromBlockPassBody(proc, currentBlock);
    }

    private static Block getIterNodeBlock(Node blockNode, ThreadContext context, IRubyObject self) {
        IterNode iterNode = (IterNode)blockNode;
        StaticScope scope = iterNode.getScope();
        scope.determineModule();
        return InterpretedBlock.newInterpretedClosure(context, iterNode.getBlockBody(), self);
    }

    public static RubyModule getClassVariableBase(ThreadContext context, Ruby runtime) {
        StaticScope scope = context.getCurrentScope().getStaticScope();
        RubyModule rubyClass = scope.getModule();
        if (rubyClass.isSingleton() || rubyClass == runtime.getDummy()) {
            scope = scope.getPreviousCRefScope();
            rubyClass = scope.getModule();
            if (scope.getPreviousCRefScope() == null) {
                runtime.getWarnings().warn(IRubyWarnings.ID.CVAR_FROM_TOPLEVEL_SINGLETON_METHOD, "class variable access from toplevel singleton method", new Object[0]);
            }
        }
        return rubyClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static String getDefinition(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        try {
            context.setWithinDefined(true);
            String string = node.definition(runtime, context, self, aBlock);
            return string;
        }
        finally {
            context.setWithinDefined(false);
        }
    }

    public static IRubyObject[] setupArgs(Ruby runtime, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        if (node == null) {
            return IRubyObject.NULL_ARRAY;
        }
        if (node instanceof ArrayNode) {
            ArrayNode argsArrayNode = (ArrayNode)node;
            String savedFile = context.getFile();
            int savedLine = context.getLine();
            int size = argsArrayNode.size();
            IRubyObject[] argsArray = new IRubyObject[size];
            for (int i = 0; i < size; ++i) {
                argsArray[i] = argsArrayNode.get(i).interpret(runtime, context, self, aBlock);
            }
            context.setFile(savedFile);
            context.setLine(savedLine);
            return argsArray;
        }
        return ArgsUtil.convertToJavaArray(node.interpret(runtime, context, self, aBlock));
    }

    @Deprecated
    public static IRubyObject aValueSplat(Ruby runtime, IRubyObject value) {
        if (!(value instanceof RubyArray) || ((RubyArray)value).length().getLongValue() == 0L) {
            return runtime.getNil();
        }
        RubyArray array = (RubyArray)value;
        return array.getLength() == 1 ? array.first(IRubyObject.NULL_ARRAY) : array;
    }

    @Deprecated
    public static RubyArray arrayValue(Ruby runtime, IRubyObject value) {
        IRubyObject tmp = value.checkArrayType();
        if (tmp.isNil()) {
            if (value.getMetaClass().searchMethod("to_a").getImplementationClass() != runtime.getKernel()) {
                if (!((value = value.callMethod(runtime.getCurrentContext(), MethodIndex.TO_A, "to_a")) instanceof RubyArray)) {
                    throw runtime.newTypeError("`to_a' did not return Array");
                }
                return (RubyArray)value;
            }
            return runtime.newArray(value);
        }
        return (RubyArray)tmp;
    }

    @Deprecated
    public static IRubyObject aryToAry(Ruby runtime, IRubyObject value) {
        if (value instanceof RubyArray) {
            return value;
        }
        if (value.respondsTo("to_ary")) {
            return TypeConverter.convertToType(value, runtime.getArray(), MethodIndex.TO_A, "to_ary", false);
        }
        return runtime.newArray(value);
    }

    @Deprecated
    public static RubyArray splatValue(Ruby runtime, IRubyObject value) {
        if (value.isNil()) {
            return runtime.newArray(value);
        }
        return ASTInterpreter.arrayValue(runtime, value);
    }

    @Deprecated
    public static RubyArray splatValue(IRubyObject value, Ruby runtime) {
        return ASTInterpreter.splatValue(runtime, value);
    }

    @Deprecated
    public static IRubyObject aValueSplat(IRubyObject value, Ruby runtime) {
        return ASTInterpreter.aValueSplat(runtime, value);
    }

    @Deprecated
    public static IRubyObject aryToAry(IRubyObject value, Ruby runtime) {
        return ASTInterpreter.aryToAry(runtime, value);
    }
}

