/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubySymbol;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.types.ILiteralNode;
import org.jruby.nb.ast.types.INameNode;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class SymbolNode
extends Node
implements ILiteralNode,
INameNode {
    private String name;
    private RubySymbol symbol;

    public SymbolNode(ISourcePosition position, String name) {
        super(position, NodeType.SYMBOLNODE);
        this.name = name;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitSymbolNode(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    public RubySymbol getSymbol(Ruby runtime) {
        RubySymbol sym = this.symbol;
        if (sym != null) {
            return sym;
        }
        this.symbol = runtime.fastNewSymbol(this.name);
        return this.symbol;
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        return this.getSymbol(runtime);
    }
}

