/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.ASTInterpreter;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.CallSite;
import org.jruby.nb.runtime.MethodIndex;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class OpAsgnNode
extends Node {
    private final Node receiverNode;
    private final Node valueNode;
    public final CallSite variableCallAdapter;
    public final CallSite operatorCallAdapter;
    public final CallSite variableAsgnCallAdapter;

    public OpAsgnNode(ISourcePosition position, Node receiverNode, Node valueNode, String variableName, String operatorName) {
        super(position, NodeType.OPASGNNODE);
        assert (receiverNode != null) : "receiverNode is not null";
        assert (valueNode != null) : "valueNode is not null";
        this.receiverNode = receiverNode;
        this.valueNode = valueNode;
        this.variableCallAdapter = MethodIndex.getCallSite(variableName);
        this.operatorCallAdapter = MethodIndex.getCallSite(operatorName);
        this.variableAsgnCallAdapter = MethodIndex.getCallSite((variableName + "=").intern());
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitOpAsgnNode(this);
    }

    public String getOperatorName() {
        return this.operatorCallAdapter.methodName;
    }

    public Node getReceiverNode() {
        return this.receiverNode;
    }

    public Node getValueNode() {
        return this.valueNode;
    }

    public String getVariableName() {
        return this.variableCallAdapter.methodName;
    }

    public String getVariableNameAsgn() {
        return this.variableAsgnCallAdapter.methodName;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.receiverNode, this.valueNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject receiver = this.receiverNode.interpret(runtime, context, self, aBlock);
        IRubyObject value = this.variableCallAdapter.call(context, receiver);
        if (this.getOperatorName() == "||") {
            if (value.isTrue()) {
                return ASTInterpreter.pollAndReturn(context, value);
            }
            value = this.valueNode.interpret(runtime, context, self, aBlock);
        } else if (this.getOperatorName() == "&&") {
            if (!value.isTrue()) {
                return ASTInterpreter.pollAndReturn(context, value);
            }
            value = this.valueNode.interpret(runtime, context, self, aBlock);
        } else {
            value = this.operatorCallAdapter.call(context, value, this.valueNode.interpret(runtime, context, self, aBlock));
        }
        this.variableAsgnCallAdapter.call(context, receiver, value);
        return ASTInterpreter.pollAndReturn(context, value);
    }
}

