/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.ast.CommentNode;
import org.jruby.nb.ast.InvisibleNode;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.exceptions.JumpException;
import org.jruby.nb.lexer.yacc.IDESourcePosition;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.lexer.yacc.ISourcePositionHolder;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public abstract class Node
implements ISourcePositionHolder {
    public static final ISourcePosition INVALID_POSITION = new ISourcePosition(){

        @Override
        public String getFile() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int getStartLine() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int getEndLine() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void adjustStartOffset(int relativeValue) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int getStartOffset() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int getEndOffset() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public ISourcePosition union(ISourcePosition position) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Collection<CommentNode> getComments() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void setComments(Collection<CommentNode> comments) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    };
    static final List<Node> EMPTY_LIST = new ArrayList<Node>();
    public static final List<CommentNode> EMPTY_COMMENT_LIST = new ArrayList<CommentNode>();
    public final NodeType nodeId;
    private ISourcePosition position;

    public Node(ISourcePosition position, NodeType id) {
        assert (position != null);
        this.position = position;
        this.nodeId = id;
    }

    @Override
    public ISourcePosition getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(ISourcePosition position) {
        this.position = position;
    }

    public abstract Instruction accept(NodeVisitor var1);

    public abstract List<Node> childNodes();

    protected static List<Node> createList(Node ... nodes) {
        ArrayList<Node> list = new ArrayList<Node>();
        for (Node node : nodes) {
            if (node == null) continue;
            list.add(node);
        }
        return list;
    }

    public String toString() {
        return this.getNodeName() + "[]";
    }

    protected String getNodeName() {
        String name = this.getClass().getName();
        int i = name.lastIndexOf(46);
        String nodeType = name.substring(i + 1);
        return nodeType;
    }

    public void addComment(CommentNode comment) {
        Collection<CommentNode> comments = this.position.getComments();
        if (comments == null) {
            comments = new ArrayList<CommentNode>();
            this.position.setComments(comments);
        }
        comments.add(comment);
    }

    public void addComments(Collection<CommentNode> moreComments) {
        Collection<CommentNode> comments = this.position.getComments();
        if (comments == EMPTY_COMMENT_LIST) {
            comments = new ArrayList<CommentNode>();
            this.position.setComments(comments);
        }
        comments.addAll(moreComments);
    }

    public Collection<CommentNode> getComments() {
        return this.position.getComments();
    }

    public boolean hasComments() {
        return this.getComments() != EMPTY_COMMENT_LIST;
    }

    public ISourcePosition getPositionIncludingComments() {
        if (!this.hasComments()) {
            return this.position;
        }
        String fileName = this.position.getFile();
        int startOffset = this.position.getStartOffset();
        int endOffset = this.position.getEndOffset();
        int startLine = this.position.getStartLine();
        int endLine = this.position.getEndLine();
        IDESourcePosition commentIncludingPos = new IDESourcePosition(fileName, startLine, endLine, startOffset, endOffset);
        for (CommentNode comment : this.getComments()) {
            commentIncludingPos = IDESourcePosition.combinePosition(commentIncludingPos, comment.getPosition());
        }
        return commentIncludingPos;
    }

    public boolean isInvisible() {
        return this instanceof InvisibleNode;
    }

    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        throw new RuntimeException(this.getClass().getSimpleName() + " should not be directly interpreted");
    }

    public IRubyObject assign(Ruby runtime, ThreadContext context, IRubyObject self, IRubyObject value, Block block, boolean checkArity) {
        throw new RuntimeException("Invalid node encountered in interpreter: \"" + this.getClass().getName() + "\", please report this at www.jruby.org");
    }

    public String definition(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        try {
            this.interpret(runtime, context, self, aBlock);
            return "expression";
        }
        catch (JumpException jumpExcptn) {
            return null;
        }
    }
}

