/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.ast.AssignableNode;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.types.INameNode;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.compiler.ASTInspector;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class LocalAsgnNode
extends AssignableNode
implements INameNode {
    private String name;
    private final int location;

    public LocalAsgnNode(ISourcePosition position, String name, int location, Node valueNode) {
        super(position, NodeType.LOCALASGNNODE, valueNode);
        this.name = name;
        this.location = location;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitLocalAsgnNode(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getDepth() {
        return this.location >> 16;
    }

    public int getIndex() {
        return this.location & 0xFFFF;
    }

    @Override
    public List<Node> childNodes() {
        return LocalAsgnNode.createList(this.getValueNode());
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        if (ASTInspector.PRAGMAS.contains(this.name)) {
            return runtime.getNil();
        }
        return context.getCurrentScope().setValue(this.getIndex(), this.getValueNode().interpret(runtime, context, self, aBlock), this.getDepth());
    }

    @Override
    public IRubyObject assign(Ruby runtime, ThreadContext context, IRubyObject self, IRubyObject value, Block block, boolean checkArity) {
        context.getCurrentScope().setValue(this.getIndex(), value, this.getDepth());
        return runtime.getNil();
    }
}

