/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.math.BigInteger;
import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyBignum;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.types.ILiteralNode;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class BignumNode
extends Node
implements ILiteralNode {
    private BigInteger value;

    public BignumNode(ISourcePosition position, BigInteger value) {
        super(position, NodeType.BIGNUMNODE);
        this.value = value;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitBignumNode(this);
    }

    public BigInteger getValue() {
        return this.value;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    public void setValue(BigInteger value) {
        this.value = value;
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        return RubyBignum.newBignum(runtime, this.value);
    }
}

