/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class ArgsPushNode
extends Node {
    private Node firstNode;
    private Node secondNode;

    public ArgsPushNode(ISourcePosition position, Node firstNode, Node secondNode) {
        super(position, NodeType.ARGSPUSHNODE);
        assert (firstNode != null) : "ArgsPushNode.first == null";
        assert (secondNode != null) : "ArgsPushNode.second == null";
        this.firstNode = firstNode;
        this.secondNode = secondNode;
    }

    @Override
    public Instruction accept(NodeVisitor visitor) {
        return visitor.visitArgsPushNode(this);
    }

    public Node getFirstNode() {
        return this.firstNode;
    }

    public Node getSecondNode() {
        return this.secondNode;
    }

    @Override
    public List<Node> childNodes() {
        return EMPTY_LIST;
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        RubyArray args = (RubyArray)this.firstNode.interpret(runtime, context, self, aBlock).dup();
        return args.append(this.secondNode.interpret(runtime, context, self, aBlock));
    }
}

