/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb;

import org.jruby.nb.Ruby;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyException;
import org.jruby.nb.RubyFixnum;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;

@JRubyClass(name={"SystemExit"}, parent="Exception")
public class RubySystemExit
extends RubyException {
    IRubyObject status;
    private static ObjectAllocator SYSTEMEXIT_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubySystemExit(runtime, klass);
        }
    };

    public static RubyClass createSystemExitClass(Ruby runtime, RubyClass exceptionClass) {
        RubyClass systemExitClass = runtime.defineClass("SystemExit", exceptionClass, SYSTEMEXIT_ALLOCATOR);
        systemExitClass.defineAnnotatedMethods(RubySystemExit.class);
        return systemExitClass;
    }

    public static RubySystemExit newInstance(Ruby runtime, int status) {
        RubyClass exc = runtime.getSystemExit();
        IRubyObject[] exArgs = new IRubyObject[]{runtime.newFixnum(status), runtime.newString("exit")};
        return (RubySystemExit)exc.newInstance(runtime.getCurrentContext(), exArgs, Block.NULL_BLOCK);
    }

    protected RubySystemExit(Ruby runtime, RubyClass exceptionClass) {
        super(runtime, exceptionClass);
        this.status = runtime.getNil();
    }

    @Override
    @JRubyMethod(name={"initialize"}, optional=2, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args, Block block) {
        this.status = RubyFixnum.zero(this.getRuntime());
        if (args.length > 0 && args[0] instanceof RubyFixnum) {
            this.status = args[0];
            IRubyObject[] tmpArgs = new IRubyObject[args.length - 1];
            System.arraycopy(args, 1, tmpArgs, 0, tmpArgs.length);
            args = tmpArgs;
        }
        super.initialize(args, block);
        return this;
    }

    @JRubyMethod(name={"status"})
    public IRubyObject status() {
        return this.status;
    }

    @JRubyMethod(name={"success?"})
    public IRubyObject success_p() {
        if (this.status.isNil()) {
            return this.getRuntime().getTrue();
        }
        if (this.status.equals(RubyFixnum.zero(this.getRuntime()))) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }
}

