/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb;

import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyBoolean;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyException;
import org.jruby.nb.RubyObject;
import org.jruby.nb.RubyString;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.exceptions.JumpException;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.CallType;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.util.Sprintf;

@JRubyClass(name={"NameError"}, parent="StandardError")
public class RubyNameError
extends RubyException {
    private IRubyObject name;
    private static ObjectAllocator NAMEERROR_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyNameError(runtime, klass);
        }
    };

    public static RubyClass createNameErrorClass(Ruby runtime, RubyClass standardErrorClass) {
        RubyClass nameErrorClass = runtime.defineClass("NameError", standardErrorClass, NAMEERROR_ALLOCATOR);
        nameErrorClass.defineAnnotatedMethods(RubyNameError.class);
        return nameErrorClass;
    }

    public static RubyClass createNameErrorMessageClass(Ruby runtime, RubyClass nameErrorClass) {
        RubyClass messageClass = nameErrorClass.defineClassUnder("Message", runtime.getObject(), RubyNameErrorMessage.NAMEERRORMESSAGE_ALLOCATOR);
        messageClass.defineAnnotatedMethods(RubyNameErrorMessage.class);
        return messageClass;
    }

    protected RubyNameError(Ruby runtime, RubyClass exceptionClass) {
        this(runtime, exceptionClass, exceptionClass.getName());
    }

    public RubyNameError(Ruby runtime, RubyClass exceptionClass, String message) {
        this(runtime, exceptionClass, message, null);
    }

    public RubyNameError(Ruby runtime, RubyClass exceptionClass, String message, String name) {
        super(runtime, exceptionClass, message);
        this.name = name == null ? runtime.getNil() : runtime.newString(name);
    }

    @JRubyMethod(name={"exception"}, rest=true, meta=true)
    public static RubyException newRubyNameError(IRubyObject recv, IRubyObject[] args) {
        RubyClass klass = (RubyClass)recv;
        RubyException newError = (RubyException)klass.allocate();
        newError.callInit(args, Block.NULL_BLOCK);
        return newError;
    }

    @Override
    @JRubyMethod(name={"initialize"}, optional=2, frame=true)
    public IRubyObject initialize(IRubyObject[] args, Block block) {
        if (args.length > 1) {
            this.name = args[args.length - 1];
            int newLength = args.length > 2 ? args.length - 2 : args.length - 1;
            IRubyObject[] tmpArgs = new IRubyObject[newLength];
            System.arraycopy(args, 0, tmpArgs, 0, newLength);
            args = tmpArgs;
        } else {
            this.name = this.getRuntime().getNil();
        }
        super.initialize(args, block);
        return this;
    }

    @Override
    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s() {
        if (this.message.isNil()) {
            return this.getRuntime().newString(this.message.getMetaClass().getName());
        }
        RubyString str = this.message.convertToString();
        if (str != this.message) {
            this.message = str;
        }
        if (this.isTaint()) {
            this.message.setTaint(true);
        }
        return this.message;
    }

    @JRubyMethod(name={"name"})
    public IRubyObject name() {
        return this.name;
    }

    @JRubyClass(name={"NameError::Message"}, parent="Object")
    public static final class RubyNameErrorMessage
    extends RubyObject {
        static ObjectAllocator NAMEERRORMESSAGE_ALLOCATOR = new ObjectAllocator(){

            @Override
            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                RubyObject dummy = new RubyObject(runtime, runtime.getObject());
                return new RubyNameErrorMessage(runtime, dummy, dummy, Visibility.PRIVATE, CallType.VARIABLE);
            }
        };
        private final IRubyObject object;
        private final IRubyObject method;
        private final Visibility visibility;
        private final CallType callType;

        RubyNameErrorMessage(Ruby runtime, IRubyObject object, IRubyObject method, Visibility visibility, CallType callType) {
            super(runtime, runtime.getNameErrorMessage(), false);
            this.object = object;
            this.method = method;
            this.visibility = visibility;
            this.callType = callType;
        }

        @JRubyMethod(name={"_load"}, meta=true)
        public static IRubyObject load(IRubyObject recv, IRubyObject arg) {
            return arg;
        }

        @JRubyMethod(name={"_dump"})
        public IRubyObject dump(ThreadContext context, IRubyObject arg) {
            return this.to_str(context);
        }

        @JRubyMethod(name={"to_str"})
        public IRubyObject to_str(ThreadContext context) {
            String format = null;
            if (this.visibility == Visibility.PRIVATE) {
                format = "private method `%s' called for %s";
            } else if (this.visibility == Visibility.PROTECTED) {
                format = "protected method `%s' called for %s";
            } else if (this.callType == CallType.VARIABLE) {
                format = "undefined local variable or method `%s' for %s";
            } else if (this.callType == CallType.SUPER) {
                format = "super: no superclass method `%s'";
            }
            if (format == null) {
                format = "undefined method `%s' for %s";
            }
            String description = null;
            if (this.object.isNil()) {
                description = "nil";
            } else if (this.object instanceof RubyBoolean && this.object.isTrue()) {
                description = "true";
            } else if (this.object instanceof RubyBoolean && !this.object.isTrue()) {
                description = "false";
            } else {
                try {
                    description = RubyObject.inspect(context, this.object).toString();
                }
                catch (JumpException e) {
                    // empty catch block
                }
                if (description == null || description.length() > 65) {
                    description = this.object.anyToString().toString();
                }
            }
            if (description.length() == 0 || description.length() > 0 && description.charAt(0) != '#') {
                description = description + ":" + this.object.getMetaClass().getRealClass().getName();
            }
            Ruby runtime = this.getRuntime();
            RubyArray arr = runtime.newArray(this.method, runtime.newString(description));
            RubyString msg = runtime.newString(((Object)Sprintf.sprintf(runtime.newString(format), (IRubyObject)arr)).toString());
            if (this.object.isTaint()) {
                msg.setTaint(true);
            }
            return msg;
        }
    }
}

