/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb;

import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyArray;
import org.jruby.nb.RubyClass;
import org.jruby.nb.RubyObject;
import org.jruby.nb.RubyString;
import org.jruby.nb.anno.JRubyClass;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.MethodIndex;
import org.jruby.nb.runtime.ObjectAllocator;
import org.jruby.nb.runtime.ObjectMarshal;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.runtime.builtin.Variable;
import org.jruby.nb.runtime.component.VariableEntry;
import org.jruby.nb.runtime.marshal.MarshalStream;
import org.jruby.nb.runtime.marshal.UnmarshalStream;
import org.jruby.nb.util.SafePropertyAccessor;

@JRubyClass(name={"Exception"})
public class RubyException
extends RubyObject {
    private StackTraceElement[] backtraceFrames;
    private StackTraceElement[] javaStackTrace;
    private IRubyObject backtrace;
    public IRubyObject message;
    public static final int TRACE_HEAD = 8;
    public static final int TRACE_TAIL = 4;
    public static final int TRACE_MAX = 18;
    private static ObjectAllocator EXCEPTION_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            RubyException instance = new RubyException(runtime, klass);
            instance.setMetaClass(klass);
            return instance;
        }
    };
    private static final ObjectMarshal EXCEPTION_MARSHAL = new ObjectMarshal(){

        @Override
        public void marshalTo(Ruby runtime, Object obj, RubyClass type, MarshalStream marshalStream) throws IOException {
            RubyException exc = (RubyException)obj;
            marshalStream.registerLinkTarget(exc);
            List<Variable<IRubyObject>> attrs = exc.getVariableList();
            attrs.add(new VariableEntry<IRubyObject>("mesg", exc.message == null ? runtime.getNil() : exc.message));
            attrs.add(new VariableEntry<IRubyObject>("bt", exc.getBacktrace()));
            marshalStream.dumpVariables(attrs);
        }

        @Override
        public Object unmarshalFrom(Ruby runtime, RubyClass type, UnmarshalStream unmarshalStream) throws IOException {
            RubyException exc = (RubyException)type.allocate();
            unmarshalStream.registerLinkTarget(exc);
            unmarshalStream.defaultVariablesUnmarshal(exc);
            exc.message = exc.removeInternalVariable("mesg");
            exc.set_backtrace(exc.removeInternalVariable("bt"));
            return exc;
        }
    };
    public static final int RAW = 0;
    public static final int RAW_FILTERED = 1;
    public static final int RUBY_FRAMED = 2;
    public static final int RUBY_COMPILED = 3;
    public static final int RUBY_HYBRID = 4;
    public static final int TRACE_TYPE;

    protected RubyException(Ruby runtime, RubyClass rubyClass) {
        this(runtime, rubyClass, null);
    }

    public RubyException(Ruby runtime, RubyClass rubyClass, String message) {
        super(runtime, rubyClass);
        this.message = message == null ? runtime.getNil() : runtime.newString(message);
    }

    public static RubyClass createExceptionClass(Ruby runtime) {
        RubyClass exceptionClass = runtime.defineClass("Exception", runtime.getObject(), EXCEPTION_ALLOCATOR);
        runtime.setException(exceptionClass);
        exceptionClass.setMarshal(EXCEPTION_MARSHAL);
        exceptionClass.defineAnnotatedMethods(RubyException.class);
        return exceptionClass;
    }

    public static RubyException newException(Ruby runtime, RubyClass excptnClass, String msg) {
        return new RubyException(runtime, excptnClass, msg);
    }

    public void setBacktraceFrames(StackTraceElement[] backtraceFrames) {
        this.backtraceFrames = backtraceFrames;
        if (TRACE_TYPE == 0 || TRACE_TYPE == 1 || TRACE_TYPE == 3 || TRACE_TYPE == 4) {
            this.javaStackTrace = Thread.currentThread().getStackTrace();
        }
    }

    public IRubyObject getBacktrace() {
        if (this.backtrace == null) {
            this.initBacktrace();
        }
        return this.backtrace;
    }

    public void initBacktrace() {
        switch (TRACE_TYPE) {
            case 0: {
                this.backtrace = ThreadContext.createRawBacktrace(this.getRuntime(), this.javaStackTrace, false);
                break;
            }
            case 1: {
                this.backtrace = ThreadContext.createRawBacktrace(this.getRuntime(), this.javaStackTrace, true);
                break;
            }
            case 2: {
                this.backtrace = this.backtraceFrames == null ? this.getRuntime().getNil() : ThreadContext.createBacktraceFromFrames(this.getRuntime(), this.backtraceFrames);
                break;
            }
            case 3: {
                this.backtrace = ThreadContext.createRubyCompiledBacktrace(this.getRuntime(), this.javaStackTrace);
                break;
            }
            case 4: {
                this.backtrace = ThreadContext.createRubyHybridBacktrace(this.getRuntime(), this.backtraceFrames, this.javaStackTrace, this.getRuntime().getDebug().isTrue());
            }
        }
    }

    @JRubyMethod(optional=2, frame=true, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(IRubyObject[] args, Block block) {
        if (args.length == 1) {
            this.message = args[0];
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject backtrace() {
        return this.getBacktrace();
    }

    @JRubyMethod(required=1)
    public IRubyObject set_backtrace(IRubyObject obj) {
        if (obj.isNil()) {
            this.backtrace = null;
        } else {
            if (!this.isArrayOfStrings(obj)) {
                throw this.getRuntime().newTypeError("backtrace must be Array of String");
            }
            this.backtrace = (RubyArray)obj;
        }
        return this.backtrace();
    }

    @JRubyMethod(name={"exception"}, optional=1, rest=true, meta=true)
    public static IRubyObject exception(ThreadContext context, IRubyObject recv, IRubyObject[] args, Block block) {
        return ((RubyClass)recv).newInstance(context, args, block);
    }

    @JRubyMethod(optional=1)
    public RubyException exception(IRubyObject[] args) {
        switch (args.length) {
            case 0: {
                return this;
            }
            case 1: {
                if (args[0] == this) {
                    return this;
                }
                RubyException ret = (RubyException)this.rbClone();
                ret.initialize(args, Block.NULL_BLOCK);
                return ret;
            }
        }
        throw this.getRuntime().newArgumentError("Wrong argument count");
    }

    @Override
    @JRubyMethod
    public IRubyObject to_s() {
        if (this.message.isNil()) {
            return this.getRuntime().newString(this.getMetaClass().getName());
        }
        this.message.setTaint(this.isTaint());
        return this.message;
    }

    @JRubyMethod(name={"to_str", "message"})
    public IRubyObject to_str(ThreadContext context) {
        return this.callMethod(context, MethodIndex.TO_S, "to_s");
    }

    @JRubyMethod
    public IRubyObject inspect(ThreadContext context) {
        RubyClass rubyClass = this.getMetaClass();
        RubyString exception = RubyString.objAsString(context, this);
        if (exception.getByteList().realSize == 0) {
            return this.getRuntime().newString(rubyClass.getName());
        }
        StringBuilder sb = new StringBuilder("#<");
        sb.append(rubyClass.getName()).append(": ").append((CharSequence)exception.getByteList()).append(">");
        return this.getRuntime().newString(sb.toString());
    }

    public void printBacktrace(PrintStream errorStream) {
        IRubyObject backtrace = this.callMethod(this.getRuntime().getCurrentContext(), "backtrace");
        boolean debug = this.getRuntime().getDebug().isTrue();
        if (!backtrace.isNil() && backtrace instanceof RubyArray) {
            IRubyObject[] elements = backtrace.convertToArray().toJavaArray();
            for (int i = 1; i < elements.length; ++i) {
                IRubyObject stackTraceLine = elements[i];
                if (stackTraceLine instanceof RubyString) {
                    this.printStackTraceLine(errorStream, stackTraceLine);
                }
                if (debug || i != 8 || elements.length <= 18) continue;
                int hiddenLevels = elements.length - 8 - 4;
                errorStream.print("\t ... " + hiddenLevels + " levels...\n");
                i = elements.length - 4;
            }
        }
    }

    private void printStackTraceLine(PrintStream errorStream, IRubyObject stackTraceLine) {
        errorStream.print("\tfrom " + stackTraceLine + '\n');
    }

    private boolean isArrayOfStrings(IRubyObject backtrace) {
        if (!(backtrace instanceof RubyArray)) {
            return false;
        }
        IRubyObject[] elements = ((RubyArray)backtrace).toJavaArray();
        for (int i = 0; i < elements.length; ++i) {
            if (elements[i] instanceof RubyString) continue;
            return false;
        }
        return true;
    }

    static {
        String style = SafePropertyAccessor.getProperty("jruby.backtrace.style", "ruby_framed").toLowerCase();
        TRACE_TYPE = style.equals("raw") ? 0 : (style.equals("raw_filtered") ? 1 : (style.equals("ruby_framed") ? 2 : (style.equals("ruby_compiled") ? 3 : (style.equals("ruby_hybrid") ? 4 : 2))));
    }
}

