/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.container.initialization;

import java.io.File;
import java.net.MalformedURLException;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.container.initialization.AbstractContainerInitializationPhase;
import org.codehaus.plexus.container.initialization.ContainerInitializationContext;
import org.codehaus.plexus.container.initialization.ContainerInitializationException;

public class InitializeResourcesPhase
extends AbstractContainerInitializationPhase {
    public void execute(ContainerInitializationContext context) throws ContainerInitializationException {
        PlexusConfiguration[] resourceConfigs = context.getContainer().getConfiguration().getChild("resources").getChildren();
        int i = 0;
        while (i < resourceConfigs.length) {
            try {
                String name = resourceConfigs[i].getName();
                if (name.equals("jar-repository")) {
                    context.getContainer().addJarRepository(new File(resourceConfigs[i].getValue(null)));
                } else if (name.equals("directory")) {
                    File directory = new File(resourceConfigs[i].getValue(null));
                    if (directory.exists() && directory.isDirectory()) {
                        context.getContainer().getContainerRealm().addURL(directory.toURI().toURL());
                    }
                } else {
                    context.getContainer().getLogger().warn("Unknown resource type: " + name);
                }
            }
            catch (MalformedURLException e) {
                String message = "Error configuring resource: " + resourceConfigs[i].getName() + "=" + resourceConfigs[i].getValue(null);
                if (context.getContainer().getLogger() != null) {
                    context.getContainer().getLogger().error(message, e);
                }
                System.out.println(message);
            }
            ++i;
        }
    }
}

