/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui.tree;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.swing.Icon;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.java.source.ui.ElementIcons;
import org.netbeans.modules.refactoring.java.ui.tree.ElementGripFactory;
import org.openide.filesystems.FileObject;

public final class ElementGrip {
    private TreePathHandle delegateElementHandle;
    private ElementHandle handle;
    private String toString;
    private FileObject fileObject;
    private Icon icon;

    public ElementGrip(TreePath treePath, CompilationInfo compilationInfo) {
        this(TreePathHandle.create((TreePath)treePath, (CompilationInfo)compilationInfo), compilationInfo.getTrees().getElement(treePath), compilationInfo);
    }

    public ElementGrip(Element element, CompilationInfo compilationInfo) {
        this(TreePathHandle.create((Element)element, (CompilationInfo)compilationInfo), element, compilationInfo);
    }

    private ElementGrip(TreePathHandle treePathHandle, Element element, CompilationInfo compilationInfo) {
        this.delegateElementHandle = treePathHandle;
        ElementHandle elementHandle = this.handle = element == null ? null : ElementHandle.create((Element)element);
        if (element != null) {
            this.toString = element.getKind() != ElementKind.CONSTRUCTOR ? element.getSimpleName().toString() : element.getEnclosingElement().getSimpleName().toString();
        }
        this.fileObject = compilationInfo.getFileObject();
        if (element != null) {
            this.icon = ElementIcons.getElementIcon((ElementKind)element.getKind(), element.getModifiers());
        }
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String toString() {
        return this.toString;
    }

    public ElementGrip getParent() {
        return ElementGripFactory.getDefault().getParent(this);
    }

    public TreePath resolve(CompilationInfo compilationInfo) {
        return this.delegateElementHandle.resolve(compilationInfo);
    }

    public Element resolveElement(CompilationInfo compilationInfo) {
        return this.handle == null ? null : this.handle.resolve(compilationInfo);
    }

    public Tree.Kind getKind() {
        return this.delegateElementHandle.getKind();
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    public TreePathHandle getHandle() {
        return this.delegateElementHandle;
    }
}

