/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.api.MemberInfo;
import org.netbeans.modules.refactoring.java.api.PushDownRefactoring;
import org.netbeans.modules.refactoring.java.ui.UIUtilities;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class PushDownPanel
extends JPanel
implements CustomRefactoringPanel {
    private static final String[] COLUMN_NAMES = new String[]{"LBL_PullUp_Selected", "LBL_PullUp_Member", "LBL_PushDown_KeepAbstract"};
    private static final Class[] COLUMN_CLASSES = new Class[]{Boolean.class, MemberInfo.class, Boolean.class};
    private final PushDownRefactoring refactoring;
    private final TableModel tableModel;
    private Set selectedMembers;
    private TreePathHandle originalType;
    private Object[][] members = new Object[0][0];
    private ElementKind sourceKind;
    private ChangeListener parent;
    private JLabel chooseLabel;
    private JScrollPane membersScrollPane;
    private JTable membersTable;

    public PushDownPanel(PushDownRefactoring pushDownRefactoring, Set set, ChangeListener changeListener) {
        this.refactoring = pushDownRefactoring;
        this.tableModel = new TableModel();
        this.selectedMembers = set;
        this.initComponents();
        this.setPreferredSize(new Dimension(420, 380));
        this.parent = changeListener;
    }

    public void initialize() {
        final TreePathHandle treePathHandle = this.refactoring.getSourceType();
        JavaSource javaSource = JavaSource.forFileObject((FileObject)treePathHandle.getFileObject());
        try {
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                /*
                 * WARNING - void declaration
                 */
                public void run(CompilationController compilationController) throws Exception {
                    void var5_9;
                    compilationController.toPhase(JavaSource.Phase.RESOLVED);
                    ArrayList<MemberInfo<Object>> arrayList = new ArrayList<MemberInfo<Object>>();
                    TypeElement typeElement = (TypeElement)treePathHandle.resolveElement((CompilationInfo)compilationController);
                    PushDownPanel.this.sourceKind = typeElement.getKind();
                    for (TypeMirror annotatedConstruct : typeElement.getInterfaces()) {
                        arrayList.add(MemberInfo.create(RetoucheUtils.typeToElement(annotatedConstruct, (CompilationInfo)compilationController), (CompilationInfo)compilationController, MemberInfo.Group.IMPLEMENTS));
                    }
                    for (Element element : typeElement.getEnclosedElements()) {
                        if (element.getKind() == ElementKind.CONSTRUCTOR || element.getKind() == ElementKind.STATIC_INIT || element.getKind() == ElementKind.INSTANCE_INIT || element instanceof TypeElement && compilationController.getTypes().isSubtype(element.asType(), typeElement.asType())) continue;
                        arrayList.add(MemberInfo.create(element, (CompilationInfo)compilationController));
                    }
                    Iterator<AnnotatedConstruct> iterator = new Object[arrayList.size()][3];
                    boolean bl = false;
                    for (MemberInfo memberInfo : arrayList) {
                        iterator[var5_9][0] = PushDownPanel.this.selectedMembers.contains(memberInfo) ? Boolean.TRUE : Boolean.FALSE;
                        iterator[var5_9][1] = memberInfo;
                        iterator[var5_9][2] = ((ElementHandle)memberInfo.getElementHandle()).getKind() == ElementKind.METHOD ? Boolean.FALSE : null;
                        ++var5_9;
                    }
                    PushDownPanel.access$302(PushDownPanel.this, new Object[var5_9][3]);
                    if (var5_9 > 0) {
                        System.arraycopy(iterator, 0, PushDownPanel.this.members, 0, (int)var5_9);
                    }
                    PushDownPanel.this.membersTable.setDefaultRenderer(COLUMN_CLASSES[1], new UIUtilities.JavaElementTableCellRenderer(){

                        @Override
                        protected String extractText(Object object) {
                            String string = super.extractText(object);
                            if (object instanceof MemberInfo && ((MemberInfo)object).getGroup() == MemberInfo.Group.IMPLEMENTS) {
                                string = "implements " + string;
                            }
                            return string;
                        }
                    });
                    PushDownPanel.this.membersTable.getColumnModel().getColumn(2).setCellRenderer(new UIUtilities.BooleanTableCellRenderer(PushDownPanel.this.membersTable){

                        @Override
                        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                            MemberInfo memberInfo = (MemberInfo)jTable.getModel().getValueAt(n, 1);
                            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                        }
                    });
                    PushDownPanel.this.membersScrollPane.setBackground(PushDownPanel.this.membersTable.getBackground());
                    PushDownPanel.this.membersScrollPane.getViewport().setBackground(PushDownPanel.this.membersTable.getBackground());
                    PushDownPanel.this.membersTable.setRowHeight(18);
                    if (UIManager.getColor("control") != null) {
                        PushDownPanel.this.membersTable.setGridColor(UIManager.getColor("control"));
                    }
                    UIUtilities.initColumnWidth(PushDownPanel.this.membersTable, 0, Boolean.TRUE, 4);
                    UIUtilities.initColumnWidth(PushDownPanel.this.membersTable, 2, Boolean.TRUE, 4);
                }
            }, true);
        }
        catch (IOException iOException) {
            throw (RuntimeException)new RuntimeException().initCause(iOException);
        }
        this.parent.stateChanged(null);
    }

    public MemberInfo[] getMembers() {
        ArrayList<MemberInfo> arrayList = new ArrayList<MemberInfo>();
        for (int i = 0; i < this.members.length; ++i) {
            if (!this.members[i][0].equals(Boolean.TRUE)) continue;
            Object object = this.members[i][1];
            MemberInfo memberInfo = (MemberInfo)object;
            if (this.members[i][2] != null) {
                memberInfo.setMakeAbstract((Boolean)this.members[i][2]);
            }
            arrayList.add(memberInfo);
        }
        return arrayList.toArray(new MemberInfo[arrayList.size()]);
    }

    private void initComponents() {
        this.membersScrollPane = new JScrollPane();
        this.membersTable = new JTable();
        this.chooseLabel = new JLabel();
        this.setLayout(new BorderLayout());
        this.membersScrollPane.setToolTipText("");
        this.membersTable.setModel(this.tableModel);
        this.membersScrollPane.setViewportView(this.membersTable);
        this.membersTable.getAccessibleContext().setAccessibleName(null);
        this.membersTable.getAccessibleContext().setAccessibleDescription(null);
        this.add((Component)this.membersScrollPane, "Center");
        this.chooseLabel.setLabelFor(this.membersTable);
        Mnemonics.setLocalizedText((JLabel)this.chooseLabel, (String)NbBundle.getMessage(PushDownPanel.class, (String)"LBL_PushDownLabel"));
        this.add((Component)this.chooseLabel, "North");
    }

    public Component getComponent() {
        return this;
    }

    static /* synthetic */ Object[][] access$302(PushDownPanel pushDownPanel, Object[][] objectArray) {
        pushDownPanel.members = objectArray;
        return objectArray;
    }

    private class TableModel
    extends AbstractTableModel {
        private TableModel() {
        }

        @Override
        public int getColumnCount() {
            return COLUMN_NAMES.length;
        }

        @Override
        public String getColumnName(int n) {
            return UIUtilities.getColumnName(NbBundle.getMessage(PushDownPanel.class, (String)COLUMN_NAMES[n]));
        }

        public Class getColumnClass(int n) {
            return COLUMN_CLASSES[n];
        }

        @Override
        public int getRowCount() {
            return PushDownPanel.this.members.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return PushDownPanel.this.members[n][n2];
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            ((PushDownPanel)PushDownPanel.this).members[n][n2] = object;
            PushDownPanel.this.parent.stateChanged(null);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (n2 == 2) {
                if (PushDownPanel.this.members[n][2] == null) {
                    return false;
                }
                Object object = PushDownPanel.this.members[n][1];
                return !((MemberInfo)object).getModifiers().contains((Object)Modifier.STATIC);
            }
            return n2 == 0;
        }
    }
}

