/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.modules.refactoring.spi.BackupFacility;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

public class RetoucheCommit
implements Transaction {
    private static final Logger LOG = Logger.getLogger(RetoucheCommit.class.getName());
    List<BackupFacility.Handle> ids = new ArrayList<BackupFacility.Handle>();
    private boolean commited = false;
    Collection<ModificationResult> results;
    private Set<File> newFiles;
    private boolean newFilesStored = false;

    public RetoucheCommit(Collection<ModificationResult> collection) {
        this.results = collection;
    }

    public void commit() {
        try {
            if (this.commited) {
                for (BackupFacility.Handle handle : this.ids) {
                    try {
                        handle.restore();
                    }
                    catch (IOException iOException) {
                        throw (RuntimeException)new RuntimeException().initCause(iOException);
                    }
                }
            } else {
                this.commited = true;
                for (ModificationResult modificationResult : this.results) {
                    this.ids.add(BackupFacility.getDefault().backup((Collection)modificationResult.getModifiedFileObjects()));
                    if (this.newFiles == null) {
                        this.newFiles = new HashSet<File>();
                    }
                    this.newFiles.addAll(modificationResult.getNewFiles());
                    modificationResult.commit();
                }
                RetoucheCommit.openNewFiles(this.newFiles);
            }
        }
        catch (IOException iOException) {
            throw (RuntimeException)new RuntimeException().initCause(iOException);
        }
    }

    public void rollback() {
        for (BackupFacility.Handle object : this.ids) {
            try {
                object.restore();
            }
            catch (IOException file) {
                throw (RuntimeException)new RuntimeException().initCause(file);
            }
        }
        boolean bl = false;
        if (this.newFiles != null) {
            for (File file : this.newFiles) {
                try {
                    FileObject iOException = FileUtil.toFileObject((File)file);
                    if (!this.newFilesStored) {
                        this.ids.add(BackupFacility.getDefault().backup(new FileObject[]{iOException}));
                        bl = true;
                    }
                    iOException.delete();
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            this.newFilesStored |= bl;
        }
    }

    private static void openNewFiles(Set<File> set) {
        if (set == null) {
            return;
        }
        for (File file : set) {
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (fileObject == null) continue;
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                EditorCookie editorCookie = (EditorCookie)dataObject.getLookup().lookup(EditorCookie.class);
                if (editorCookie == null) continue;
                editorCookie.open();
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                LOG.log(Level.INFO, dataObjectNotFoundException.getMessage(), dataObjectNotFoundException);
            }
        }
    }
}

