/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import java.io.IOException;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.api.PushDownRefactoring;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.plugins.PushDownTransformer;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class PushDownRefactoringPlugin
extends JavaRefactoringPlugin {
    private final PushDownRefactoring refactoring;
    private TreePathHandle treePathHandle;

    public PushDownRefactoringPlugin(PushDownRefactoring pushDownRefactoring) {
        this.refactoring = pushDownRefactoring;
        this.treePathHandle = pushDownRefactoring.getSourceType();
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase phase) {
        switch (phase) {
            default: 
        }
        return JavaSource.forFileObject((FileObject)this.treePathHandle.getFileObject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Problem preCheck(CompilationController compilationController) throws IOException {
        this.fireProgressListenerStart(1, 4);
        try {
            compilationController.toPhase(JavaSource.Phase.RESOLVED);
            Problem problem = PushDownRefactoringPlugin.isElementAvail(this.treePathHandle, (CompilationInfo)compilationController);
            if (problem != null) {
                Problem problem2 = problem;
                return problem2;
            }
            this.fireProgressListenerStep();
            Element element = this.treePathHandle.resolveElement((CompilationInfo)compilationController);
            problem = JavaPluginUtils.isSourceElement(element, (CompilationInfo)compilationController);
            if (problem != null) {
                Problem problem3 = problem;
                return problem3;
            }
            if (!(element instanceof TypeElement)) {
                Problem problem4 = new Problem(true, NbBundle.getMessage(PushDownRefactoringPlugin.class, (String)"ERR_PushDown_InvalidSource", (Object)this.treePathHandle, (Object)element));
                return problem4;
            }
            ElementHandle elementHandle = ElementHandle.create((Element)((TypeElement)element));
            Set set = compilationController.getClasspathInfo().getClassIndex().getResources(elementHandle, EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE));
            if (set.isEmpty()) {
                Problem problem5 = new Problem(true, NbBundle.getMessage(PushDownRefactoringPlugin.class, (String)"ERR_PushDOwn_NoSubtype"));
                return problem5;
            }
            this.fireProgressListenerStep();
            for (Element element2 : element.getEnclosedElements()) {
                if (element2.getKind() == ElementKind.CONSTRUCTOR) continue;
                Problem problem6 = null;
                return problem6;
            }
            problem = new Problem(true, NbBundle.getMessage(PushDownRefactoringPlugin.class, (String)"ERR_PushDown_NoMembers"));
            this.fireProgressListenerStep();
            Problem problem7 = problem;
            return problem7;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    @Override
    public Problem checkParameters() {
        return null;
    }

    @Override
    protected Problem fastCheckParameters(CompilationController compilationController) {
        if (this.refactoring.getMembers().length == 0) {
            return new Problem(true, NbBundle.getMessage(PushDownRefactoringPlugin.class, (String)"ERR_PushDown_NoMembersSelected"));
        }
        return null;
    }

    private Set<FileObject> getRelevantFiles(TreePathHandle treePathHandle) {
        ClasspathInfo classpathInfo = this.getClasspathInfo(this.refactoring);
        ClassIndex classIndex = classpathInfo.getClassIndex();
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        hashSet.add(RetoucheUtils.getFileObject(treePathHandle));
        hashSet.addAll(classIndex.getResources(RetoucheUtils.getElementHandle(treePathHandle), EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE)));
        return hashSet;
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        Set<FileObject> set = this.getRelevantFiles(this.treePathHandle);
        this.fireProgressListenerStart(1, set.size());
        PushDownTransformer pushDownTransformer = new PushDownTransformer(this.refactoring.getMembers());
        JavaRefactoringPlugin.TransformTask transformTask = new JavaRefactoringPlugin.TransformTask(this, pushDownTransformer, this.treePathHandle);
        Problem problem = this.createAndAddElements(set, transformTask, refactoringElementsBag, this.refactoring);
        this.fireProgressListenerStop();
        return problem != null ? problem : pushDownTransformer.getProblem();
    }

    protected FileObject getFileObject() {
        return this.treePathHandle.getFileObject();
    }
}

