/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.classpath;

import java.net.URL;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.support.PathResourceBase;

public final class SimplePathResourceImplementation
extends PathResourceBase {
    private URL url;

    public static void verify(URL root, String context) throws IllegalArgumentException {
        SimplePathResourceImplementation.verify(root, context, null);
    }

    public static void verify(URL root, String context, Throwable initiatedIn) throws IllegalArgumentException {
        if (context == null) {
            context = "";
        }
        if (root == null) {
            IllegalArgumentException iae = new IllegalArgumentException("Root cannot be null." + context);
            if (initiatedIn != null) {
                iae.initCause(initiatedIn);
            }
            throw iae;
        }
        String rootS = root.toString();
        if (rootS.matches("file:.+[.]jar/?")) {
            IllegalArgumentException iae = new IllegalArgumentException(rootS + " is not a valid classpath entry; use a jar-protocol URL." + context);
            if (initiatedIn != null) {
                iae.initCause(initiatedIn);
            }
            throw iae;
        }
        if (!rootS.endsWith("/")) {
            IllegalArgumentException iae = new IllegalArgumentException(rootS + " is not a valid classpath entry; it must end with a slash." + context);
            if (initiatedIn != null) {
                iae.initCause(initiatedIn);
            }
            throw iae;
        }
    }

    public SimplePathResourceImplementation(URL root) {
        SimplePathResourceImplementation.verify(root, null);
        this.url = root;
    }

    @Override
    public URL[] getRoots() {
        return new URL[]{this.url};
    }

    @Override
    public ClassPathImplementation getContent() {
        return null;
    }

    public String toString() {
        return "SimplePathResource{" + this.url + "}";
    }

    public int hashCode() {
        return this.url.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof SimplePathResourceImplementation) {
            SimplePathResourceImplementation opr = (SimplePathResourceImplementation)other;
            return this.url.equals(opr.url);
        }
        return false;
    }
}

