/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.junit.AbstractTestGenerator;
import org.netbeans.modules.junit.ClassMap;
import org.netbeans.modules.junit.TestGeneratorSetup;
import org.netbeans.modules.junit.TestUtil;

final class JUnit3TestGenerator
extends AbstractTestGenerator {
    private static final String TEST = "junit.framework.Test";
    private static final String TEST_CASE = "junit.framework.TestCase";
    private static final String TEST_SUITE = "junit.framework.TestSuite";
    private static final String OVERRIDE = "java.lang.Override";
    private final boolean useAnnotations;
    private TypeElement testTypeElem;

    JUnit3TestGenerator(TestGeneratorSetup testGeneratorSetup, String string) {
        super(testGeneratorSetup);
        this.useAnnotations = TestUtil.areAnnotationsSupported(string);
    }

    JUnit3TestGenerator(TestGeneratorSetup testGeneratorSetup, List<ElementHandle<TypeElement>> list, List<String> list2, boolean bl, String string) {
        super(testGeneratorSetup, list, list2, bl);
        this.useAnnotations = TestUtil.areAnnotationsSupported(string);
    }

    @Override
    protected ClassTree composeNewTestClass(WorkingCopy workingCopy, String string, List<? extends Tree> list) {
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        ModifiersTree modifiersTree = treeMaker.Modifiers(Collections.singleton(Modifier.PUBLIC));
        ExpressionTree expressionTree = this.getClassIdentifierTree(TEST_CASE, workingCopy);
        return treeMaker.Class(modifiersTree, (CharSequence)string, Collections.emptyList(), (Tree)expressionTree, Collections.emptyList(), list);
    }

    @Override
    protected List<? extends Tree> generateInitMembers(WorkingCopy workingCopy) {
        if (!this.setup.isGenerateSetUp() && !this.setup.isGenerateTearDown()) {
            return Collections.emptyList();
        }
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        ArrayList<MethodTree> arrayList = new ArrayList<MethodTree>(2);
        if (this.setup.isGenerateSetUp()) {
            arrayList.add(this.generateInitMethod("setUp", treeMaker, workingCopy));
        }
        if (this.setup.isGenerateTearDown()) {
            arrayList.add(this.generateInitMethod("tearDown", treeMaker, workingCopy));
        }
        return arrayList;
    }

    @Override
    protected ClassTree generateMissingInitMembers(ClassTree classTree, TreePath treePath, WorkingCopy workingCopy) {
        if (!(this.setup.isGenerateSetUp() || this.setup.isGenerateTearDown() || this.setup.isGenerateSuiteClasses())) {
            return classTree;
        }
        ClassMap classMap = ClassMap.forClass(classTree, treePath, workingCopy.getTrees());
        if (!(this.setup.isGenerateSetUp() && !classMap.containsSetUp() || this.setup.isGenerateTearDown() && !classMap.containsTearDown() || this.setup.isGenerateSuiteClasses() && !classMap.containsNoArgMethod("suite"))) {
            return classTree;
        }
        List<? extends Tree> list = classTree.getMembers();
        ArrayList<Tree> arrayList = new ArrayList<Tree>(list.size() + 2);
        arrayList.addAll(list);
        this.generateMissingInitMembers(arrayList, classMap, workingCopy);
        this.generateTestClassSuiteMethod(treePath, arrayList, classMap, workingCopy);
        ClassTree classTree2 = workingCopy.getTreeMaker().Class(classTree.getModifiers(), (CharSequence)classTree.getSimpleName(), classTree.getTypeParameters(), classTree.getExtendsClause(), classTree.getImplementsClause(), arrayList);
        return classTree2;
    }

    @Override
    protected boolean generateMissingInitMembers(List<Tree> list, ClassMap classMap, WorkingCopy workingCopy) {
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        boolean bl = false;
        if (this.setup.isGenerateSetUp() && !classMap.containsSetUp()) {
            this.addInitMethod("setUp", classMap.getTearDownIndex(), list, classMap, treeMaker, workingCopy);
            bl = true;
        }
        if (this.setup.isGenerateTearDown() && !classMap.containsTearDown()) {
            int n = classMap.getSetUpIndex();
            this.addInitMethod("tearDown", n != -1 ? n + 1 : -1, list, classMap, treeMaker, workingCopy);
            bl = true;
        }
        return bl;
    }

    private void addInitMethod(String string, int n, List<Tree> list, ClassMap classMap, TreeMaker treeMaker, WorkingCopy workingCopy) {
        MethodTree methodTree = this.generateInitMethod(string, treeMaker, workingCopy);
        if (n == -1) {
            n = this.getPlaceForFirstInitMethod(classMap);
        }
        if (n != -1) {
            list.add(n, methodTree);
        } else {
            list.add(methodTree);
        }
        classMap.addNoArgMethod(string, n);
    }

    protected MethodTree generateInitMethod(String string, TreeMaker treeMaker, WorkingCopy workingCopy) {
        Set<Modifier> set = Collections.singleton(Modifier.PROTECTED);
        ModifiersTree modifiersTree = this.useAnnotations ? this.createModifiersTree(OVERRIDE, set, workingCopy) : treeMaker.Modifiers(set);
        MethodInvocationTree methodInvocationTree = treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)"super"), (CharSequence)string), Collections.emptyList());
        BlockTree blockTree = treeMaker.Block(Collections.singletonList(treeMaker.ExpressionStatement((ExpressionTree)methodInvocationTree)), false);
        MethodTree methodTree = treeMaker.Method(modifiersTree, (CharSequence)string, (Tree)treeMaker.PrimitiveType(TypeKind.VOID), Collections.emptyList(), Collections.emptyList(), Collections.singletonList(treeMaker.Identifier((CharSequence)"Exception")), blockTree, null);
        return methodTree;
    }

    @Override
    protected void generateMissingPostInitMethods(TreePath treePath, List<Tree> list, ClassMap classMap, WorkingCopy workingCopy) {
        if (this.setup.isGenerateSuiteClasses()) {
            this.generateTestClassSuiteMethod(treePath, list, classMap, workingCopy);
        }
    }

    @Override
    protected MethodTree composeNewTestMethod(String string, BlockTree blockTree, List<ExpressionTree> list, WorkingCopy workingCopy) {
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        return treeMaker.Method(treeMaker.Modifiers(JUnit3TestGenerator.createModifierSet(Modifier.PUBLIC)), (CharSequence)string, (Tree)treeMaker.PrimitiveType(TypeKind.VOID), Collections.emptyList(), Collections.emptyList(), list, blockTree, null);
    }

    @Override
    protected ClassTree finishSuiteClass(ClassTree classTree, TreePath treePath, List<Tree> list, List<String> list2, boolean bl, ClassMap classMap, WorkingCopy workingCopy) {
        MethodTree methodTree = this.generateSuiteMethod(classTree.getSimpleName().toString(), list2, workingCopy);
        if (methodTree != null) {
            int n = classMap.findNoArgMethod("suite");
            if (n != -1) {
                list.set(n, methodTree);
            } else {
                int n2 = classMap.containsInitializers() ? classMap.getLastInitializerIndex() + 1 : (classMap.containsMethods() ? classMap.getFirstMethodIndex() : (classMap.containsNestedClasses() ? classMap.getFirstNestedClassIndex() : classMap.size()));
                if (n2 == classMap.size()) {
                    list.add(methodTree);
                } else {
                    list.add(n2, methodTree);
                }
                classMap.addNoArgMethod("suite", n2);
            }
            bl = true;
        }
        if (!bl) {
            return classTree;
        }
        return workingCopy.getTreeMaker().Class(classTree.getModifiers(), (CharSequence)classTree.getSimpleName(), classTree.getTypeParameters(), classTree.getExtendsClause(), classTree.getImplementsClause(), list);
    }

    private MethodTree generateSuiteMethod(String string, List<String> list, WorkingCopy workingCopy) {
        Types types = workingCopy.getTypes();
        Elements elements = workingCopy.getElements();
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        ExpressionTree expressionTree = this.getClassIdentifierTree(TEST_SUITE, workingCopy);
        TypeElement typeElement = this.getTestTypeElem(elements);
        if (typeElement == null) {
            return null;
        }
        TypeMirror typeMirror = typeElement.asType();
        ArrayList<StatementTree> arrayList = new ArrayList<StatementTree>(list.size() + 2);
        VariableTree variableTree = treeMaker.Variable(treeMaker.Modifiers(JUnit3TestGenerator.noModifiers()), (CharSequence)"suite", (Tree)expressionTree, (ExpressionTree)treeMaker.NewClass(null, Collections.emptyList(), expressionTree, Collections.singletonList(treeMaker.Literal((Object)TestUtil.getSimpleName(string))), null));
        arrayList.add(variableTree);
        for (String string2 : list) {
            TypeElement typeElement2 = elements.getTypeElement(string2);
            if (typeElement2 == null || !this.containsSuiteMethod(typeElement2, elements, types, typeMirror)) continue;
            MethodInvocationTree methodInvocationTree = treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)treeMaker.MemberSelect(treeMaker.QualIdent((Element)typeElement2), (CharSequence)"suite"), Collections.emptyList());
            MethodInvocationTree methodInvocationTree2 = treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)"suite"), (CharSequence)"addTest"), Collections.singletonList(methodInvocationTree));
            arrayList.add(treeMaker.ExpressionStatement((ExpressionTree)methodInvocationTree2));
        }
        arrayList.add(treeMaker.Return((ExpressionTree)treeMaker.Identifier((CharSequence)"suite")));
        return treeMaker.Method(treeMaker.Modifiers(JUnit3TestGenerator.createModifierSet(Modifier.PUBLIC, Modifier.STATIC)), (CharSequence)"suite", (Tree)treeMaker.QualIdent((Element)typeElement), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), treeMaker.Block(arrayList, false), null);
    }

    private boolean containsSuiteMethod(TypeElement typeElement, Elements elements, Types types, TypeMirror typeMirror) {
        List<ExecutableElement> list = ElementFilter.methodsIn(elements.getAllMembers(typeElement));
        for (ExecutableElement executableElement : list) {
            if (!executableElement.getSimpleName().contentEquals("suite") || !executableElement.getParameters().isEmpty()) continue;
            return executableElement.getModifiers().contains((Object)Modifier.STATIC) && types.isSameType(executableElement.getReturnType(), typeMirror);
        }
        return false;
    }

    private boolean generateTestClassSuiteMethod(TreePath treePath, List<Tree> list, ClassMap classMap, WorkingCopy workingCopy) {
        if (!this.setup.isGenerateSuiteClasses() || classMap.containsNoArgMethod("suite")) {
            return false;
        }
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        Elements elements = workingCopy.getElements();
        Trees trees = workingCopy.getTrees();
        Element element = trees.getElement(treePath);
        assert (element != null);
        ArrayList<Object> arrayList = new ArrayList<Object>(4);
        VariableTree variableTree = treeMaker.Variable(treeMaker.Modifiers(JUnit3TestGenerator.noModifiers()), (CharSequence)"suite", (Tree)this.getClassIdentifierTree(TEST_SUITE, workingCopy), (ExpressionTree)treeMaker.NewClass(null, Collections.emptyList(), this.getClassIdentifierTree(TEST_SUITE, workingCopy), Collections.singletonList(treeMaker.MemberSelect(treeMaker.QualIdent(element), (CharSequence)"class")), null));
        arrayList.add(variableTree);
        List<TypeElement> list2 = ElementFilter.typesIn(element.getEnclosedElements());
        if (!list2.isEmpty()) {
            for (TypeElement object2 : list2) {
                if (!TestUtil.isClassTest((CompilationInfo)workingCopy, object2)) continue;
                MethodInvocationTree n = treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)treeMaker.MemberSelect(treeMaker.QualIdent((Element)object2), (CharSequence)"suite"), Collections.emptyList());
                MethodInvocationTree methodInvocationTree = treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)"suite"), (CharSequence)"addTest"), Collections.singletonList(n));
                arrayList.add(treeMaker.ExpressionStatement((ExpressionTree)methodInvocationTree));
            }
        }
        ReturnTree returnTree = treeMaker.Return((ExpressionTree)treeMaker.Identifier((CharSequence)"suite"));
        arrayList.add(returnTree);
        MethodTree methodTree = treeMaker.Method(treeMaker.Modifiers(JUnit3TestGenerator.createModifierSet(Modifier.PUBLIC, Modifier.STATIC)), (CharSequence)"suite", (Tree)this.getClassIdentifierTree(TEST, workingCopy), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), treeMaker.Block(arrayList, false), null);
        int n = classMap.containsMethods() ? classMap.getFirstMethodIndex() : (classMap.containsNestedClasses() ? classMap.getFirstNestedClassIndex() : classMap.size());
        if (n == classMap.size()) {
            list.add(methodTree);
        } else {
            list.add(n, methodTree);
        }
        classMap.addNoArgMethod("suite", n);
        return true;
    }

    private TypeElement getTestTypeElem(Elements elements) {
        if (this.testTypeElem == null) {
            this.testTypeElem = JUnit3TestGenerator.getElemForClassName(TEST, elements);
        }
        return this.testTypeElem;
    }
}

