/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.el;

import com.sun.faces.facelets.el.DefaultVariableMapper;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.FunctionMapper;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import javax.el.VariableMapper;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.PropertyResolver;
import javax.faces.el.VariableResolver;

public final class LegacyELContext
extends ELContext {
    private static final String[] IMPLICIT_OBJECTS = new String[]{"application", "applicationScope", "cookie", "facesContext", "header", "headerValues", "initParam", "param", "paramValues", "request", "requestScope", "session", "sessionScope", "view"};
    private static final FunctionMapper functions = new EmptyFunctionMapper();
    private final FacesContext faces;
    private final ELResolver resolver;
    private final VariableMapper variables;

    public LegacyELContext(FacesContext faces) {
        this.faces = faces;
        this.resolver = new LegacyELResolver();
        this.variables = new DefaultVariableMapper();
    }

    public ELResolver getELResolver() {
        return this.resolver;
    }

    public FunctionMapper getFunctionMapper() {
        return functions;
    }

    public VariableMapper getVariableMapper() {
        return this.variables;
    }

    public FacesContext getFacesContext() {
        return this.faces;
    }

    private static final class EmptyFunctionMapper
    extends FunctionMapper {
        private EmptyFunctionMapper() {
        }

        public Method resolveFunction(String prefix, String localName) {
            return null;
        }
    }

    private final class LegacyELResolver
    extends ELResolver {
        private LegacyELResolver() {
        }

        public Class getCommonPropertyType(ELContext context, Object base) {
            return Object.class;
        }

        public Iterator getFeatureDescriptors(ELContext context, Object base) {
            return Collections.EMPTY_LIST.iterator();
        }

        private VariableResolver getVariableResolver() {
            return LegacyELContext.this.faces.getApplication().getVariableResolver();
        }

        private PropertyResolver getPropertyResolver() {
            return LegacyELContext.this.faces.getApplication().getPropertyResolver();
        }

        public Class getType(ELContext context, Object base, Object property) {
            if (property == null) {
                return null;
            }
            try {
                context.setPropertyResolved(true);
                if (base == null) {
                    Object obj = this.getVariableResolver().resolveVariable(LegacyELContext.this.faces, property.toString());
                    return obj != null ? obj.getClass() : null;
                }
                if (base instanceof List || base.getClass().isArray()) {
                    return this.getPropertyResolver().getType(base, Integer.parseInt(property.toString()));
                }
                return this.getPropertyResolver().getType(base, property);
            }
            catch (javax.faces.el.PropertyNotFoundException e) {
                throw new PropertyNotFoundException(e.getMessage(), e.getCause());
            }
            catch (EvaluationException e) {
                throw new ELException(e.getMessage(), e.getCause());
            }
        }

        public Object getValue(ELContext context, Object base, Object property) {
            if (property == null) {
                return null;
            }
            try {
                context.setPropertyResolved(true);
                if (base == null) {
                    return this.getVariableResolver().resolveVariable(LegacyELContext.this.faces, property.toString());
                }
                if (base instanceof List || base.getClass().isArray()) {
                    return this.getPropertyResolver().getValue(base, Integer.parseInt(property.toString()));
                }
                return this.getPropertyResolver().getValue(base, property);
            }
            catch (javax.faces.el.PropertyNotFoundException e) {
                throw new PropertyNotFoundException(e.getMessage(), e.getCause());
            }
            catch (EvaluationException e) {
                throw new ELException(e.getMessage(), e.getCause());
            }
        }

        public boolean isReadOnly(ELContext context, Object base, Object property) {
            if (property == null) {
                return true;
            }
            try {
                context.setPropertyResolved(true);
                if (base == null) {
                    return false;
                }
                if (base instanceof List || base.getClass().isArray()) {
                    return this.getPropertyResolver().isReadOnly(base, Integer.parseInt(property.toString()));
                }
                return this.getPropertyResolver().isReadOnly(base, property);
            }
            catch (javax.faces.el.PropertyNotFoundException e) {
                throw new PropertyNotFoundException(e.getMessage(), e.getCause());
            }
            catch (EvaluationException e) {
                throw new ELException(e.getMessage(), e.getCause());
            }
        }

        public void setValue(ELContext context, Object base, Object property, Object value) {
            if (property == null) {
                throw new PropertyNotWritableException("Null Property");
            }
            try {
                context.setPropertyResolved(true);
                if (base == null) {
                    if (Arrays.binarySearch(IMPLICIT_OBJECTS, property.toString()) >= 0) {
                        throw new PropertyNotWritableException("Implicit Variable Not Setable: " + property);
                    }
                    Map scope = this.resolveScope(property.toString());
                    this.getPropertyResolver().setValue((Object)scope, property, value);
                } else if (base instanceof List || base.getClass().isArray()) {
                    this.getPropertyResolver().setValue(base, Integer.parseInt(property.toString()), value);
                } else {
                    this.getPropertyResolver().setValue(base, property, value);
                }
            }
            catch (javax.faces.el.PropertyNotFoundException e) {
                throw new PropertyNotFoundException(e.getMessage(), e.getCause());
            }
            catch (EvaluationException e) {
                throw new ELException(e.getMessage(), e.getCause());
            }
        }

        private final Map resolveScope(String var) {
            ExternalContext ext = LegacyELContext.this.faces.getExternalContext();
            Map map = ext.getRequestMap();
            if (!(map.containsKey(var) || (map = ext.getSessionMap()).containsKey(var) || (map = ext.getApplicationMap()).containsKey(var))) {
                map = ext.getRequestMap();
            }
            return map;
        }
    }
}

