/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.perfan.storage.impl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Address {
    private static final Pattern pattern = Pattern.compile("\\s*([0-9]+)\\s*:0x([0-9a-f]+)\\s*");
    final int segmentNumber;
    final long address;

    public Address(int segmentNumber, long address) {
        this.segmentNumber = segmentNumber;
        this.address = address;
    }

    public static Address parse(String string) {
        Address result = null;
        Matcher m = pattern.matcher(string.toLowerCase());
        if (m.matches()) {
            int segment = Integer.parseInt(m.group(1));
            long address = Long.parseLong(m.group(2), 16);
            result = new Address(segment, address);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Address) {
            Address that = (Address)obj;
            return this.address == that.address && this.segmentNumber == that.segmentNumber;
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + this.segmentNumber;
        hash = 59 * hash + (int)(this.address ^ this.address >>> 32);
        return hash;
    }

    public long getAddress() {
        return this.address;
    }

    public int getSegmentNumber() {
        return this.segmentNumber;
    }

    public String toString() {
        return String.format("%d:0x%x", this.segmentNumber, this.address);
    }
}

