/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.diff;

import java.io.File;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.diff.DiffCommand;
import org.netbeans.lib.cvsclient.command.diff.DiffInformation;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.FileInfoEvent;

public class SimpleDiffBuilder
implements Builder {
    protected EventManager eventManager;
    protected DiffCommand diffCommand;
    protected DiffInformation diffInformation;
    protected String fileDirectory;
    protected boolean readingDiffs = false;
    private static final String UNKNOWN = ": I know nothing about";
    private static final String CANNOT_FIND = ": cannot find";
    private static final String UNKNOWN_TAG = ": tag";
    private static final String EXAM_DIR = ": Diffing";
    private static final String FILE = "Index: ";
    private static final String RCS_FILE = "RCS file: ";
    private static final String REVISION = "retrieving revision ";
    private static final String PARAMETERS = "diff ";
    private DiffInformation.DiffChange currentChange;

    public SimpleDiffBuilder(EventManager eventMan, DiffCommand diffComm) {
        this.eventManager = eventMan;
        this.diffCommand = diffComm;
    }

    public void outputDone() {
        if (this.diffInformation != null) {
            if (this.currentChange != null) {
                this.diffInformation.addChange(this.currentChange);
                this.currentChange = null;
            }
            this.eventManager.fireCVSEvent(new FileInfoEvent(this, this.diffInformation));
            this.diffInformation = null;
            this.readingDiffs = false;
        }
    }

    public void parseLine(String line, boolean isErrorMessage) {
        if (this.readingDiffs) {
            if (line.startsWith(FILE)) {
                this.outputDone();
            } else {
                this.processDifferences(line);
                return;
            }
        }
        if (line.indexOf(UNKNOWN) >= 0) {
            this.eventManager.fireCVSEvent(new FileInfoEvent(this, this.diffInformation));
            this.diffInformation = null;
            return;
        }
        if (line.indexOf(EXAM_DIR) >= 0) {
            this.fileDirectory = line.substring(line.indexOf(EXAM_DIR) + EXAM_DIR.length()).trim();
            return;
        }
        if (line.startsWith(FILE)) {
            this.processFile(line.substring(FILE.length()));
            return;
        }
        if (line.startsWith(RCS_FILE)) {
            this.processRCSfile(line.substring(RCS_FILE.length()));
            return;
        }
        if (line.startsWith(REVISION)) {
            this.processRevision(line.substring(REVISION.length()));
            return;
        }
        if (line.startsWith(PARAMETERS)) {
            this.processParameters(line.substring(PARAMETERS.length()));
            this.readingDiffs = true;
            return;
        }
    }

    protected void processFile(String line) {
        this.outputDone();
        this.diffInformation = this.createDiffInformation();
        String fileName = line.trim();
        if (fileName.startsWith("no file")) {
            fileName = fileName.substring(8);
        }
        this.diffInformation.setFile(new File(this.diffCommand.getLocalDirectory(), fileName));
    }

    protected void processRCSfile(String line) {
        if (this.diffInformation == null) {
            return;
        }
        this.diffInformation.setRepositoryFileName(line.trim());
    }

    protected void processRevision(String line) {
        if (this.diffInformation == null) {
            return;
        }
        line = line.trim();
        if (this.diffInformation.getLeftRevision() != null) {
            this.diffInformation.setRightRevision(line);
        } else {
            this.diffInformation.setLeftRevision(line);
        }
    }

    protected void processParameters(String line) {
        if (this.diffInformation == null) {
            return;
        }
        this.diffInformation.setParameters(line.trim());
    }

    public DiffInformation createDiffInformation() {
        return new DiffInformation();
    }

    protected void assignType(DiffInformation.DiffChange change, String line) {
        int index = 0;
        int cIndex = line.indexOf(99);
        if (cIndex > 0) {
            change.setType(2);
            index = cIndex;
        } else {
            int aIndex = line.indexOf(97);
            if (aIndex > 0) {
                change.setType(0);
                index = aIndex;
            } else {
                int dIndex = line.indexOf(100);
                if (dIndex > 0) {
                    change.setType(1);
                    index = dIndex;
                }
            }
        }
        String left = line.substring(0, index);
        change.setLeftRange(this.getMin(left), this.getMax(left));
        String right = line.substring(index + 1);
        change.setRightRange(this.getMin(right), this.getMax(right));
    }

    private int getMin(String line) {
        int min;
        String nums = line;
        int commaIndex = nums.indexOf(44);
        if (commaIndex > 0) {
            nums = nums.substring(0, commaIndex);
        }
        try {
            min = Integer.parseInt(nums);
        }
        catch (NumberFormatException exc) {
            min = 0;
        }
        return min;
    }

    private int getMax(String line) {
        int max;
        String nums = line;
        int commaIndex = nums.indexOf(44);
        if (commaIndex > 0) {
            nums = nums.substring(commaIndex + 1);
        }
        try {
            max = Integer.parseInt(nums);
        }
        catch (NumberFormatException exc) {
            max = 0;
        }
        return max;
    }

    protected void processDifferences(String line) {
        char firstChar = line.charAt(0);
        if (firstChar >= '0' && firstChar <= '9') {
            if (this.currentChange != null) {
                this.diffInformation.addChange(this.currentChange);
            }
            this.currentChange = this.diffInformation.createDiffChange();
            this.assignType(this.currentChange, line);
        }
        if (firstChar == '<') {
            this.currentChange.appendLeftLine(line.substring(2));
        }
        if (firstChar == '>') {
            this.currentChange.appendRightLine(line.substring(2));
        }
    }

    public void parseEnhancedMessage(String key, Object value) {
    }
}

