/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.lexer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.languages.ParseException;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguageImpl;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.lexer.SLanguageHierarchy;
import org.netbeans.modules.languages.lexer.STokenId;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageProvider;

public class SLanguageProvider
extends LanguageProvider {
    private static Map<String, org.netbeans.api.lexer.Language<STokenId>> preprocessorImport = new HashMap<String, org.netbeans.api.lexer.Language<STokenId>>();
    private static Map<String, Map<String, org.netbeans.api.lexer.Language<STokenId>>> tokenImports = new HashMap<String, Map<String, org.netbeans.api.lexer.Language<STokenId>>>();
    private static Map<SLanguageProvider, SLanguageProvider> providers = new WeakHashMap<SLanguageProvider, SLanguageProvider>();

    public SLanguageProvider() {
        providers.put(this, null);
    }

    public org.netbeans.api.lexer.Language<STokenId> findLanguage(String mimeType) {
        if (LanguagesManager.getDefault().isSupported(mimeType)) {
            try {
                Language language = LanguagesManager.getDefault().getLanguage(mimeType);
                if (language instanceof LanguageImpl) {
                    new Listener((LanguageImpl)language);
                }
                if (language.getParser() == null) {
                    return null;
                }
                return new SLanguageHierarchy(language).language();
            }
            catch (ParseException ex) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    public LanguageEmbedding<?> findLanguageEmbedding(Token token, LanguagePath languagePath, InputAttributes inputAttributes) {
        String mimeType = languagePath.innerLanguage().mimeType();
        if (!LanguagesManager.getDefault().isSupported(mimeType)) {
            return null;
        }
        org.netbeans.api.lexer.Language<STokenId> language = SLanguageProvider.getTokenImport(mimeType, token);
        if (language == null) {
            language = SLanguageProvider.getPreprocessorImport(languagePath, token);
        }
        if (language == null) {
            return null;
        }
        Integer i = (Integer)token.getProperty((Object)"startSkipLength");
        int startSkipLength = i == null ? 0 : i;
        i = (Integer)token.getProperty((Object)"endSkipLength");
        int endSkipLength = i == null ? 0 : i;
        return LanguageEmbedding.create(language, (int)startSkipLength, (int)endSkipLength);
    }

    private static org.netbeans.api.lexer.Language<STokenId> getPreprocessorImport(LanguagePath languagePath, Token token) {
        String tokenType = token.id().name();
        if (!tokenType.equals("PE")) {
            return null;
        }
        String mimeType = languagePath.topLanguage().mimeType();
        if (!preprocessorImport.containsKey(mimeType)) {
            try {
                Language language = LanguagesManager.getDefault().getLanguage(mimeType);
                Feature properties = language.getPreprocessorImport();
                if (properties != null) {
                    String innerMT = (String)properties.getValue("mimeType");
                    preprocessorImport.put(mimeType, (org.netbeans.api.lexer.Language<STokenId>)org.netbeans.api.lexer.Language.find((String)innerMT));
                }
            }
            catch (ParseException ex) {
                // empty catch block
            }
        }
        return preprocessorImport.get(mimeType);
    }

    private static org.netbeans.api.lexer.Language<STokenId> getTokenImport(String mimeType, Token token) {
        String tokenType = token.id().name();
        Map<String, org.netbeans.api.lexer.Language<STokenId>> tokenTypeToLanguage = tokenImports.get(mimeType);
        if (tokenTypeToLanguage == null) {
            tokenTypeToLanguage = new HashMap<String, org.netbeans.api.lexer.Language<STokenId>>();
            tokenImports.put(mimeType, tokenTypeToLanguage);
            try {
                Language language = LanguagesManager.getDefault().getLanguage(mimeType);
                Map<String, Feature> tokenImports = language.getTokenImports();
                if (tokenImports != null) {
                    for (String tokenType2 : tokenImports.keySet()) {
                        Feature properties = tokenImports.get(tokenType2);
                        String innerMT = (String)properties.getValue("mimeType");
                        tokenTypeToLanguage.put(tokenType2, (org.netbeans.api.lexer.Language<STokenId>)org.netbeans.api.lexer.Language.find((String)innerMT));
                    }
                }
            }
            catch (ParseException ex) {
                // empty catch block
            }
        }
        return tokenTypeToLanguage.get(tokenType);
    }

    static void refresh() {
        for (SLanguageProvider provider : providers.keySet()) {
            provider.firePropertyChange("LanguageProvider.PROP_LANGUAGE");
            provider.firePropertyChange("LanguageProvider.PROP_EMBEDDED_LANGUAGE");
        }
    }

    private static class Listener
    implements PropertyChangeListener {
        private LanguageImpl language;

        Listener(LanguageImpl language) {
            this.language = language;
            language.addPropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            SLanguageProvider.refresh();
        }
    }
}

