/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.text.Document;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ParserManager;
import org.netbeans.api.languages.SyntaxContext;
import org.netbeans.api.languages.database.DatabaseContext;
import org.netbeans.api.languages.database.DatabaseDefinition;
import org.netbeans.api.languages.database.DatabaseItem;
import org.netbeans.api.languages.database.DatabaseUsage;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;

public class DatabaseManager {
    private NbEditorDocument document;

    public DatabaseManager(Document document) {
        this.document = (NbEditorDocument)document;
    }

    static DatabaseContext parse(ASTNode ast, Document doc, ParserManager parser) {
        DatabaseContext rootContext = new DatabaseContext(null, null, ast.getOffset(), ast.getEndOffset());
        ArrayList<ASTItem> path = new ArrayList<ASTItem>();
        path.add(ast);
        ArrayList<DatabaseItem> unresolvedUsages = new ArrayList<DatabaseItem>();
        DatabaseManager.process(path, rootContext, unresolvedUsages, doc, parser);
        Iterator it2 = unresolvedUsages.iterator();
        while (it2.hasNext()) {
            if (parser != null && parser.getState() == ParserManager.State.PARSING) {
                return null;
            }
            DatabaseUsage usage = (DatabaseUsage)it2.next();
            DatabaseContext context = (DatabaseContext)it2.next();
            DatabaseDefinition definition = rootContext.getDefinition(usage.getName(), usage.getOffset());
            if (definition == null) continue;
            definition.addUsage(usage);
            context.addUsage(usage);
            usage.setDatabaseDefinition(definition);
        }
        return rootContext;
    }

    private static void process(List<ASTItem> path, DatabaseContext context, List<DatabaseItem> unresolvedUsages, Document doc, ParserManager parser) {
        ASTItem last = path.get(path.size() - 1);
        Iterator<ASTItem> it = last.getChildren().iterator();
        while (it.hasNext()) {
            if (parser != null && parser.getState() == ParserManager.State.PARSING) {
                return;
            }
            ASTItem item = it.next();
            path.add(item);
            Language language = (Language)item.getLanguage();
            if (language != null) {
                String name;
                SyntaxContext sc;
                ASTPath astPath = ASTPath.create(path);
                Feature feature = language.getFeatureList().getFeature("SEMANTIC_DECLARATION", astPath);
                if (feature != null) {
                    sc = SyntaxContext.create(doc, astPath);
                    name = ((String)feature.getValue("name", sc)).trim();
                    String type = (String)feature.getValue("type", sc);
                    if (name != null && name.length() > 0) {
                        String local = (String)feature.getValue("local", sc);
                        if (local != null) {
                            DatabaseContext c;
                            for (c = context; c != null && !local.equals(c.getType()); c = c.getParent()) {
                            }
                            if (c != null) {
                                type = "local";
                            }
                        }
                        DatabaseContext con = context;
                        if ("method".equals(type) && (con = con.getParent()) == null) {
                            con = context;
                        }
                        con.addDefinition(new DatabaseDefinition(name, type, item.getOffset(), item.getEndOffset()));
                    }
                }
                if ((feature = language.getFeatureList().getFeature("SEMANTIC_CONTEXT", astPath)) != null) {
                    String type = (String)feature.getValue("type");
                    DatabaseContext newContext = new DatabaseContext(context, type, item.getOffset(), item.getEndOffset());
                    context.addContext(item, newContext);
                    DatabaseManager.process(path, newContext, unresolvedUsages, doc, parser);
                    path.remove(path.size() - 1);
                    continue;
                }
                feature = language.getFeatureList().getFeature("SEMANTIC_USAGE", astPath);
                if (feature != null) {
                    sc = SyntaxContext.create(doc, astPath);
                    name = (String)feature.getValue("name", sc);
                    DatabaseDefinition definition = context.getDefinition(name, item.getOffset());
                    DatabaseUsage usage = new DatabaseUsage(name, item.getOffset(), item.getEndOffset());
                    if (definition != null) {
                        definition.addUsage(usage);
                        usage.setDatabaseDefinition(definition);
                        context.addUsage(usage);
                    } else {
                        unresolvedUsages.add(usage);
                        unresolvedUsages.add(context);
                    }
                }
            }
            DatabaseManager.process(path, context, unresolvedUsages, doc, parser);
            path.remove(path.size() - 1);
        }
    }

    public static DatabaseContext getRoot(ASTNode ast) {
        return org.netbeans.api.languages.database.DatabaseManager.getRoot(ast);
    }

    static void setRoot(ASTNode node, DatabaseContext databaseContext) {
        org.netbeans.api.languages.database.DatabaseManager.setRoot(node, databaseContext);
    }
}

