/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.palette;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.text.JTextComponent;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.palette.ImportPaletteFolderAction;
import org.netbeans.modules.mobility.svgcore.view.svg.SVGViewTopComponent;
import org.netbeans.spi.palette.PaletteActions;
import org.netbeans.spi.palette.PaletteController;
import org.netbeans.spi.palette.PaletteFactory;
import org.openide.loaders.DataObject;
import org.openide.text.ActiveEditorDrop;
import org.openide.text.CloneableEditor;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public final class SVGPaletteFactory {
    public static final String SVGXML_PALETTE_FOLDER = "SVGXMLPalette";
    public static final String SVG_PALETTE_THUMBNAIL_FOLDER = "SVGPalette/ThumbnailImages";
    private static PaletteController palette = null;

    public static synchronized PaletteController getPalette() throws IOException {
        if (palette == null) {
            palette = PaletteFactory.createPalette((String)SVGXML_PALETTE_FOLDER, (PaletteActions)new SVGPaletteActions(), null, null);
        }
        return palette;
    }

    private static class SVGPaletteActions
    extends PaletteActions {
        private SVGPaletteActions() {
        }

        public Action getPreferredAction(final Lookup lookup) {
            return new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (TopComponent tc : TopComponent.getRegistry().getOpened()) {
                        SVGDataObject targetDObj;
                        if (!tc.isVisible() || (targetDObj = (SVGDataObject)((Object)tc.getLookup().lookup(SVGDataObject.class))) == null || targetDObj.getSceneManager().isReadOnly()) continue;
                        try {
                            MultiViewElement elem = targetDObj.getActiveElement();
                            assert (elem != null);
                            JComponent comp = elem.getVisualRepresentation();
                            if (comp instanceof CloneableEditor) {
                                ActiveEditorDrop aed = (ActiveEditorDrop)lookup.lookup(ActiveEditorDrop.class);
                                JEditorPane editor = ((CloneableEditor)comp).getEditorPane();
                                if (aed != null && editor != null) {
                                    aed.handleTransfer((JTextComponent)editor);
                                } else {
                                    SceneManager.log(Level.SEVERE, "Paletter drop failed - could not obtain context.");
                                }
                            } else if (comp instanceof SVGViewTopComponent) {
                                DataObject sourceDObj = (DataObject)lookup.lookup(DataObject.class);
                                assert (sourceDObj != null);
                                float[] point = new float[]{0.0f, 0.0f};
                                ((SVGViewTopComponent)((Object)comp)).dropDataObject(sourceDObj, point);
                            }
                        }
                        catch (Exception ex) {
                            SceneManager.error("Palette drop failed.", ex);
                        }
                        return;
                    }
                }
            };
        }

        public Action[] getCustomItemActions(Lookup lookup) {
            return null;
        }

        public Action[] getCustomCategoryActions(Lookup lookup) {
            return null;
        }

        public Action[] getImportActions() {
            return null;
        }

        public Action[] getCustomPaletteActions() {
            return new Action[]{SystemAction.get(ImportPaletteFolderAction.class)};
        }
    }
}

