/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.palette;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.logging.Level;
import org.netbeans.modules.mobility.svgcore.SVGDataObject;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;
import org.netbeans.modules.mobility.svgcore.palette.ImportPaletteFolderPanel;
import org.netbeans.modules.mobility.svgcore.palette.SVGPaletteFactory;
import org.netbeans.modules.mobility.svgcore.palette.SVGPaletteItemData;
import org.netbeans.modules.mobility.svgcore.view.svg.AbstractSVGAction;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public final class ImportPaletteFolderAction
extends SystemAction {
    private static final String ACTION_ID = "svg_palette_import";
    private final String m_name = AbstractSVGAction.getMessage("LBL_svg_palette_import");

    public ImportPaletteFolderAction() {
        String hint = AbstractSVGAction.getMessage("HINT_svg_palette_import");
        this.putValue("ShortDescription", hint);
    }

    public String getName() {
        return this.m_name;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public void actionPerformed(ActionEvent e) {
        ImportPaletteFolderPanel panel = new ImportPaletteFolderPanel();
        DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(SVGPaletteFactory.class, (String)"TITLE_ImportPaletteFolder"));
        Dialog dlg = DialogDisplayer.getDefault().createDialog(dd);
        dlg.setVisible(true);
        if (dd.getValue() == DialogDescriptor.OK_OPTION) {
            final File folderFile = panel.getFolder();
            if (folderFile.exists() && folderFile.isDirectory()) {
                SceneManager.log(Level.INFO, "Importing palette folder " + folderFile.getPath());
                String categoryName = panel.getDisplayName();
                try {
                    DataFolder paletteRootFolder = (DataFolder)SVGPaletteFactory.getPalette().getRoot().lookup(DataFolder.class);
                    FileObject paletteRoot = paletteRootFolder.getPrimaryFile();
                    final String folderName = ImportPaletteFolderAction.convertCategoryToFolderName(paletteRoot, categoryName);
                    final FileObject paletteFolder = paletteRoot.createFolder(folderName);
                    if (!folderName.equals(categoryName)) {
                        paletteFolder.setAttribute("categoryName", (Object)categoryName);
                    }
                    paletteFolder.setAttribute("isExpanded", (Object)"true");
                    Thread th = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            for (File child : folderFile.listFiles()) {
                                if (!child.isFile() || !SVGDataObject.isSVGFile(child)) continue;
                                SceneManager.log(Level.FINE, "Creating palette item for " + child.getPath());
                                OutputStream out = null;
                                FileLock lock = null;
                                try {
                                    String fileName = child.getName();
                                    String paletteFoName = fileName.replace('.', '_') + ".svgPaletteItem";
                                    SVGPaletteItemData data = new SVGPaletteItemData(fileName, folderName, child.getCanonicalPath());
                                    SVGPaletteItemData.set(paletteFolder.getPath() + "/" + paletteFoName, data);
                                    FileObject fo = paletteFolder.createData(paletteFoName);
                                    lock = fo.lock();
                                    out = fo.getOutputStream(lock);
                                    data.serialize(out);
                                    SceneManager.log(Level.FINE, "Palette item created.");
                                }
                                catch (Exception ex) {
                                    SceneManager.error("Palette item creation failed.", ex);
                                }
                                finally {
                                    if (out != null) {
                                        try {
                                            out.close();
                                        }
                                        catch (IOException ex) {
                                            SceneManager.error("Couldn not close stream.", ex);
                                        }
                                    }
                                    if (lock != null) {
                                        lock.releaseLock();
                                    }
                                }
                            }
                            SceneManager.log(Level.INFO, "Palette folder imported.");
                        }
                    };
                    th.setPriority(1);
                    th.setDaemon(true);
                    th.start();
                }
                catch (IOException ex) {
                    SceneManager.error("Palette folder creation failed.", ex);
                }
            } else {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ImportPaletteFolderAction.class, (String)"ERROR_NotDirectory", (Object)folderFile), 2));
            }
        }
    }

    protected static String convertCategoryToFolderName(FileObject paletteFO, String name) {
        int i;
        if (name == null || "".equals(name)) {
            return null;
        }
        int n = name.length();
        StringBuffer nameBuff = new StringBuffer(n);
        char ch = name.charAt(0);
        if (Character.isJavaIdentifierStart(ch)) {
            nameBuff.append(ch);
            i = 1;
        } else {
            nameBuff.append('_');
            i = 0;
        }
        while (i < n) {
            ch = name.charAt(i);
            if (Character.isJavaIdentifierPart(ch)) {
                nameBuff.append(ch);
            }
            ++i;
        }
        String fName = nameBuff.toString();
        if ("_".equals(fName)) {
            fName = "Category";
        }
        String freeName = null;
        boolean nameOK = false;
        i = 0;
        while (!nameOK) {
            String string = freeName = i > 0 ? fName + "_" + i : fName;
            if (Utilities.isWindows()) {
                nameOK = true;
                Enumeration en = paletteFO.getChildren(false);
                while (en.hasMoreElements()) {
                    FileObject fo = (FileObject)en.nextElement();
                    String fn = fo.getName();
                    String fe = fo.getExt();
                    if (fe != null && !"".equals(fe) || !fn.equalsIgnoreCase(freeName)) continue;
                    nameOK = false;
                    break;
                }
            } else {
                nameOK = paletteFO.getFileObject(freeName) == null;
            }
            ++i;
        }
        return freeName;
    }
}

