/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer.actions;

import java.awt.AWTEvent;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import org.netbeans.modules.mobility.svgcore.composer.AbstractComposerAction;
import org.netbeans.modules.mobility.svgcore.composer.ComposerActionFactory;
import org.netbeans.modules.mobility.svgcore.composer.SVGObject;
import org.netbeans.modules.mobility.svgcore.composer.actions.TranslateActionFactory;

public final class TranslateAction
extends AbstractComposerAction {
    private final SVGObject m_translated;
    private int m_x;
    private int m_y;
    private boolean m_changed = false;

    public TranslateAction(ComposerActionFactory factory, SVGObject translated, MouseEvent me) {
        super(factory);
        this.m_translated = translated;
        assert (this.m_translated != null) : "The translated object cannot be null";
        this.m_x = me.getX();
        this.m_y = me.getY();
    }

    public TranslateAction(ComposerActionFactory factory, SVGObject translated, KeyEvent ke) {
        super(factory);
        this.m_translated = translated;
        assert (this.m_translated != null) : "The translated object cannot be null";
        int[] diffs = TranslateActionFactory.getCoordDiff(ke);
        this.m_x = diffs[0];
        this.m_y = diffs[1];
        this.translate(this.m_x, this.m_y, true);
    }

    @Override
    public boolean consumeEvent(AWTEvent evt, boolean isOutsideEvent) {
        if (!isOutsideEvent) {
            if (evt instanceof MouseEvent) {
                if (evt.getID() == 506) {
                    MouseEvent me = (MouseEvent)evt;
                    int dx = me.getX() - this.m_x;
                    int dy = me.getY() - this.m_y;
                    float zoomRatio = this.m_translated.getScreenManager().getZoomRatio();
                    this.translate((float)dx / zoomRatio, (float)dy / zoomRatio, false);
                } else if (evt.getID() == 502) {
                    this.actionCompleted();
                    this.m_translated.commitChanges();
                }
            } else {
                int[] diffs = TranslateActionFactory.getCoordDiff(evt);
                if (diffs != null) {
                    this.translate(this.m_x, this.m_y, true);
                    return true;
                }
                this.actionCompleted();
                this.m_translated.commitChanges();
            }
        }
        return false;
    }

    private void translate(float dx, float dy, boolean isRelative) {
        Rectangle bBox = this.m_translated.getScreenBBox();
        this.m_translated.translate(dx, dy, isRelative);
        bBox.add(this.m_translated.getScreenBBox());
        this.m_factory.getSceneManager().getScreenManager().repaint(bBox, 5);
        this.m_changed = true;
    }

    @Override
    public void actionCompleted() {
        if (this.m_changed) {
            this.m_translated.applyTextChanges();
            this.m_translated.commitChanges();
            if (this.getScreenManager().getShowAllArea()) {
                this.getScreenManager().refresh();
            }
        }
        super.actionCompleted();
    }
}

