/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.sfs;

import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.netbeans.modules.cnd.repository.sfs.UTF;

public class BufferDataInput
implements DataInput {
    private ByteBuffer buffer;

    public BufferDataInput(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public byte readByte() throws IOException {
        return this.buffer.get();
    }

    @Override
    public char readChar() throws IOException {
        return this.buffer.getChar();
    }

    @Override
    public int readInt() throws IOException {
        return this.buffer.getInt();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        short result = this.buffer.getShort();
        return result & 0xFFFF;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.buffer.get() != 0;
    }

    @Override
    public double readDouble() throws IOException {
        return this.buffer.getDouble();
    }

    @Override
    public float readFloat() throws IOException {
        return this.buffer.getFloat();
    }

    @Override
    public String readLine() throws IOException {
        StringBuilder sb = new StringBuilder();
        block4: while (this.buffer.hasRemaining()) {
            byte b = this.buffer.get();
            switch (b) {
                case 13: {
                    byte next;
                    if (!this.buffer.hasRemaining() || (next = this.buffer.get()) == 10) break block4;
                    this.buffer.position(this.buffer.position() - 1);
                    break block4;
                }
                case 10: {
                    break block4;
                }
                default: {
                    sb.append((char)b);
                    continue block4;
                }
            }
        }
        return sb.toString();
    }

    @Override
    public long readLong() throws IOException {
        return this.buffer.getLong();
    }

    @Override
    public short readShort() throws IOException {
        return this.buffer.getShort();
    }

    @Override
    public String readUTF() throws IOException {
        return UTF.readUTF(this);
    }

    @Override
    public int readUnsignedByte() throws IOException {
        byte b = this.buffer.get();
        return (short)b & 0xFF;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        int skip = Math.min(n, this.buffer.remaining());
        this.buffer.position(this.buffer.position() + skip);
        return skip;
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.buffer.get(b, off, len);
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.buffer.get(b);
    }
}

