/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.config;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.StringTokenizer;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ContextRootConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.DatasourceConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.DeploymentPlanConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfiguration;
import org.netbeans.modules.j2ee.jboss4.config.JBDeploymentConfiguration;
import org.netbeans.modules.j2ee.jboss4.config.JBossDatasource;
import org.netbeans.modules.j2ee.jboss4.config.ResourceConfigurationHelper;
import org.netbeans.modules.j2ee.jboss4.config.gen.EjbRef;
import org.netbeans.modules.j2ee.jboss4.config.gen.JbossWeb;
import org.netbeans.modules.j2ee.jboss4.config.gen.MessageDestinationRef;
import org.netbeans.modules.j2ee.jboss4.config.gen.ResourceRef;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class WarDeploymentConfiguration
extends JBDeploymentConfiguration
implements ModuleConfiguration,
ContextRootConfiguration,
DatasourceConfiguration,
DeploymentPlanConfiguration,
PropertyChangeListener {
    private File jbossWebFile;
    private JbossWeb jbossWeb;

    public WarDeploymentConfiguration(J2eeModule j2eeModule) {
        super(j2eeModule);
        this.jbossWebFile = j2eeModule.getDeploymentConfigurationFile("WEB-INF/jboss-web.xml");
        this.getJbossWeb();
        if (this.deploymentDescriptorDO == null) {
            try {
                this.deploymentDescriptorDO = DataObject.find((FileObject)FileUtil.toFileObject((File)this.jbossWebFile));
                this.deploymentDescriptorDO.addPropertyChangeListener((PropertyChangeListener)this);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            }
        }
    }

    public Lookup getLookup() {
        return Lookups.fixed((Object[])new Object[]{this});
    }

    public void dispose() {
    }

    public boolean supportsCreateDatasource() {
        return true;
    }

    public boolean supportsCreateMessageDestination() {
        return true;
    }

    public String getContextRoot() throws ConfigurationException {
        JbossWeb jbossWeb = this.getJbossWeb();
        if (jbossWeb == null) {
            String string = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_CannotReadContextRoot", (Object)this.jbossWebFile.getAbsolutePath());
            throw new ConfigurationException(string);
        }
        return jbossWeb.getContextRoot();
    }

    public void setContextRoot(String string) throws ConfigurationException {
        String string2;
        if (!this.isCorrectCP(string)) {
            string2 = string;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            StringBuffer stringBuffer = new StringBuffer();
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append("/" + stringTokenizer.nextToken());
            }
            string2 = stringBuffer.toString();
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_invalidCP", (Object)string), 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            string = string2;
        }
        string2 = string;
        this.modifyJbossWeb(new JbossWebModifier(){

            @Override
            public void modify(JbossWeb jbossWeb) {
                jbossWeb.setContextRoot(string2);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getNewValue();
        if (propertyChangeEvent.getPropertyName() == "modified" && object == Boolean.FALSE) {
            if (propertyChangeEvent.getSource() == this.deploymentDescriptorDO) {
                WarDeploymentConfiguration warDeploymentConfiguration = this;
                synchronized (warDeploymentConfiguration) {
                    this.jbossWeb = null;
                }
            }
        } else if (propertyChangeEvent.getOldValue() == null) {
            if (object instanceof org.netbeans.modules.j2ee.dd.api.common.ResourceRef) {
                org.netbeans.modules.j2ee.dd.api.common.ResourceRef resourceRef = (org.netbeans.modules.j2ee.dd.api.common.ResourceRef)object;
                try {
                    String string = resourceRef.getResType();
                    if ("javax.sql.DataSource".equals(string)) {
                        this.addResReference(resourceRef.getResRefName(), "java:/" + resourceRef.getResRefName());
                    } else if ("javax.mail.Session".equals(string)) {
                        this.addMailReference(resourceRef.getResRefName());
                    } else if ("javax.jms.ConnectionFactory".equals(string)) {
                        this.addConnectionFactoryReference(resourceRef.getResRefName());
                    }
                }
                catch (ConfigurationException configurationException) {
                    Exceptions.printStackTrace((Throwable)configurationException);
                }
            } else if (object instanceof org.netbeans.modules.j2ee.dd.api.common.EjbRef) {
                org.netbeans.modules.j2ee.dd.api.common.EjbRef ejbRef = (org.netbeans.modules.j2ee.dd.api.common.EjbRef)object;
                try {
                    String string = ejbRef.getEjbRefType();
                    if ("Session".equals(string) || "Entity".equals(string)) {
                        this.addEjbReference(ejbRef.getEjbRefName(), ejbRef.getEjbRefName());
                    }
                }
                catch (ConfigurationException configurationException) {
                    Exceptions.printStackTrace((Throwable)configurationException);
                }
            } else if (object instanceof org.netbeans.modules.j2ee.dd.api.common.MessageDestinationRef) {
                org.netbeans.modules.j2ee.dd.api.common.MessageDestinationRef messageDestinationRef = (org.netbeans.modules.j2ee.dd.api.common.MessageDestinationRef)object;
                try {
                    String string = messageDestinationRef.getMessageDestinationType();
                    String string2 = "javax.jms.Queue".equals(string) ? "queue/" : "topic/";
                    this.addMsgDestReference(messageDestinationRef.getMessageDestinationRefName(), string2);
                }
                catch (ConfigurationException configurationException) {
                    Exceptions.printStackTrace((Throwable)configurationException);
                }
            }
        }
    }

    @Override
    public void bindDatasourceReference(String string, String string2) throws ConfigurationException {
        this.addResReference(string, string2);
    }

    @Override
    public String findDatasourceJndiName(String string) throws ConfigurationException {
        ResourceRef[] resourceRefArray;
        for (ResourceRef resourceRef : resourceRefArray = this.getJbossWeb().getResourceRef()) {
            String string2;
            String string3 = resourceRef.getResRefName();
            if (!string.equals(string3) || (string2 = resourceRef.getJndiName()) == null) continue;
            return JBossDatasource.getJndiName(string2);
        }
        return null;
    }

    private void addResReference(final String string, final String string2) throws ConfigurationException {
        this.modifyJbossWeb(new JbossWebModifier(){

            @Override
            public void modify(JbossWeb jbossWeb) {
                ResourceRef[] resourceRefArray = jbossWeb.getResourceRef();
                for (int i = 0; i < resourceRefArray.length; ++i) {
                    String string3 = resourceRefArray[i].getResRefName();
                    if (!string.equals(string3)) continue;
                    return;
                }
                ResourceRef resourceRef = new ResourceRef();
                resourceRef.setResRefName(string);
                resourceRef.setJndiName(string2);
                jbossWeb.addResourceRef(resourceRef);
            }
        });
    }

    private void addMailReference(final String string) throws ConfigurationException {
        this.modifyJbossWeb(new JbossWebModifier(){

            @Override
            public void modify(JbossWeb jbossWeb) {
                ResourceRef[] resourceRefArray = jbossWeb.getResourceRef();
                for (int i = 0; i < resourceRefArray.length; ++i) {
                    String string2 = resourceRefArray[i].getResRefName();
                    if (!string.equals(string2)) continue;
                    return;
                }
                ResourceRef resourceRef = new ResourceRef();
                resourceRef.setResRefName(string);
                resourceRef.setJndiName("java:Mail");
                jbossWeb.addResourceRef(resourceRef);
            }
        });
    }

    @Override
    public void bindMessageDestinationReference(String string, String string2, String string3, MessageDestination.Type type) throws ConfigurationException {
        this.addConnectionFactoryReference(string2);
        String string4 = null;
        if (MessageDestination.Type.QUEUE.equals((Object)type)) {
            string4 = "queue/" + string3;
        } else if (MessageDestination.Type.TOPIC.equals((Object)type)) {
            string4 = "topic/" + string3;
        }
        this.addMsgDestReference(string, string4);
    }

    private void addConnectionFactoryReference(final String string) throws ConfigurationException {
        this.modifyJbossWeb(new JbossWebModifier(){

            @Override
            public void modify(JbossWeb jbossWeb) {
                ResourceRef[] resourceRefArray = jbossWeb.getResourceRef();
                for (int i = 0; i < resourceRefArray.length; ++i) {
                    String string2 = resourceRefArray[i].getResRefName();
                    if (!string.equals(string2)) continue;
                    return;
                }
                ResourceRef resourceRef = new ResourceRef();
                resourceRef.setResRefName(string);
                resourceRef.setJndiName("ConnectionFactory");
                jbossWeb.addResourceRef(resourceRef);
            }
        });
    }

    private void addMsgDestReference(final String string, final String string2) throws ConfigurationException {
        this.modifyJbossWeb(new JbossWebModifier(){

            @Override
            public void modify(JbossWeb jbossWeb) {
                MessageDestinationRef[] messageDestinationRefArray = jbossWeb.getMessageDestinationRef();
                for (int i = 0; i < messageDestinationRefArray.length; ++i) {
                    String string3 = messageDestinationRefArray[i].getMessageDestinationRefName();
                    if (!string.equals(string3)) continue;
                    return;
                }
                MessageDestinationRef messageDestinationRef = new MessageDestinationRef();
                messageDestinationRef.setMessageDestinationRefName(string);
                messageDestinationRef.setJndiName(string2);
                jbossWeb.addMessageDestinationRef(messageDestinationRef);
            }
        });
    }

    @Override
    public void bindEjbReference(String string, String string2) throws ConfigurationException {
        if (Double.parseDouble(this.j2eeModule.getModuleVersion()) > 2.4) {
            return;
        }
        this.addEjbReference(string, string2);
    }

    private void addEjbReference(final String string, final String string2) throws ConfigurationException {
        this.modifyJbossWeb(new JbossWebModifier(){

            @Override
            public void modify(JbossWeb jbossWeb) {
                EjbRef[] ejbRefArray = jbossWeb.getEjbRef();
                for (int i = 0; i < ejbRefArray.length; ++i) {
                    String string3 = ejbRefArray[i].getEjbRefName();
                    if (!string.equals(string3)) continue;
                    return;
                }
                EjbRef ejbRef = new EjbRef();
                ejbRef.setEjbRefName(string);
                ejbRef.setJndiName(string2);
                jbossWeb.addEjbRef(ejbRef);
            }
        });
    }

    public synchronized JbossWeb getJbossWeb() {
        if (this.jbossWeb == null) {
            try {
                if (this.jbossWebFile.exists()) {
                    try {
                        this.jbossWeb = JbossWeb.createGraph(this.jbossWebFile);
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                    catch (RuntimeException runtimeException) {}
                } else {
                    this.jbossWeb = this.generateJbossWeb();
                    ResourceConfigurationHelper.writeFile(this.jbossWebFile, this.jbossWeb);
                }
            }
            catch (ConfigurationException configurationException) {
                Exceptions.printStackTrace((Throwable)configurationException);
            }
        }
        return this.jbossWeb;
    }

    public void save(OutputStream outputStream) throws ConfigurationException {
        JbossWeb jbossWeb = this.getJbossWeb();
        if (jbossWeb == null) {
            String string = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_cannotSaveNotParseableConfFile", (Object)this.jbossWebFile.getAbsolutePath());
            throw new ConfigurationException(string);
        }
        try {
            jbossWeb.write(outputStream);
        }
        catch (IOException iOException) {
            String string = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_CannotUpdateFile", (Object)this.jbossWebFile.getAbsolutePath());
            throw new ConfigurationException(string, (Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyJbossWeb(JbossWebModifier jbossWebModifier) throws ConfigurationException {
        assert (this.deploymentDescriptorDO != null) : "DataObject has not been initialized yet";
        try {
            Object object;
            EditorCookie editorCookie = (EditorCookie)this.deploymentDescriptorDO.getCookie(EditorCookie.class);
            StyledDocument styledDocument = editorCookie.getDocument();
            if (styledDocument == null) {
                styledDocument = editorCookie.openDocument();
            }
            JbossWeb jbossWeb = null;
            try {
                byte[] byArray = styledDocument.getText(0, styledDocument.getLength()).getBytes();
                jbossWeb = JbossWeb.createGraph(new ByteArrayInputStream(byArray));
            }
            catch (RuntimeException runtimeException) {
                object = this.getJbossWeb();
                if (object == null) {
                    String string = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_jbossXmlCannotParse", (Object)this.jbossWebFile.getAbsolutePath());
                    throw new ConfigurationException(string);
                }
                NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_jbossWebXmlNotValid"), 2);
                Object object2 = DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                if (object2 == NotifyDescriptor.CANCEL_OPTION) {
                    return;
                }
                jbossWeb = object;
            }
            jbossWebModifier.modify(jbossWeb);
            boolean bl = this.deploymentDescriptorDO.isModified();
            ResourceConfigurationHelper.replaceDocument(styledDocument, jbossWeb);
            if (!bl && (object = (SaveCookie)this.deploymentDescriptorDO.getCookie(SaveCookie.class)) != null) {
                object.save();
            }
            object = this;
            synchronized (object) {
                this.jbossWeb = jbossWeb;
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
        catch (IOException iOException) {
            String string = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_CannotUpdateFile", (Object)this.jbossWebFile.getAbsolutePath());
            throw new ConfigurationException(string, (Throwable)iOException);
        }
    }

    private JbossWeb generateJbossWeb() {
        JbossWeb jbossWeb = new JbossWeb(null, 2);
        jbossWeb.setContextRoot("");
        return jbossWeb;
    }

    private boolean isCorrectCP(String string) {
        boolean bl = true;
        if (!string.equals("") && !string.startsWith("/")) {
            bl = false;
        } else if (string.endsWith("/")) {
            bl = false;
        } else if (string.indexOf("//") >= 0) {
            bl = false;
        }
        return bl;
    }

    private static interface JbossWebModifier {
        public void modify(JbossWeb var1);
    }
}

