/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.lang.model.element.ElementKind;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.usages.BinaryAnalyser;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClassIndexManager;
import org.netbeans.modules.java.source.usages.ClasspathInfoAccessor;
import org.netbeans.modules.java.source.usages.Index;
import org.netbeans.modules.java.source.usages.IndexFactory;
import org.netbeans.modules.java.source.usages.LuceneIndexFactory;
import org.netbeans.modules.java.source.usages.ResultConvertor;
import org.netbeans.modules.java.source.usages.SourceAnalyser;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public class PersistentClassIndex
extends ClassIndexImpl {
    private final Index index;
    private final URL root;
    private final File cacheRoot;
    private final boolean isSource;
    private URL dirty;
    private static final Logger LOGGER = Logger.getLogger(PersistentClassIndex.class.getName());
    private static IndexFactory indexFactory = LuceneIndexFactory.getInstance();

    private PersistentClassIndex(URL root, File cacheRoot, boolean source) throws IOException, IllegalArgumentException {
        assert (root != null);
        this.root = root;
        assert (indexFactory != null);
        this.cacheRoot = cacheRoot;
        this.index = indexFactory.create(cacheRoot);
        this.isSource = source;
    }

    @Override
    public BinaryAnalyser getBinaryAnalyser() {
        return new BinaryAnalyser(this.index, this.cacheRoot);
    }

    @Override
    public SourceAnalyser getSourceAnalyser() {
        return new SourceAnalyser(this.index);
    }

    @Override
    public boolean isSource() {
        return this.isSource;
    }

    @Override
    public boolean isEmpty() {
        try {
            return ClassIndexManager.getDefault().readLock(new ClassIndexManager.ExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws IOException, InterruptedException {
                    return !PersistentClassIndex.this.index.exists();
                }
            });
        }
        catch (InterruptedException ie) {
            return false;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    @Override
    public FileObject[] getSourceRoots() {
        FileObject[] rootFos;
        if (this.isSource) {
            FileObject[] fileObjectArray;
            FileObject rootFo = URLMapper.findFileObject((URL)this.root);
            if (rootFo == null) {
                fileObjectArray = new FileObject[]{};
            } else {
                FileObject[] fileObjectArray2 = new FileObject[1];
                fileObjectArray = fileObjectArray2;
                fileObjectArray2[0] = rootFo;
            }
            rootFos = fileObjectArray;
        } else {
            rootFos = SourceForBinaryQuery.findSourceRoots((URL)this.root).getRoots();
        }
        return rootFos;
    }

    @Override
    public String getSourceName(String binaryName) throws IOException {
        return this.index.getSourceName(binaryName);
    }

    public static ClassIndexImpl create(URL root, File cacheRoot, boolean indexNow) throws IOException, IllegalArgumentException {
        return new PersistentClassIndex(root, cacheRoot, indexNow);
    }

    @Override
    public <T> void search(final String binaryName, final Set<ClassIndexImpl.UsageType> usageType, final ResultConvertor<T> convertor, final Set<? super T> result) throws InterruptedException, IOException {
        this.updateDirty();
        if (BinaryAnalyser.OBJECT.equals(binaryName)) {
            this.getDeclaredTypes("", ClassIndex.NameKind.PREFIX, convertor, result);
            return;
        }
        ClassIndexManager.getDefault().readLock(new ClassIndexManager.ExceptionAction<Void>(){

            @Override
            public Void run() throws IOException, InterruptedException {
                PersistentClassIndex.this.usages(binaryName, usageType, convertor, result);
                return null;
            }
        });
    }

    @Override
    public <T> void getDeclaredTypes(final String simpleName, final ClassIndex.NameKind kind, final ResultConvertor<T> convertor, final Set<? super T> result) throws InterruptedException, IOException {
        this.updateDirty();
        ClassIndexManager.getDefault().readLock(new ClassIndexManager.ExceptionAction<Void>(){

            @Override
            public Void run() throws IOException, InterruptedException {
                PersistentClassIndex.this.index.getDeclaredTypes(simpleName, kind, convertor, result);
                return null;
            }
        });
    }

    @Override
    public <T> void getDeclaredElements(final String ident, final ClassIndex.NameKind kind, final ResultConvertor<T> convertor, final Map<T, Set<String>> result) throws InterruptedException, IOException {
        this.updateDirty();
        ClassIndexManager.getDefault().readLock(new ClassIndexManager.ExceptionAction<Void>(){

            @Override
            public Void run() throws IOException, InterruptedException {
                PersistentClassIndex.this.index.getDeclaredElements(ident, kind, convertor, result);
                return null;
            }
        });
    }

    @Override
    public void getPackageNames(final String prefix, final boolean directOnly, final Set<String> result) throws InterruptedException, IOException {
        ClassIndexManager.getDefault().readLock(new ClassIndexManager.ExceptionAction<Void>(){

            @Override
            public Void run() throws IOException, InterruptedException {
                PersistentClassIndex.this.index.getPackageNames(prefix, directOnly, result);
                return null;
            }
        });
    }

    @Override
    public synchronized void setDirty(URL url) {
        this.dirty = url;
    }

    public String toString() {
        return "CompromiseUQ[" + this.root.toExternalForm() + "]";
    }

    public static void setIndexFactory(IndexFactory factory) {
        indexFactory = factory == null ? LuceneIndexFactory.getInstance() : factory;
    }

    @Override
    protected final void close() throws IOException {
        this.index.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDirty() {
        URL url;
        PersistentClassIndex persistentClassIndex = this;
        synchronized (persistentClassIndex) {
            url = this.dirty;
        }
        if (url != null) {
            JavaSource js;
            FileObject file = url != null ? URLMapper.findFileObject((URL)url) : null;
            JavaSource javaSource = js = file != null ? JavaSource.forFileObject(file) : null;
            if (js != null) {
                FileObject fo;
                long startTime = System.currentTimeMillis();
                Iterator<FileObject> files = js.getFileObjects().iterator();
                FileObject fileObject = fo = files.hasNext() ? files.next() : null;
                if (fo != null && fo.isValid()) {
                    try {
                        js.runUserActionTask(new Task<CompilationController>(){

                            @Override
                            public void run(final CompilationController controller) {
                                try {
                                    ClassIndexManager.getDefault().takeWriteLock(new ClassIndexManager.ExceptionAction<Void>(){

                                        @Override
                                        public Void run() throws IOException {
                                            controller.toPhase(JavaSource.Phase.RESOLVED);
                                            SourceAnalyser sa = PersistentClassIndex.this.getSourceAnalyser();
                                            sa.analyseUnitAndStore(controller.getCompilationUnit(), JavaSourceAccessor.getINSTANCE().getJavacTask(controller), ClasspathInfoAccessor.getINSTANCE().getFileManager(controller.getClasspathInfo()));
                                            return null;
                                        }
                                    });
                                }
                                catch (ClassIndexImpl.IndexAlreadyClosedException e) {
                                    LOGGER.info("Ignoring store into closed index");
                                }
                                catch (IOException ioe) {
                                    Exceptions.printStackTrace((Throwable)ioe);
                                }
                                catch (InterruptedException e) {
                                    Exceptions.printStackTrace((Throwable)e);
                                }
                            }
                        }, true);
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                }
                PersistentClassIndex ioe = this;
                synchronized (ioe) {
                    this.dirty = null;
                }
                long endTime = System.currentTimeMillis();
                LOGGER.fine("PersistentClassIndex.updateDirty took: " + (endTime - startTime) + " ms");
            }
        }
    }

    private <T> void usages(String binaryName, Set<ClassIndexImpl.UsageType> usageType, ResultConvertor<T> convertor, Set<? super T> result) throws InterruptedException, IOException {
        List<String> classInternalNames = this.getUsagesFQN(binaryName, usageType, Index.BooleanOperator.OR);
        for (String classInternalName : classInternalNames) {
            T value = convertor.convert(ElementKind.OTHER, classInternalName);
            if (value == null) continue;
            result.add(value);
        }
    }

    private List<String> getUsagesFQN(String binaryName, Set<ClassIndexImpl.UsageType> mask, Index.BooleanOperator operator) throws InterruptedException, IOException {
        List<String> result = this.index.getUsagesFQN(binaryName, mask, operator);
        if (result == null) {
            result = Collections.emptyList();
        }
        return result;
    }
}

