/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.usages;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.java.source.classpath.AptCacheForSourceQuery;
import org.netbeans.modules.java.source.indexing.JavaIndex;
import org.netbeans.modules.java.source.usages.ClassIndexImpl;
import org.netbeans.modules.java.source.usages.ClassIndexManagerEvent;
import org.netbeans.modules.java.source.usages.ClassIndexManagerListener;
import org.netbeans.modules.java.source.usages.PersistentClassIndex;
import org.netbeans.modules.parsing.impl.Utilities;
import org.openide.util.Exceptions;

public final class ClassIndexManager {
    private static final byte OP_ADD = 1;
    private static final byte OP_REMOVE = 2;
    private static ClassIndexManager instance;
    private final Map<URL, ClassIndexImpl> instances = new HashMap<URL, ClassIndexImpl>();
    private final ReentrantReadWriteLock lock;
    private final InternalLock internalLock;
    private final Map<ClassIndexManagerListener, Void> listeners = Collections.synchronizedMap(new IdentityHashMap());
    private boolean invalid;
    private Set<URL> added;
    private Set<URL> removed;
    private int depth = 0;

    private ClassIndexManager() {
        this.lock = new ReentrantReadWriteLock(false);
        this.internalLock = new InternalLock();
    }

    public void addClassIndexManagerListener(ClassIndexManagerListener listener) {
        assert (listener != null);
        this.listeners.put(listener, null);
    }

    public void removeClassIndexManagerListener(ClassIndexManagerListener listener) {
        assert (listener != null);
        this.listeners.remove(listener);
    }

    @Deprecated
    public <T> T writeLock(final ExceptionAction<T> r) throws IOException, InterruptedException {
        return this.prepareWriteLock(new ExceptionAction<T>(){

            @Override
            public T run() throws IOException, InterruptedException {
                return ClassIndexManager.this.takeWriteLock(r);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T prepareWriteLock(ExceptionAction<T> r) throws IOException, InterruptedException {
        InternalLock internalLock = this.internalLock;
        synchronized (internalLock) {
            ++this.depth;
            if (this.depth == 1) {
                this.added = new HashSet<URL>();
                this.removed = new HashSet<URL>();
            }
        }
        try {
            InternalLock internalLock2;
            HashSet<URL> removedCp;
            HashSet<URL> addedCp;
            try {
                internalLock = r.run();
                addedCp = null;
                removedCp = null;
                internalLock2 = this.internalLock;
            }
            catch (Throwable throwable) {
                HashSet<URL> addedCp2 = null;
                HashSet<URL> removedCp2 = null;
                InternalLock internalLock3 = this.internalLock;
                synchronized (internalLock3) {
                    if (this.depth == 1) {
                        if (!this.removed.isEmpty()) {
                            removedCp2 = new HashSet<URL>(this.removed);
                            this.removed.clear();
                        }
                        if (!this.added.isEmpty()) {
                            addedCp2 = new HashSet<URL>(this.added);
                            this.added.clear();
                        }
                    }
                }
                if (removedCp2 != null) {
                    this.fire(removedCp2, (byte)2);
                }
                if (addedCp2 != null) {
                    this.fire(addedCp2, (byte)1);
                }
                throw throwable;
            }
            synchronized (internalLock2) {
                if (this.depth == 1) {
                    if (!this.removed.isEmpty()) {
                        removedCp = new HashSet<URL>(this.removed);
                        this.removed.clear();
                    }
                    if (!this.added.isEmpty()) {
                        addedCp = new HashSet<URL>(this.added);
                        this.added.clear();
                    }
                }
            }
            if (removedCp != null) {
                this.fire(removedCp, (byte)2);
            }
            if (addedCp != null) {
                this.fire(addedCp, (byte)1);
            }
            return (T)internalLock;
        }
        finally {
            InternalLock internalLock4 = this.internalLock;
            synchronized (internalLock4) {
                --this.depth;
            }
        }
    }

    public <T> T takeWriteLock(final ExceptionAction<T> r) throws IOException, InterruptedException {
        this.lock.writeLock().lock();
        try {
            Object object = Utilities.runPriorityIO((Callable)new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return r.run();
                }
            });
            return (T)object;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public <T> T readLock(final ExceptionAction<T> r) throws IOException, InterruptedException {
        this.lock.readLock().lock();
        try {
            Object object = Utilities.runPriorityIO((Callable)new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return r.run();
                }
            });
            return (T)object;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean holdsWriteLock() {
        return this.lock.isWriteLockedByCurrentThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassIndexImpl getUsagesQuery(URL root) {
        InternalLock internalLock = this.internalLock;
        synchronized (internalLock) {
            assert (root != null);
            if (this.invalid) {
                return null;
            }
            ClassIndexImpl index = this.instances.get(root);
            if (index != null) {
                return index;
            }
            ClassIndexImpl classIndexImpl = (root = AptCacheForSourceQuery.getSourceFolder(root)) == null ? null : this.instances.get(root);
            return classIndexImpl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassIndexImpl createUsagesQuery(URL root, boolean source) throws IOException {
        assert (root != null);
        InternalLock internalLock = this.internalLock;
        synchronized (internalLock) {
            if (this.invalid) {
                return null;
            }
            ClassIndexImpl qi = this.instances.get(root);
            if (qi == null) {
                qi = PersistentClassIndex.create(root, JavaIndex.getIndex(root), source);
                this.instances.put(root, qi);
                if (this.added != null) {
                    this.added.add(root);
                }
            } else if (source && !qi.isSource()) {
                qi.close();
                qi = PersistentClassIndex.create(root, JavaIndex.getIndex(root), source);
                this.instances.put(root, qi);
                if (this.added != null) {
                    this.added.add(root);
                }
            }
            return qi;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRoot(URL root) throws IOException {
        InternalLock internalLock = this.internalLock;
        synchronized (internalLock) {
            ClassIndexImpl ci = this.instances.remove(root);
            if (ci != null) {
                ci.close();
                if (this.removed != null) {
                    this.removed.add(root);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        InternalLock internalLock = this.internalLock;
        synchronized (internalLock) {
            this.invalid = true;
            for (ClassIndexImpl ci : this.instances.values()) {
                try {
                    ci.close();
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fire(Set<? extends URL> roots, byte op) {
        if (!this.listeners.isEmpty()) {
            ClassIndexManagerListener[] _listeners;
            Map<ClassIndexManagerListener, Void> map = this.listeners;
            synchronized (map) {
                _listeners = this.listeners.keySet().toArray(new ClassIndexManagerListener[this.listeners.size()]);
            }
            ClassIndexManagerEvent event = new ClassIndexManagerEvent(this, roots);
            for (ClassIndexManagerListener listener : _listeners) {
                if (op == 1) {
                    listener.classIndexAdded(event);
                    continue;
                }
                if (op == 2) {
                    listener.classIndexRemoved(event);
                    continue;
                }
                assert (false) : "Unknown op: " + op;
            }
        }
    }

    public static synchronized ClassIndexManager getDefault() {
        if (instance == null) {
            instance = new ClassIndexManager();
        }
        return instance;
    }

    private static final class InternalLock {
        private InternalLock() {
        }
    }

    public static interface ExceptionAction<T> {
        public T run() throws IOException, InterruptedException;
    }
}

