/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.builder;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.util.Context;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.java.source.Comment;
import org.netbeans.modules.java.source.builder.CommentSetImpl;
import org.netbeans.modules.java.source.query.CommentHandler;

public class CommentHandlerService
implements CommentHandler {
    private static final Context.Key<CommentHandlerService> commentHandlerKey = new Context.Key();
    private final Map<Tree, CommentSetImpl> map = new HashMap<Tree, CommentSetImpl>();

    public static CommentHandlerService instance(Context context) {
        CommentHandlerService instance = context.get(commentHandlerKey);
        if (instance == null) {
            instance = new CommentHandlerService(context);
            CommentHandlerService.setCommentHandler(context, instance);
        }
        return instance;
    }

    public static void setCommentHandler(Context context, CommentHandlerService instance) {
        assert (context.get(commentHandlerKey) == null);
        context.put(commentHandlerKey, instance);
    }

    private CommentHandlerService(Context context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasComments(Tree tree) {
        Map<Tree, CommentSetImpl> map = this.map;
        synchronized (map) {
            return this.map.containsKey(tree);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommentSetImpl getComments(Tree tree) {
        Map<Tree, CommentSetImpl> map = this.map;
        synchronized (map) {
            CommentSetImpl cs = this.map.get(tree);
            if (cs == null) {
                cs = new CommentSetImpl();
                this.map.put(tree, cs);
            }
            return cs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyComments(Tree fromTree, Tree toTree) {
        if (fromTree == toTree) {
            return;
        }
        Map<Tree, CommentSetImpl> map = this.map;
        synchronized (map) {
            CommentSetImpl from = this.map.get(fromTree);
            if (from != null) {
                CommentSetImpl to = this.map.get(toTree);
                if (to == null) {
                    to = (CommentSetImpl)from.clone();
                    this.map.put(toTree, to);
                } else {
                    to.addPrecedingComments(from.getPrecedingComments());
                    to.addTrailingComments(from.getTrailingComments());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addComment(Tree tree, Comment c) {
        Map<Tree, CommentSetImpl> map = this.map;
        synchronized (map) {
            CommentSetImpl set = this.map.get(tree);
            if (set == null) {
                set = new CommentSetImpl();
                this.map.put(tree, set);
            }
            set.addPrecedingComment(c);
        }
    }

    public String toString() {
        return "CommentHandlerService[map=" + this.map + ']';
    }
}

