/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.source.JavaSourceAccessor;
import org.netbeans.modules.java.source.builder.CommentHandlerService;
import org.netbeans.modules.java.source.builder.CommentSetImpl;
import org.netbeans.modules.java.source.query.CommentHandler;
import org.netbeans.modules.java.source.query.CommentSet;

class TranslateIdentifier
implements TreeVisitor<Tree, Boolean> {
    private final CompilationInfo info;
    private final TreeMaker make;
    private final CompilationUnitTree unit;
    private final boolean copyComments;
    private final boolean resolveImports;
    private final TokenSequence<JavaTokenId> seq;
    private final CommentHandlerService commentService;
    private final SourcePositions positions;
    private int tokenIndexAlreadyAdded = -1;
    private Element rootElement;
    private static Logger log = Logger.getLogger(TranslateIdentifier.class.getName());

    public TranslateIdentifier(CompilationInfo info, boolean copyComments, boolean resolveImports, TokenSequence<JavaTokenId> seq) {
        this(info, copyComments, resolveImports, seq, info.getCompilationUnit());
    }

    public TranslateIdentifier(CompilationInfo info, boolean copyComments, boolean resolveImports, TokenSequence<JavaTokenId> seq, CompilationUnitTree cut) {
        this(info, copyComments, resolveImports, seq, cut, info.getTrees().getSourcePositions());
    }

    public TranslateIdentifier(CompilationInfo info, boolean copyComments, boolean resolveImports, TokenSequence<JavaTokenId> seq, SourcePositions positions) {
        this(info, copyComments, resolveImports, seq, info.getCompilationUnit(), positions);
    }

    private TranslateIdentifier(CompilationInfo info, boolean copyComments, boolean resolveImports, TokenSequence<JavaTokenId> seq, CompilationUnitTree cut, SourcePositions positions) {
        this.info = info;
        this.make = info instanceof WorkingCopy ? ((WorkingCopy)info).getTreeMaker() : null;
        this.unit = cut;
        this.seq = seq;
        this.copyComments = copyComments;
        this.resolveImports = resolveImports;
        this.commentService = CommentHandlerService.instance(info.impl.getJavacTask().getContext());
        this.positions = positions;
    }

    @Override
    public Tree visitAnnotation(AnnotationTree node, Boolean p) {
        Tree annotationType = this.translateTree(node.getAnnotationType());
        List<? extends ExpressionTree> arguments = this.translateTree(node.getArguments());
        if (this.make == null) {
            return node;
        }
        if (annotationType != node.getAnnotationType() || arguments != node.getArguments()) {
            node = this.make.Annotation(annotationType, arguments);
        }
        return node;
    }

    @Override
    public Tree visitMethodInvocation(MethodInvocationTree node, Boolean p) {
        List<? extends ExpressionTree> arguments = this.translateTree(node.getArguments());
        ExpressionTree methodSelect = (ExpressionTree)this.translateTree(node.getMethodSelect());
        List<? extends Tree> typeArguments = this.translateTree(node.getTypeArguments());
        if (this.make == null) {
            return node;
        }
        if (arguments != node.getArguments() || methodSelect != node.getMethodSelect() || typeArguments != node.getTypeArguments()) {
            node = this.make.MethodInvocation(typeArguments, methodSelect, arguments);
        }
        return node;
    }

    @Override
    public Tree visitAssert(AssertTree node, Boolean p) {
        ExpressionTree condition = (ExpressionTree)this.translateTree(node.getCondition());
        ExpressionTree detail = (ExpressionTree)this.translateTree(node.getDetail());
        if (this.make == null) {
            return node;
        }
        if (condition != node.getCondition() || detail != node.getDetail()) {
            node = this.make.Assert(condition, detail);
        }
        return node;
    }

    @Override
    public Tree visitAssignment(AssignmentTree node, Boolean p) {
        ExpressionTree expression = (ExpressionTree)this.translateTree(node.getExpression());
        ExpressionTree variable = (ExpressionTree)this.translateTree(node.getVariable());
        if (this.make == null) {
            return node;
        }
        if (expression != node.getExpression() || variable != node.getVariable()) {
            node = this.make.Assignment(variable, expression);
        }
        return node;
    }

    @Override
    public Tree visitCompoundAssignment(CompoundAssignmentTree node, Boolean p) {
        ExpressionTree expression = (ExpressionTree)this.translateTree(node.getExpression());
        ExpressionTree variable = (ExpressionTree)this.translateTree(node.getVariable());
        if (this.make == null) {
            return node;
        }
        if (expression != node.getExpression() || variable != node.getVariable()) {
            node = this.make.CompoundAssignment(node.getKind(), variable, expression);
        }
        return node;
    }

    @Override
    public Tree visitBinary(BinaryTree node, Boolean p) {
        ExpressionTree leftOperand = (ExpressionTree)this.translateTree(node.getLeftOperand());
        ExpressionTree rightOperand = (ExpressionTree)this.translateTree(node.getRightOperand());
        if (this.make == null) {
            return node;
        }
        if (leftOperand != node.getLeftOperand() || rightOperand != node.getRightOperand()) {
            node = this.make.Binary(node.getKind(), leftOperand, rightOperand);
        }
        return node;
    }

    @Override
    public Tree visitBlock(BlockTree node, Boolean p) {
        List<? extends StatementTree> statements = this.translateTree(node.getStatements());
        if (this.make == null) {
            return node;
        }
        if (statements != node.getStatements()) {
            node = this.make.Block(statements, node.isStatic());
        }
        return node;
    }

    @Override
    public Tree visitBreak(BreakTree node, Boolean p) {
        return node;
    }

    @Override
    public Tree visitCase(CaseTree node, Boolean p) {
        ExpressionTree expression = (ExpressionTree)this.translateTree(node.getExpression(), true);
        List<? extends StatementTree> statements = this.translateTree(node.getStatements());
        if (this.make == null) {
            return node;
        }
        if (expression != node.getExpression() || statements != node.getStatements()) {
            node = this.make.Case(expression, statements);
        }
        return node;
    }

    @Override
    public Tree visitCatch(CatchTree node, Boolean p) {
        BlockTree block = (BlockTree)this.translateTree(node.getBlock());
        VariableTree parameter = (VariableTree)this.translateTree(node.getParameter());
        if (this.make == null) {
            return node;
        }
        if (block != node.getBlock() || parameter != node.getParameter()) {
            node = this.make.Catch(parameter, block);
        }
        return node;
    }

    @Override
    public Tree visitClass(ClassTree node, Boolean p) {
        Tree extendsClause = this.translateTree(node.getExtendsClause());
        List<? extends Tree> implementsClause = this.translateTree(node.getImplementsClause());
        List<? extends Tree> members = this.translateTree(node.getMembers());
        ModifiersTree modifiers = (ModifiersTree)this.translateTree(node.getModifiers());
        List<? extends TypeParameterTree> typeParameters = this.translateTree(node.getTypeParameters());
        if (this.make == null) {
            return node;
        }
        if (extendsClause != node.getExtendsClause() || implementsClause != node.getImplementsClause() || members != node.getMembers() || modifiers != node.getModifiers() || typeParameters != node.getTypeParameters()) {
            node = this.make.Class(modifiers, node.getSimpleName(), typeParameters, extendsClause, implementsClause, members);
        }
        return node;
    }

    @Override
    public Tree visitConditionalExpression(ConditionalExpressionTree node, Boolean p) {
        ExpressionTree condition = (ExpressionTree)this.translateTree(node.getCondition());
        ExpressionTree falseExpression = (ExpressionTree)this.translateTree(node.getFalseExpression());
        ExpressionTree trueExpression = (ExpressionTree)this.translateTree(node.getTrueExpression());
        if (this.make == null) {
            return node;
        }
        if (condition != node.getCondition() || falseExpression != node.getFalseExpression() || trueExpression != node.getTrueExpression()) {
            node = this.make.ConditionalExpression(condition, trueExpression, falseExpression);
        }
        return node;
    }

    @Override
    public Tree visitContinue(ContinueTree node, Boolean p) {
        return node;
    }

    @Override
    public Tree visitDoWhileLoop(DoWhileLoopTree node, Boolean p) {
        StatementTree statement = (StatementTree)this.translateTree(node.getStatement());
        ExpressionTree condition = (ExpressionTree)this.translateTree(node.getCondition());
        if (this.make == null) {
            return node;
        }
        if (condition != node.getCondition() || statement != node.getStatement()) {
            node = this.make.DoWhileLoop(condition, statement);
        }
        return node;
    }

    @Override
    public Tree visitErroneous(ErroneousTree node, Boolean p) {
        List<? extends Tree> errorTrees = this.translateTree(node.getErrorTrees());
        if (this.make == null) {
            return node;
        }
        if (errorTrees != node.getErrorTrees()) {
            node = this.make.Erroneous(errorTrees);
        }
        return node;
    }

    @Override
    public Tree visitExpressionStatement(ExpressionStatementTree node, Boolean p) {
        ExpressionTree expression = (ExpressionTree)this.translateTree(node.getExpression());
        if (this.make == null) {
            return node;
        }
        if (expression != node.getExpression()) {
            node = this.make.ExpressionStatement(expression);
        }
        return node;
    }

    @Override
    public Tree visitEnhancedForLoop(EnhancedForLoopTree node, Boolean p) {
        StatementTree statement = (StatementTree)this.translateTree(node.getStatement());
        ExpressionTree expression = (ExpressionTree)this.translateTree(node.getExpression());
        VariableTree variable = (VariableTree)this.translateTree(node.getVariable());
        if (this.make == null) {
            return node;
        }
        if (statement != node.getStatement() || expression != node.getExpression() || variable != node.getVariable()) {
            node = this.make.EnhancedForLoop(variable, expression, statement);
        }
        return node;
    }

    @Override
    public Tree visitForLoop(ForLoopTree node, Boolean p) {
        StatementTree statement = (StatementTree)this.translateTree(node.getStatement());
        ExpressionTree condition = (ExpressionTree)this.translateTree(node.getCondition());
        List<? extends StatementTree> initializer = this.translateTree(node.getInitializer());
        List<? extends ExpressionStatementTree> update = this.translateTree(node.getUpdate());
        if (this.make == null) {
            return node;
        }
        if (statement != node.getStatement() || condition != node.getCondition() || initializer != node.getInitializer() || update != node.getUpdate()) {
            node = this.make.ForLoop(initializer, condition, update, statement);
        }
        return node;
    }

    @Override
    public Tree visitIdentifier(IdentifierTree node, Boolean p) {
        if (!this.resolveImports) {
            return node;
        }
        if (this.make == null) {
            return node;
        }
        TreePath path = this.info.getTrees().getPath(this.unit, node);
        Element element = path == null ? ((JCTree.JCIdent)node).sym : this.info.getTrees().getElement(path);
        if (element != null && (element.getKind().isClass() || element.getKind().isInterface() || element.getKind().isField() && ((Symbol)element).isStatic())) {
            boolean en;
            TreePath elmPath = this.info.getTrees().getPath(element);
            boolean bl = en = p == Boolean.TRUE && element.getKind() == ElementKind.ENUM_CONSTANT;
            if (path == null && element == this.rootElement || path != null && elmPath != null && path.getCompilationUnit().getSourceFile() == elmPath.getCompilationUnit().getSourceFile() || en) {
                return this.make.Identifier(element.getSimpleName());
            }
            return this.make.QualIdent(element);
        }
        return node;
    }

    @Override
    public Tree visitIf(IfTree node, Boolean p) {
        ExpressionTree condition = (ExpressionTree)this.translateTree(node.getCondition());
        StatementTree elseStatement = (StatementTree)this.translateTree(node.getElseStatement());
        StatementTree thenStatement = (StatementTree)this.translateTree(node.getThenStatement());
        if (this.make == null) {
            return node;
        }
        if (condition != node.getCondition() || elseStatement != node.getElseStatement() || thenStatement != node.getThenStatement()) {
            node = this.make.If(condition, thenStatement, elseStatement);
        }
        return node;
    }

    @Override
    public Tree visitImport(ImportTree node, Boolean p) {
        return node;
    }

    @Override
    public Tree visitArrayAccess(ArrayAccessTree node, Boolean p) {
        ExpressionTree expression = (ExpressionTree)this.translateTree(node.getExpression());
        ExpressionTree index = (ExpressionTree)this.translateTree(node.getIndex());
        if (this.make == null) {
            return node;
        }
        if (expression != node.getExpression() || index != node.getIndex()) {
            node = this.make.ArrayAccess(expression, index);
        }
        return node;
    }

    @Override
    public Tree visitLabeledStatement(LabeledStatementTree node, Boolean p) {
        StatementTree statement = (StatementTree)this.translateTree(node.getStatement());
        if (this.make == null) {
            return node;
        }
        if (statement != node.getStatement()) {
            node = this.make.LabeledStatement(node.getLabel(), statement);
        }
        return node;
    }

    @Override
    public Tree visitLiteral(LiteralTree node, Boolean p) {
        return node;
    }

    @Override
    public Tree visitMethod(MethodTree node, Boolean p) {
        BlockTree body = (BlockTree)this.translateTree(node.getBody());
        Tree defaultValue = this.translateTree(node.getDefaultValue());
        List<? extends VariableTree> parameters = this.translateTree(node.getParameters());
        ModifiersTree modifiers = (ModifiersTree)this.translateTree(node.getModifiers());
        Tree returnType = this.translateTree(node.getReturnType());
        List<? extends ExpressionTree> aThrows = this.translateTree(node.getThrows());
        List<? extends TypeParameterTree> typeParameters = this.translateTree(node.getTypeParameters());
        if (this.make == null) {
            return node;
        }
        if (body != node.getBody() || defaultValue != node.getDefaultValue() || parameters != node.getParameters() || modifiers != node.getModifiers() || returnType != node.getReturnType() || aThrows != node.getThrows() || typeParameters != node.getTypeParameters()) {
            node = this.make.Method(modifiers, (CharSequence)node.getName(), returnType, typeParameters, parameters, aThrows, body, (ExpressionTree)defaultValue);
        }
        return node;
    }

    @Override
    public Tree visitModifiers(ModifiersTree node, Boolean p) {
        List<? extends AnnotationTree> annotations = this.translateTree(node.getAnnotations());
        if (this.make == null) {
            return node;
        }
        if (annotations != node.getAnnotations()) {
            node = this.make.Modifiers(node.getFlags(), annotations);
        }
        return node;
    }

    @Override
    public Tree visitNewArray(NewArrayTree node, Boolean p) {
        List<? extends ExpressionTree> initializers = this.translateTree(node.getInitializers());
        List<? extends ExpressionTree> dimensions = this.translateTree(node.getDimensions());
        Tree type = this.translateTree(node.getType());
        if (this.make == null) {
            return node;
        }
        if (initializers != node.getInitializers() || dimensions != node.getDimensions() || type != node.getType()) {
            node = this.make.NewArray(type, dimensions, initializers);
        }
        return node;
    }

    @Override
    public Tree visitNewClass(NewClassTree node, Boolean p) {
        List<? extends ExpressionTree> arguments = this.translateTree(node.getArguments());
        ClassTree classBody = (ClassTree)this.translateTree(node.getClassBody());
        ExpressionTree enclosingExpression = (ExpressionTree)this.translateTree(node.getEnclosingExpression());
        ExpressionTree identifier = (ExpressionTree)this.translateTree(node.getIdentifier());
        List<? extends Tree> typeArguments = this.translateTree(node.getTypeArguments());
        if (this.make == null) {
            return node;
        }
        if (arguments != node.getArguments() || classBody != node.getClassBody() || enclosingExpression != node.getEnclosingExpression() || identifier != node.getIdentifier() || typeArguments != node.getTypeArguments()) {
            node = this.make.NewClass(enclosingExpression, typeArguments, identifier, arguments, classBody);
        }
        return node;
    }

    @Override
    public Tree visitParenthesized(ParenthesizedTree node, Boolean p) {
        ExpressionTree expression = (ExpressionTree)this.translateTree(node.getExpression());
        if (this.make == null) {
            return node;
        }
        if (expression != node.getExpression()) {
            node = this.make.Parenthesized(expression);
        }
        return node;
    }

    @Override
    public Tree visitReturn(ReturnTree node, Boolean p) {
        ExpressionTree expression = (ExpressionTree)this.translateTree(node.getExpression());
        if (this.make == null) {
            return node;
        }
        if (expression != node.getExpression()) {
            node = this.make.Return(expression);
        }
        return node;
    }

    @Override
    public Tree visitMemberSelect(MemberSelectTree node, Boolean p) {
        if (this.make == null) {
            return node;
        }
        TypeElement e = this.info.getElements().getTypeElement(node.toString());
        if (e != null) {
            return this.make.QualIdent(e);
        }
        ExpressionTree expression = (ExpressionTree)this.translateTree(node.getExpression());
        if (expression != node.getExpression()) {
            node = this.make.MemberSelect(expression, node.getIdentifier());
        }
        return node;
    }

    @Override
    public Tree visitEmptyStatement(EmptyStatementTree node, Boolean p) {
        return node;
    }

    @Override
    public Tree visitSwitch(SwitchTree node, Boolean p) {
        List<? extends CaseTree> cases = this.translateTree(node.getCases());
        ExpressionTree expression = (ExpressionTree)this.translateTree(node.getExpression());
        if (this.make == null) {
            return node;
        }
        if (cases != node.getCases() || expression != node.getExpression()) {
            node = this.make.Switch(expression, cases);
        }
        return node;
    }

    @Override
    public Tree visitSynchronized(SynchronizedTree node, Boolean p) {
        BlockTree block = (BlockTree)this.translateTree(node.getBlock());
        ExpressionTree expression = (ExpressionTree)this.translateTree(node.getExpression());
        if (this.make == null) {
            return node;
        }
        if (block != node.getBlock() || expression != node.getExpression()) {
            node = this.make.Synchronized(expression, block);
        }
        return node;
    }

    @Override
    public Tree visitThrow(ThrowTree node, Boolean p) {
        ExpressionTree expression = (ExpressionTree)this.translateTree(node.getExpression());
        if (this.make == null) {
            return node;
        }
        if (expression != node.getExpression()) {
            node = this.make.Throw(expression);
        }
        return node;
    }

    @Override
    public Tree visitCompilationUnit(CompilationUnitTree node, Boolean p) {
        List<? extends Tree> typeDecls = this.translateTree(node.getTypeDecls());
        if (this.make == null) {
            return node;
        }
        if (typeDecls != node.getTypeDecls()) {
            node = this.make.CompilationUnit(node.getPackageName(), node.getImports(), typeDecls, node.getSourceFile());
        }
        return node;
    }

    @Override
    public Tree visitTry(TryTree node, Boolean p) {
        BlockTree block = (BlockTree)this.translateTree(node.getBlock());
        List<? extends CatchTree> catches = this.translateTree(node.getCatches());
        BlockTree finallyBlock = (BlockTree)this.translateTree(node.getFinallyBlock());
        if (this.make == null) {
            return node;
        }
        if (block != node.getBlock() || catches != node.getCatches() || finallyBlock != node.getFinallyBlock()) {
            node = this.make.Try(block, catches, finallyBlock);
        }
        return node;
    }

    @Override
    public Tree visitParameterizedType(ParameterizedTypeTree node, Boolean p) {
        Tree type = this.translateTree(node.getType());
        List<? extends Tree> typeArguments = this.translateTree(node.getTypeArguments());
        if (this.make == null) {
            return node;
        }
        if (type != node.getType() || typeArguments != node.getTypeArguments()) {
            node = this.make.ParameterizedType(type, typeArguments);
        }
        return node;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tree visitAnnotatedType(AnnotatedTypeTree node, Boolean p) {
        List<? extends AnnotationTree> annotations = this.translateTree(node.getAnnotations());
        Tree type = this.translateTree(node.getUnderlyingType());
        if (this.make == null) {
            return node;
        }
        if (type != node.getUnderlyingType() || annotations != node.getAnnotations()) {
            LinkedList<void> typeAnnotations = new LinkedList<void>();
            for (AnnotationTree annotationTree : annotations) {
                void var7_7;
                if (!(annotationTree instanceof JCTree.JCTypeAnnotation)) {
                    AnnotationTree annotationTree2 = JavaSourceAccessor.getINSTANCE().makeTypeAnnotation(this.make, annotationTree);
                }
                typeAnnotations.add(var7_7);
            }
            node = JavaSourceAccessor.getINSTANCE().makeAnnotatedType(this.make, typeAnnotations, node);
        }
        return node;
    }

    @Override
    public Tree visitArrayType(ArrayTypeTree node, Boolean p) {
        Tree type = this.translateTree(node.getType());
        if (this.make == null) {
            return node;
        }
        if (type != node.getType()) {
            node = this.make.ArrayType(type);
        }
        return node;
    }

    @Override
    public Tree visitTypeCast(TypeCastTree node, Boolean p) {
        ExpressionTree expression = (ExpressionTree)this.translateTree(node.getExpression());
        Tree type = this.translateTree(node.getType());
        if (this.make == null) {
            return node;
        }
        if (expression != node.getExpression() || type != node.getType()) {
            node = this.make.TypeCast(type, expression);
        }
        return node;
    }

    @Override
    public Tree visitPrimitiveType(PrimitiveTypeTree node, Boolean p) {
        return node;
    }

    @Override
    public Tree visitTypeParameter(TypeParameterTree node, Boolean p) {
        List<? extends Tree> bounds = this.translateTree(node.getBounds());
        if (this.make == null) {
            return node;
        }
        if (bounds != node.getBounds()) {
            node = this.make.TypeParameter(node.getName(), bounds);
        }
        return node;
    }

    @Override
    public Tree visitInstanceOf(InstanceOfTree node, Boolean p) {
        ExpressionTree expression = (ExpressionTree)this.translateTree(node.getExpression());
        Tree type = this.translateTree(node.getType());
        if (this.make == null) {
            return node;
        }
        if (expression != node.getExpression() || type != node.getType()) {
            node = this.make.InstanceOf(expression, type);
        }
        return node;
    }

    @Override
    public Tree visitUnary(UnaryTree node, Boolean p) {
        ExpressionTree expression = (ExpressionTree)this.translateTree(node.getExpression());
        if (this.make == null) {
            return node;
        }
        if (expression != node.getExpression()) {
            node = this.make.Unary(node.getKind(), expression);
        }
        return node;
    }

    @Override
    public Tree visitVariable(VariableTree node, Boolean p) {
        ModifiersTree modifiers = (ModifiersTree)this.translateTree(node.getModifiers());
        Tree type = this.translateTree(node.getType());
        ExpressionTree initializer = (ExpressionTree)this.translateTree(node.getInitializer());
        if (this.make == null) {
            return node;
        }
        if (modifiers != node.getModifiers() || type != node.getType() || initializer != node.getInitializer()) {
            node = this.make.Variable(modifiers, node.getName(), type, initializer);
        }
        return node;
    }

    @Override
    public Tree visitWhileLoop(WhileLoopTree node, Boolean p) {
        StatementTree statement = (StatementTree)this.translateTree(node.getStatement());
        ExpressionTree condition = (ExpressionTree)this.translateTree(node.getCondition());
        if (this.make == null) {
            return node;
        }
        if (condition != node.getCondition() || statement != node.getStatement()) {
            node = this.make.WhileLoop(condition, statement);
        }
        return node;
    }

    @Override
    public Tree visitWildcard(WildcardTree node, Boolean p) {
        Tree tree = this.translateTree(node.getBound());
        if (this.make == null) {
            return node;
        }
        if (tree != node.getBound()) {
            node = this.make.Wildcard(node.getKind(), tree);
        }
        return node;
    }

    @Override
    public Tree visitOther(Tree node, Boolean p) {
        return node;
    }

    public Tree translate(Tree tree) {
        TreePath path;
        if (tree == null) {
            return null;
        }
        if (this.copyComments) {
            this.mapComments2(tree, true);
        }
        if ((path = this.info.getTrees().getPath(this.unit, tree)) == null) {
            if (tree instanceof JCTree.JCClassDecl) {
                this.rootElement = ((JCTree.JCClassDecl)tree).sym;
            }
        } else {
            this.rootElement = this.info.getTrees().getElement(path);
        }
        Tree res = tree.accept(this, null);
        if (this.copyComments) {
            this.mapComments2(tree, false);
        }
        return res;
    }

    private <T extends Tree> List<T> translateTree(List<T> trees) {
        if (trees == null || trees.isEmpty()) {
            return trees;
        }
        ArrayList<Tree> newTrees = new ArrayList<Tree>();
        boolean changed = false;
        for (Tree t : trees) {
            Tree newT = this.translateTree(t);
            if (newT != t) {
                changed = true;
            }
            if (newT == null) continue;
            newTrees.add(newT);
        }
        return changed ? newTrees : trees;
    }

    private Tree translateTree(Tree tree) {
        return this.translateTree(tree, null);
    }

    private Tree translateTree(Tree tree, Boolean p) {
        if (tree == null) {
            return null;
        }
        if (this.copyComments && this.info.getTreeUtilities().isSynthetic(new TreePath(new TreePath(this.info.getCompilationUnit()), tree))) {
            return tree;
        }
        if (this.copyComments) {
            this.mapComments2(tree, true);
        }
        Tree newTree = tree.accept(this, p);
        if (this.copyComments) {
            this.mapComments2(tree, false);
        }
        this.commentService.copyComments(tree, newTree);
        return newTree;
    }

    private void mapComments2(Tree tree, boolean preceding) {
        if (((JCTree)tree).pos <= 0) {
            return;
        }
        this.collect(tree, preceding);
    }

    private void collect(Tree tree, boolean preceding) {
        if (this.isEvil(tree)) {
            return;
        }
        if (preceding) {
            BlockTree blockTree;
            int pos = this.findInterestingStart((JCTree)tree);
            this.seq.move(pos);
            this.lookForPreceedings(this.seq, tree);
            if (tree instanceof BlockTree && (blockTree = (BlockTree)tree).getStatements().isEmpty()) {
                this.lookWithinEmptyBlock(this.seq, blockTree);
            }
        } else {
            this.lookForInline(this.seq, tree);
            this.lookForTrailing(this.seq, tree);
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "T: " + tree + "\nC: " + this.commentService.getComments(tree));
        }
    }

    private void lookForInline(TokenSequence<JavaTokenId> seq, Tree tree) {
        seq.move((int)this.positions.getEndPosition(this.unit, tree));
        CommentsCollection result = new CommentsCollection();
        while (seq.moveNext()) {
            if (seq.index() <= this.tokenIndexAlreadyAdded) continue;
            if (seq.token().id() == JavaTokenId.WHITESPACE) {
                if (this.numberOfNL((Token<JavaTokenId>)seq.token()) <= 0) continue;
                break;
            }
            if (!this.isComment((JavaTokenId)seq.token().id())) break;
            result.add((Token<JavaTokenId>)seq.token());
            this.tokenIndexAlreadyAdded = seq.index();
            if (seq.token().id() != JavaTokenId.LINE_COMMENT) continue;
        }
        if (!result.isEmpty()) {
            CommentSet.RelativePosition position = CommentSet.RelativePosition.INLINE;
            this.attachComments(tree, result, position);
        }
    }

    private void attachComments(Tree tree, CommentsCollection result, CommentSet.RelativePosition position) {
        CommentSetImpl cs = this.commentService.getComments(tree);
        for (Token<JavaTokenId> token : result) {
            this.attachComment(position, cs, token);
        }
    }

    private boolean isEvil(Tree tree) {
        Tree.Kind kind = tree.getKind();
        switch (kind) {
            case MODIFIERS: 
            case COMPILATION_UNIT: 
            case PRIMITIVE_TYPE: {
                return true;
            }
        }
        return false;
    }

    private void lookForTrailing(TokenSequence<JavaTokenId> seq, Tree tree) {
        seq.move((int)this.positions.getEndPosition(this.unit, tree));
        LinkedList<TrailingCommentsDataHolder> comments = new LinkedList<TrailingCommentsDataHolder>();
        int maxLines = 0;
        int newlines = 0;
        while (seq.moveNext()) {
            if (seq.index() <= this.tokenIndexAlreadyAdded) continue;
            Token t = seq.token();
            if (t.id() == JavaTokenId.WHITESPACE) {
                newlines += this.numberOfNL((Token<JavaTokenId>)t);
                continue;
            }
            if (this.isComment((JavaTokenId)t.id())) {
                comments.add(new TrailingCommentsDataHolder(newlines, (Token<JavaTokenId>)t, seq.index()));
                maxLines = Math.max(maxLines, newlines);
                if (t.id() == JavaTokenId.LINE_COMMENT) {
                    newlines = 1;
                    continue;
                }
                newlines = 0;
                continue;
            }
            if (t.id() != JavaTokenId.RBRACE) break;
            maxLines = Integer.MAX_VALUE;
            break;
        }
        int index = seq.index() - 1;
        maxLines = Math.max(maxLines, newlines);
        for (TrailingCommentsDataHolder h : comments) {
            if (h.newlines < maxLines) {
                this.attachComments(Collections.singleton(h.comment), tree, this.commentService, CommentSet.RelativePosition.TRAILING);
                continue;
            }
            index = h.index;
            break;
        }
        this.tokenIndexAlreadyAdded = index;
    }

    private void lookWithinEmptyBlock(TokenSequence<JavaTokenId> seq, BlockTree tree) {
        if (this.moveTo(seq, JavaTokenId.LBRACE, true)) {
            if (seq.moveNext()) {
                CommentsCollection cc = this.getCommentsCollection(seq, Integer.MAX_VALUE);
                this.attachComments(tree, cc, CommentSet.RelativePosition.INNER);
            }
        } else {
            int end = (int)this.positions.getEndPosition(this.unit, tree);
            seq.move(end);
            seq.moveNext();
        }
    }

    private boolean moveTo(TokenSequence<JavaTokenId> seq, JavaTokenId toToken, boolean forward) {
        do {
            if (toToken != seq.token().id()) continue;
            return true;
        } while (!forward ? seq.movePrevious() : seq.moveNext());
        return false;
    }

    private void lookForPreceedings(TokenSequence<JavaTokenId> seq, Tree tree) {
        int reset = ((JCTree)tree).pos;
        CommentsCollection cc = null;
        while (seq.moveNext() && seq.offset() < reset) {
            JavaTokenId id = (JavaTokenId)seq.token().id();
            if (!this.isComment(id)) continue;
            if (cc == null) {
                cc = this.getCommentsCollection(seq, Integer.MAX_VALUE);
                continue;
            }
            cc.merge(this.getCommentsCollection(seq, Integer.MAX_VALUE));
        }
        this.attachComments(cc, tree, this.commentService, CommentSet.RelativePosition.PRECEDING);
        seq.move(reset);
        seq.moveNext();
        this.tokenIndexAlreadyAdded = seq.index();
    }

    private int findInterestingStart(JCTree tree) {
        int pos = (int)this.positions.getStartPosition(this.unit, tree);
        if (pos <= 0) {
            return 0;
        }
        this.seq.move(pos);
        block4: while (this.seq.movePrevious() && this.tokenIndexAlreadyAdded < this.seq.index()) {
            switch ((JavaTokenId)this.seq.token().id()) {
                case WHITESPACE: 
                case LINE_COMMENT: 
                case JAVADOC_COMMENT: 
                case BLOCK_COMMENT: {
                    continue block4;
                }
                case LBRACE: {
                    return this.seq.offset() + this.seq.token().length();
                }
            }
            return this.seq.offset() + this.seq.token().length();
        }
        return this.seq.offset();
    }

    private void consumeWS(TokenSequence<JavaTokenId> seq, boolean forward) {
        block3: while (forward ? seq.moveNext() : seq.movePrevious()) {
            switch ((JavaTokenId)seq.token().id()) {
                case WHITESPACE: {
                    continue block3;
                }
            }
            return;
        }
    }

    private int adjustByComments(int pos, CommentSetImpl comments) {
        List<Comment> cl = comments.getComments(CommentSet.RelativePosition.INLINE);
        if (!cl.isEmpty()) {
            for (Comment comment : cl) {
                pos = Math.max(pos, comment.endPos());
            }
        }
        if (!(cl = comments.getComments(CommentSet.RelativePosition.TRAILING)).isEmpty()) {
            for (Comment comment : cl) {
                pos = Math.max(pos, comment.endPos());
            }
        }
        return pos;
    }

    private void skipEvil(TokenSequence<JavaTokenId> ts) {
        do {
            JavaTokenId id = (JavaTokenId)ts.token().id();
            switch (id) {
                case WHITESPACE: 
                case PUBLIC: 
                case PRIVATE: 
                case PROTECTED: 
                case ABSTRACT: 
                case FINAL: 
                case STATIC: 
                case VOID: 
                case VOLATILE: 
                case NATIVE: 
                case STRICTFP: 
                case INT: 
                case BOOLEAN: 
                case DOUBLE: 
                case FLOAT: 
                case BYTE: 
                case CHAR: 
                case SHORT: 
                case CONST: 
                case LONG: {
                    break;
                }
                default: {
                    return;
                }
            }
        } while (ts.moveNext());
    }

    private double belongsTo(int startPos, int endPos, TokenSequence<JavaTokenId> ts) {
        int index = ts.index();
        double result = this.getForwardWeight(endPos, ts) - this.getBackwardWeight(startPos, ts);
        ts.moveIndex(index);
        ts.moveNext();
        return result;
    }

    private double getForwardWeight(int endPos, TokenSequence<JavaTokenId> ts) {
        double result = 0.0;
        ts.move(endPos);
        while (ts.moveNext()) {
            if (ts.token().id() == JavaTokenId.WHITESPACE) {
                int nls = this.numberOfNL((Token<JavaTokenId>)ts.token());
                result = nls == 0 ? 1.0 : (double)(1 / nls);
                continue;
            }
            if (!this.isComment((JavaTokenId)ts.token().id())) break;
            if (ts.token().id() == JavaTokenId.LINE_COMMENT) {
                return 1.0;
            }
            result = 0.0;
            break;
        }
        return result;
    }

    private double getBackwardWeight(int startPos, TokenSequence<JavaTokenId> ts) {
        double result = 0.0;
        ts.move(startPos);
        while (ts.movePrevious()) {
            if (ts.token().id() == JavaTokenId.WHITESPACE) {
                int nls = this.numberOfNL((Token<JavaTokenId>)ts.token());
                result = nls == 0 ? 0.0 : (double)(1 / nls);
                continue;
            }
            if (!this.isComment((JavaTokenId)ts.token().id())) break;
            result = 0.0;
            break;
        }
        return result;
    }

    private void attachComments(Iterable<? extends Token<JavaTokenId>> foundComments, Tree tree, CommentHandler ch, CommentSet.RelativePosition positioning) {
        if (foundComments == null || !foundComments.iterator().hasNext()) {
            return;
        }
        CommentSet set = this.createCommentSet(ch, tree);
        for (Token<JavaTokenId> token : foundComments) {
            this.attachComment(positioning, set, token);
        }
    }

    private void attachComment(CommentSet.RelativePosition positioning, CommentSet set, Token<JavaTokenId> comment) {
        Comment c = Comment.create(this.getStyle((JavaTokenId)comment.id()), comment.offset(null), this.getEndPos(comment), -2, this.getText(comment));
        set.addComment(positioning, c);
    }

    private String getText(Token<JavaTokenId> comment) {
        return String.valueOf(comment.text());
    }

    private int getEndPos(Token<JavaTokenId> comment) {
        return comment.offset(null) + comment.length();
    }

    private Comment.Style getStyle(JavaTokenId id) {
        switch (id) {
            case JAVADOC_COMMENT: {
                return Comment.Style.JAVADOC;
            }
            case LINE_COMMENT: {
                return Comment.Style.LINE;
            }
            case BLOCK_COMMENT: {
                return Comment.Style.BLOCK;
            }
        }
        return Comment.Style.WHITESPACE;
    }

    private int[] getBounds(JCTree tree) {
        return new int[]{(int)this.positions.getStartPosition(this.unit, tree), (int)this.positions.getEndPosition(this.unit, tree)};
    }

    private Tree getTree(TreeUtilities tu, TokenSequence<JavaTokenId> ts) {
        TreePath path;
        int start = ts.offset();
        if (ts.token().length() > 0) {
            ++start;
        }
        if ((path = tu.pathFor(start)) != null) {
            return path.getLeaf();
        }
        return null;
    }

    private int numberOfNL(Token<JavaTokenId> t) {
        int count = 0;
        CharSequence charSequence = t.text();
        for (int i = 0; i < charSequence.length(); ++i) {
            char a = charSequence.charAt(i);
            if ('\n' != a) continue;
            ++count;
        }
        return count;
    }

    private CommentsCollection getCommentsCollection(TokenSequence<JavaTokenId> ts, int maxTension) {
        CommentsCollection result = new CommentsCollection();
        Token t = ts.token();
        result.add((Token<JavaTokenId>)t);
        boolean isLC = t.id() == JavaTokenId.LINE_COMMENT;
        int lastCommentIndex = ts.index();
        int start = ts.offset();
        int end = ts.offset() + ts.token().length();
        while (ts.moveNext()) {
            if (ts.index() < this.tokenIndexAlreadyAdded) continue;
            t = ts.token();
            if (this.isComment((JavaTokenId)t.id())) {
                result.add((Token<JavaTokenId>)t);
                start = Math.min(ts.offset(), start);
                end = Math.max(ts.offset() + t.length(), end);
                isLC = t.id() == JavaTokenId.LINE_COMMENT;
                lastCommentIndex = ts.index();
                continue;
            }
            if (t.id() == JavaTokenId.WHITESPACE && this.numberOfNL((Token<JavaTokenId>)t) + (isLC ? 1 : 0) <= maxTension) continue;
        }
        ts.moveIndex(lastCommentIndex);
        ts.moveNext();
        this.tokenIndexAlreadyAdded = ts.index();
        result.setBounds(new int[]{start, end});
        return result;
    }

    private CommentSet createCommentSet(CommentHandler ch, Tree lastTree) {
        return ch.getComments(lastTree);
    }

    private boolean isComment(JavaTokenId tid) {
        switch (tid) {
            case LINE_COMMENT: 
            case JAVADOC_COMMENT: 
            case BLOCK_COMMENT: {
                return true;
            }
        }
        return false;
    }

    private static class CommentsCollection
    implements Iterable<Token<JavaTokenId>> {
        private final int[] bounds = new int[]{-2, -2};
        private final List<Token<JavaTokenId>> comments = new LinkedList<Token<JavaTokenId>>();

        private CommentsCollection() {
        }

        void add(Token<JavaTokenId> comment) {
            this.comments.add(comment);
        }

        boolean isEmpty() {
            return this.comments.isEmpty();
        }

        @Override
        public Iterator<Token<JavaTokenId>> iterator() {
            return this.comments.iterator();
        }

        void setBounds(int[] bounds) {
            this.bounds[0] = bounds[0];
            this.bounds[1] = bounds[1];
        }

        public int[] getBounds() {
            return (int[])this.bounds.clone();
        }

        public void merge(CommentsCollection cc) {
            this.comments.addAll(cc.comments);
            this.bounds[0] = Math.min(this.bounds[0], cc.bounds[0]);
            this.bounds[1] = Math.max(this.bounds[1], cc.bounds[1]);
        }
    }

    private static final class TrailingCommentsDataHolder {
        private final int newlines;
        private final Token<JavaTokenId> comment;
        private final int index;

        public TrailingCommentsDataHolder(int newlines, Token<JavaTokenId> comment, int index) {
            this.newlines = newlines;
            this.comment = comment;
            this.index = index;
        }
    }
}

