/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.debugging;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JToggleButton;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.actions.Presenter;

public final class FiltersDescriptor {
    public static final String SUSPEND_SORT = "suspend_sort";
    public static final String NATURAL_SORT = "natural_sort";
    public static final String ALPHABETIC_SORT = "alphabetic_sort";
    public static final String SHOW_QUALIFIED_NAMES = "show_fqn";
    public static final String SHOW_MONITORS = "show_monitors";
    public static final String SHOW_SYSTEM_THREADS = "show_system_threads";
    public static final String SHOW_SUSPEND_TABLE = "show_suspend_table";
    public static final String SHOW_THREAD_GROUPS = "thread_group";
    public static final String SHOW_SUSPENDED_THREADS_ONLY = "suspended_threads_only";
    private static FiltersDescriptor instance;
    private List<Item> filters = new ArrayList<Item>();
    private Action[] filterActions;

    private FiltersDescriptor() {
    }

    public static synchronized FiltersDescriptor getInstance() {
        if (instance == null) {
            instance = FiltersDescriptor.createDebuggingViewFilters();
        }
        return instance;
    }

    public synchronized Action[] getFilterActions() {
        if (this.filterActions == null) {
            ArrayList<SortAction> list = new ArrayList<SortAction>();
            for (Item item : this.filters) {
                if (item.getGroup() == null) continue;
                SortAction action = new SortAction(item);
                list.add(action);
            }
            int size = list.size();
            this.filterActions = new Action[size + 2];
            for (int x = 0; x < size; ++x) {
                this.filterActions[x] = (Action)list.get(x);
            }
            this.filterActions[size] = null;
            this.filterActions[size + 1] = new FilterSubmenuAction(this);
        }
        return this.filterActions;
    }

    public int getFilterCount() {
        return this.filters.size();
    }

    public String getName(int index) {
        return this.filters.get((int)index).name;
    }

    public String getDisplayName(int index) {
        return this.filters.get((int)index).displayName;
    }

    public String getTooltip(int index) {
        return this.filters.get((int)index).tooltip;
    }

    public Icon getSelectedIcon(int index) {
        return this.filters.get((int)index).selectedIcon;
    }

    public boolean isSelected(int index) {
        return this.filters.get(index).isSelected;
    }

    public void setSelected(int index, boolean selected) {
        this.filters.get(index).setSelected(selected);
    }

    public void setSelected(String filterName, boolean selected) {
        for (Item item : this.filters) {
            if (!item.getName().equals(filterName)) continue;
            item.setSelected(selected);
            break;
        }
    }

    public void connectToggleButton(int index, JToggleButton button) {
        this.filters.get(index).setToggleButton(button);
    }

    private static FiltersDescriptor createDebuggingViewFilters() {
        FiltersDescriptor desc = new FiltersDescriptor();
        desc.addItem(new Item(SHOW_SUSPENDED_THREADS_ONLY, FiltersDescriptor.getString("LBL_SUPSENDED_THREADS_ONLY"), FiltersDescriptor.getString("LBL_SUPSENDED_THREADS_ONLY_TIP"), false, FiltersDescriptor.loadIcon("show_suspended_threads_option_16.png")));
        desc.addItem(new Item(SHOW_THREAD_GROUPS, FiltersDescriptor.getString("LBL_THREAD_GROUPS"), FiltersDescriptor.getString("LBL_THREAD_GROUPS_TIP"), false, FiltersDescriptor.loadIcon("thread_group_mixed_16.png")));
        desc.addItem(new Item(SHOW_SUSPEND_TABLE, FiltersDescriptor.getString("LBL_SUSPEND_TABLE"), FiltersDescriptor.getString("LBL_SUSPEND_TABLE_TIP"), false, FiltersDescriptor.loadIcon("show_suspend_table_option_16.png")));
        desc.addItem(new Item(SHOW_SYSTEM_THREADS, FiltersDescriptor.getString("LBL_SYSTEM_THREADS"), FiltersDescriptor.getString("LBL_SYSTEM_THREADS_TIP"), false, FiltersDescriptor.loadIcon("show_system_threads_option_16.png")));
        desc.addItem(new Item(SHOW_MONITORS, FiltersDescriptor.getString("LBL_MONITORS"), FiltersDescriptor.getString("LBL_MONITORS_TIP"), false, FiltersDescriptor.loadIcon("monitor_acquired_16.png")));
        desc.addItem(new Item(SHOW_QUALIFIED_NAMES, FiltersDescriptor.getString("LBL_QUALIFIED_NAMES"), FiltersDescriptor.getString("LBL_QUALIFIED_NAMES_TIP"), false, FiltersDescriptor.loadIcon("show_fqn_option_16.png")));
        ArrayList<Item> groupMembers = new ArrayList<Item>();
        Group group = new Group();
        Item item = new Item(SUSPEND_SORT, FiltersDescriptor.getString("LBL_SUSPEND_SORT"), FiltersDescriptor.getString("LBL_SUSPEND_SORT_TIP"), false, FiltersDescriptor.loadIcon("suspend_property_sort_order_16.png"));
        groupMembers.add(item);
        desc.addItem(item);
        item.setGroup(group);
        item = new Item(ALPHABETIC_SORT, FiltersDescriptor.getString("LBL_ALPHABETIC_SORT"), FiltersDescriptor.getString("LBL_ALPHABETIC_SORT_TIP"), false, FiltersDescriptor.loadIcon("alphabetic_sort_order_16.png"));
        groupMembers.add(item);
        desc.addItem(item);
        item.setGroup(group);
        item = new Item(NATURAL_SORT, FiltersDescriptor.getString("LBL_NATURAL_SORT"), FiltersDescriptor.getString("LBL_NATURAL_SORT_TIP"), true, FiltersDescriptor.loadIcon("natural_sort_order_16.png"));
        groupMembers.add(item);
        desc.addItem(item);
        item.setGroup(group);
        group.setItems(groupMembers);
        return desc;
    }

    private void addItem(Item newItem) {
        this.filters.add(newItem);
    }

    private static Icon loadIcon(String iconName) {
        return ImageUtilities.loadImageIcon((String)("org/netbeans/modules/debugger/jpda/resources/" + iconName), (boolean)false);
    }

    private static String getString(String label) {
        return NbBundle.getMessage(FiltersDescriptor.class, (String)label);
    }

    static final class FilterSubmenuAction
    extends AbstractAction
    implements Presenter.Popup {
        private static final String PROP_FILTER_NAME = "nbFilterName";
        private FiltersDescriptor filtersDesc;

        public FilterSubmenuAction(FiltersDescriptor filters) {
            this.filtersDesc = filters;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            Object source = ev.getSource();
            if (source instanceof JCheckBoxMenuItem) {
                JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)source;
                String filterName = (String)menuItem.getClientProperty(PROP_FILTER_NAME);
                this.filtersDesc.setSelected(filterName, menuItem.isSelected());
            }
        }

        public final JMenuItem getPopupPresenter() {
            return this.createSubmenu();
        }

        private JMenuItem createSubmenu() {
            JMenu menu = new JMenu(NbBundle.getMessage(FiltersDescriptor.class, (String)"LBL_FilterSubmenu"));
            for (Item item : this.filtersDesc.filters) {
                if (item.getGroup() != null) continue;
                String filterName = item.getName();
                JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(item.getDisplayName(), item.isSelected());
                menuItem.addActionListener(this);
                menuItem.putClientProperty(PROP_FILTER_NAME, filterName);
                ((Container)menu).add(menuItem);
            }
            return menu;
        }
    }

    private static final class SortAction
    extends AbstractAction
    implements Presenter.Popup {
        private Item filterItem;

        SortAction(Item item) {
            this.filterItem = item;
            this.putValue("Name", item.getDisplayName());
            this.putValue("SmallIcon", item.getIcon());
        }

        public final JMenuItem getPopupPresenter() {
            JRadioButtonMenuItem result = this.obtainMenuItem();
            return result;
        }

        protected final JRadioButtonMenuItem obtainMenuItem() {
            JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem((String)this.getValue("Name"));
            menuItem.setAction(this);
            menuItem.addHierarchyListener(new ParentChangeListener(menuItem));
            menuItem.setSelected(this.filterItem.isSelected);
            return menuItem;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.filterItem.setSelected(!this.filterItem.isSelected);
        }

        private class ParentChangeListener
        implements HierarchyListener {
            private JRadioButtonMenuItem menuItem;

            public ParentChangeListener(JRadioButtonMenuItem menuItem) {
                this.menuItem = menuItem;
            }

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                JComponent parent = (JComponent)e.getChangedParent();
                if (parent == null) {
                    return;
                }
                ButtonGroup group = (ButtonGroup)parent.getClientProperty(this.getClass().getName() + " buttonGroup");
                if (group == null) {
                    group = new ButtonGroup();
                }
                group.add(this.menuItem);
                this.menuItem.removeHierarchyListener(this);
            }
        }
    }

    static class Group {
        List<Item> items = Collections.EMPTY_LIST;

        Group() {
        }

        public void setItems(List<Item> items) {
            this.items = items;
            for (Item item : items) {
                item.setGroup(this);
            }
        }

        public List<Item> getItems() {
            return this.items;
        }
    }

    static class Item {
        String name;
        String displayName;
        String tooltip;
        Icon selectedIcon;
        private boolean isSelected;
        private Group group;
        private JToggleButton toggleButton;

        Item(String name, String displayName, String tooltip, boolean isSelected, Icon selectedIcon) {
            this.name = name;
            this.displayName = displayName;
            this.tooltip = tooltip;
            this.selectedIcon = selectedIcon;
            this.isSelected = isSelected;
            this.readValue();
        }

        private Group getGroup() {
            return this.group;
        }

        public void setGroup(Group group) {
            this.group = group;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Icon getIcon() {
            return this.selectedIcon;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setSelected(boolean state) {
            if (this.isSelected == state) {
                return;
            }
            this.isSelected = state;
            this.toggleButton.setSelected(state);
            if (state && this.group != null) {
                for (Item item : this.group.getItems()) {
                    if (item == this || !item.isSelected()) continue;
                    JToggleButton tb = item.getToggleButton();
                    item.isSelected = false;
                    item.writeValue();
                    tb.setSelected(false);
                }
            }
            this.writeValue();
        }

        public JToggleButton getToggleButton() {
            return this.toggleButton;
        }

        public void setToggleButton(JToggleButton button) {
            this.toggleButton = button;
        }

        private void readValue() {
            Preferences preferences = NbPreferences.forModule(this.getClass()).node("debugging");
            this.isSelected = this.name.equals(FiltersDescriptor.SHOW_SYSTEM_THREADS) ? preferences.getBoolean("show.systemThreads", false) : (this.name.equals(FiltersDescriptor.SHOW_THREAD_GROUPS) ? preferences.getBoolean("show.threadGroups", false) : (this.name.equals(FiltersDescriptor.ALPHABETIC_SORT) ? preferences.getBoolean("sort.alphabet", true) : (this.name.equals(FiltersDescriptor.SUSPEND_SORT) ? preferences.getBoolean("sort.suspend", false) : (this.name.equals(FiltersDescriptor.SHOW_SUSPENDED_THREADS_ONLY) ? preferences.getBoolean("show.suspendedThreadsOnly", false) : (this.name.equals(FiltersDescriptor.NATURAL_SORT) ? !preferences.getBoolean("sort.alphabet", true) && !preferences.getBoolean("sort.suspend", false) : (this.name.equals(FiltersDescriptor.SHOW_MONITORS) ? preferences.getBoolean("show.monitors", false) : (this.name.equals(FiltersDescriptor.SHOW_QUALIFIED_NAMES) ? preferences.getBoolean("show.packageNames", false) : (this.name.equals(FiltersDescriptor.SHOW_SUSPEND_TABLE) ? preferences.getBoolean(FiltersDescriptor.SHOW_SUSPEND_TABLE, true) : false))))))));
        }

        private void writeValue() {
            String keyName = null;
            Preferences preferences = NbPreferences.forModule(this.getClass()).node("debugging");
            if (this.name.equals(FiltersDescriptor.SHOW_SYSTEM_THREADS)) {
                keyName = "show.systemThreads";
            } else if (this.name.equals(FiltersDescriptor.SHOW_THREAD_GROUPS)) {
                keyName = "show.threadGroups";
            } else if (this.name.equals(FiltersDescriptor.SHOW_SUSPENDED_THREADS_ONLY)) {
                keyName = "show.suspendedThreadsOnly";
            } else if (this.name.equals(FiltersDescriptor.ALPHABETIC_SORT)) {
                keyName = "sort.alphabet";
            } else if (this.name.equals(FiltersDescriptor.SUSPEND_SORT)) {
                keyName = "sort.suspend";
            } else if (this.name.equals(FiltersDescriptor.SHOW_MONITORS)) {
                keyName = "show.monitors";
            } else if (this.name.equals(FiltersDescriptor.SHOW_QUALIFIED_NAMES)) {
                keyName = "show.packageNames";
            } else if (this.name.equals(FiltersDescriptor.SHOW_SUSPEND_TABLE)) {
                keyName = FiltersDescriptor.SHOW_SUSPEND_TABLE;
            }
            if (keyName != null) {
                preferences.putBoolean(keyName, this.isSelected);
            }
        }
    }
}

