/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.netbeans.modules.search.BasicSearchCriteria;
import org.netbeans.modules.search.SearchScope;
import org.netbeans.modules.search.SearchTask;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openidex.search.DataObjectSearchGroup;
import org.openidex.search.SearchInfo;
import org.openidex.search.SearchType;

final class SpecialSearchGroup
extends DataObjectSearchGroup {
    final BasicSearchCriteria basicCriteria;
    final boolean hasExtraSearchTypes;
    private final SearchScope searchScope;
    private SearchTask listeningSearchTask;
    private LinkedList searchItems;

    SpecialSearchGroup(BasicSearchCriteria basicCriteria, Collection<SearchType> extraSearchTypes, SearchScope searchScope) {
        this.basicCriteria = basicCriteria;
        this.hasExtraSearchTypes = !extraSearchTypes.isEmpty();
        this.searchScope = searchScope;
        if (basicCriteria == null && !this.hasExtraSearchTypes) {
            assert (false);
            throw new IllegalArgumentException();
        }
        if (this.hasExtraSearchTypes) {
            for (SearchType searchType : extraSearchTypes) {
                this.add(searchType);
            }
        }
    }

    protected void prepareSearch() {
        this.searchItems = new LinkedList();
        SearchInfo sInfo = this.searchScope.getSearchInfo();
        if (sInfo instanceof SearchInfo.Files) {
            Iterator j = ((SearchInfo.Files)sInfo).filesToSearch();
            while (j.hasNext()) {
                if (this.stopped) {
                    return;
                }
                this.searchItems.add(j.next());
            }
        } else {
            Iterator j = sInfo.objectsToSearch();
            while (j.hasNext()) {
                if (this.stopped) {
                    return;
                }
                this.searchItems.add(j.next());
            }
        }
    }

    public void doSearch() {
        this.notifyStarted(this.searchItems.size());
        int index = 0;
        while (!this.searchItems.isEmpty()) {
            if (this.stopped) {
                return;
            }
            this.processSearchObject(this.searchItems.poll());
            this.notifyProgress(index++);
        }
    }

    protected void processSearchObject(Object searchObject) {
        if (!this.hasExtraSearchTypes) {
            FileObject fileObj;
            assert (this.basicCriteria != null);
            if (searchObject instanceof DataObject) {
                DataObject dataObj = (DataObject)searchObject;
                if (this.basicCriteria.matches(dataObj)) {
                    this.notifyMatchingObjectFound(dataObj);
                }
            } else if (searchObject instanceof FileObject && this.basicCriteria.matches(fileObj = (FileObject)searchObject)) {
                try {
                    this.notifyMatchingObjectFound(DataObject.find((FileObject)fileObj));
                }
                catch (DataObjectNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return;
        }
        if (this.basicCriteria == null || this.basicCriteria.matches((DataObject)searchObject)) {
            super.processSearchObject(searchObject);
        }
    }

    protected void firePropertyChange(String name, Object oldValue, Object newValue) {
        this.notifyMatchingObjectFound((DataObject)newValue);
    }

    private void notifyMatchingObjectFound(DataObject obj) {
        if (this.listeningSearchTask != null) {
            Charset charset = this.basicCriteria != null ? this.basicCriteria.getLastUsedCharset() : null;
            this.listeningSearchTask.matchingObjectFound(obj, charset);
        }
    }

    private void notifyStarted(int unitsCount) {
        if (this.listeningSearchTask != null) {
            this.listeningSearchTask.searchStarted(unitsCount);
        }
    }

    private void notifyProgress(int progress) {
        if (this.listeningSearchTask != null) {
            this.listeningSearchTask.progress(progress);
        }
    }

    void setListeningSearchTask(SearchTask searchTask) {
        this.listeningSearchTask = searchTask;
    }

    SearchScope getSearchScope() {
        return this.searchScope;
    }
}

