/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.TreePath;
import org.netbeans.modules.search.BasicSearchCriteria;
import org.netbeans.modules.search.ContextView;
import org.netbeans.modules.search.IssuesPanel;
import org.netbeans.modules.search.Manager;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.NodeListener;
import org.netbeans.modules.search.NodeRenderer;
import org.netbeans.modules.search.PrintDetailsTask;
import org.netbeans.modules.search.ReplaceTask;
import org.netbeans.modules.search.ResultModel;
import org.netbeans.modules.search.ResultTreeModel;
import org.netbeans.modules.search.ResultView;
import org.netbeans.modules.search.SearchPanel;
import org.netbeans.modules.search.SearchScope;
import org.netbeans.modules.search.SearchScopeRegistry;
import org.netbeans.modules.search.SearchTask;
import org.netbeans.modules.search.TextDetail;
import org.netbeans.modules.search.Utils;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openidex.search.SearchType;

class ResultViewPanel
extends JPanel {
    private static final String CONTEXT_ICON = "org/netbeans/modules/search/res/context.gif";
    private static final String REPLACE_ICON = "org/netbeans/modules/search/res/replaceChecked.gif";
    private static final String CUSTOMIZER_ICON = "org/netbeans/modules/search/res/customizeReport.png";
    private static final String STOP_ICON = "org/netbeans/modules/search/res/stop.png";
    private static final String SEARCH_ICON = "org/netbeans/modules/search/res/search.gif";
    private static final String PREV_ICON = "org/netbeans/modules/search/res/prev.png";
    private static final String NEXT_ICON = "org/netbeans/modules/search/res/next.png";
    private static final boolean isMacLaf = "Aqua".equals(UIManager.getLookAndFeel().getID());
    private static final Color macBackground = UIManager.getColor("NbExplorerView.background");
    private static final boolean SHOW_CONTEXT_BY_DEFAULT = true;
    private boolean contextViewEnabled = true;
    private boolean ignoreContextButtonToggle = false;
    private boolean hasResults = false;
    private ResultTreeModel treeModel = null;
    final JTree tree;
    private final NodeListener nodeListener;
    private ResultModel resultModel = null;
    private BasicSearchCriteria basicSearchCriteria;
    private List<SearchType> searchTypes;
    private double dividerLocation = -1.0;
    private String searchScopeType;
    private MessageFormat nodeCountFormat;
    private MessageFormat nodeCountFormatFullText;
    private IssuesPanel issuesPanel;
    private final JScrollPane treeView;
    private final CardLayout resultViewCards;
    private JSplitPane splitPane;
    private final JPanel resultsPanel;
    private final JToolBar toolBar;
    private JSeparator toolbarSeparator;
    private JButton btnShowDetails = new JButton();
    private JButton btnModifySearch = new JButton();
    private JButton btnStop = new JButton();
    private JButton btnReplace = new JButton();
    private JButton btnPrev;
    private JButton btnNext;
    private JToggleButton btnDisplayContext = new JToggleButton();
    private JToolBar.Separator sepDisplayContext;
    private boolean contextViewVisible = false;
    private volatile boolean hasDetails = false;
    private volatile boolean searchInProgress = false;
    private final ArrowStatusUpdater arrowUpdater;
    private ContextView contextView;
    private int objectsCount = 0;
    private SearchTask task;
    private MatchingObject matchingObjIndexCacheObj = null;
    private int matchingObjIndexCacheIndex = -1;

    public ResultViewPanel(SearchTask task) {
        this.setLayout(new GridBagLayout());
        this.arrowUpdater = new ArrowStatusUpdater(this);
        this.task = task;
        this.treeModel = this.createTreeModel();
        this.nodeListener = new NodeListener();
        this.tree = this.createTree(this.treeModel, this.nodeListener, this.arrowUpdater);
        this.treeView = new JScrollPane(this.tree);
        this.treeView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ResultView.class, (String)"ACS_TREEVIEW"));
        this.treeView.setBorder(BorderFactory.createEmptyBorder());
        this.resultViewCards = new CardLayout();
        this.resultsPanel = new JPanel(this.resultViewCards);
        this.toolBar = new JToolBar(1);
        this.btnDisplayContext.setIcon(ImageUtilities.loadImageIcon((String)CONTEXT_ICON, (boolean)true));
        this.btnDisplayContext.setToolTipText(NbBundle.getMessage(this.getClass(), (String)"TOOLTIP_ShowContext"));
        this.btnDisplayContext.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(this.getClass(), (String)"ACSD_ShowContext"));
        this.btnDisplayContext.setSelected(true);
        this.btnPrev = new JButton();
        this.btnPrev.setIcon(ImageUtilities.loadImageIcon((String)PREV_ICON, (boolean)true));
        this.btnPrev.setToolTipText(NbBundle.getMessage(this.getClass(), (String)"TEXT_BUTTON_PREV_MATCH"));
        this.btnNext = new JButton();
        this.btnNext.setIcon(ImageUtilities.loadImageIcon((String)NEXT_ICON, (boolean)true));
        this.btnNext.setToolTipText(NbBundle.getMessage(this.getClass(), (String)"TEXT_BUTTON_NEXT_MATCH"));
        this.toolBar.add(this.btnDisplayContext);
        this.sepDisplayContext = new JToolBar.Separator();
        this.toolBar.add(this.sepDisplayContext);
        this.toolBar.add(this.btnPrev);
        this.toolBar.add(this.btnNext);
        this.toolBar.setRollover(true);
        this.toolBar.setFloatable(false);
        this.btnPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultViewPanel.this.goToNext(false);
            }
        });
        this.btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultViewPanel.this.goToNext(true);
            }
        });
        this.btnDisplayContext.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!ResultViewPanel.this.ignoreContextButtonToggle) {
                    ResultViewPanel.this.contextViewEnabled = e.getStateChange() == 1;
                    ResultViewPanel.this.updateContextViewVisibility();
                }
            }
        });
        this.toolbarSeparator = new JSeparator();
        this.toolbarSeparator.setOrientation(1);
        this.btnShowDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultViewPanel.this.fillOutput();
            }
        });
        this.btnModifySearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultViewPanel.this.customizeCriteria();
            }
        });
        this.btnStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Manager.getInstance().stopSearching(ResultViewPanel.this.getTask());
            }
        });
        this.btnReplace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultViewPanel.this.replaceMatches();
            }
        });
        this.btnStop.setToolTipText(NbBundle.getMessage(ResultView.class, (String)"TEXT_BUTTON_STOP"));
        this.btnShowDetails.setToolTipText(NbBundle.getMessage(ResultView.class, (String)"TEXT_BUTTON_FILL"));
        this.btnReplace.setToolTipText(NbBundle.getMessage(ResultView.class, (String)"TEXT_BUTTON_REPLACE"));
        this.btnModifySearch.setToolTipText(NbBundle.getMessage(ResultView.class, (String)"TEXT_BUTTON_CUSTOMIZE"));
        this.btnModifySearch.setIcon(ImageUtilities.loadImageIcon((String)CUSTOMIZER_ICON, (boolean)true));
        this.btnStop.setIcon(ImageUtilities.loadImageIcon((String)STOP_ICON, (boolean)true));
        this.btnShowDetails.setIcon(ImageUtilities.loadImageIcon((String)SEARCH_ICON, (boolean)true));
        this.btnReplace.setIcon(ImageUtilities.loadImageIcon((String)REPLACE_ICON, (boolean)true));
        this.btnStop.setEnabled(false);
        this.btnShowDetails.setEnabled(false);
        this.btnReplace.setVisible(false);
        this.toolBar.add(new JToolBar.Separator());
        this.toolBar.add(this.btnReplace);
        this.toolBar.add(Box.createHorizontalGlue());
        this.toolBar.add(this.btnShowDetails);
        this.toolBar.add(this.btnModifySearch);
        this.toolBar.add(this.btnStop);
        this.add((Component)this.toolBar, this.getToolbarConstraints());
        this.add((Component)this.toolbarSeparator, this.getToolbarSeparatorConstraints());
        this.add((Component)this.resultsPanel, this.getMainPanelConstraints());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
        this.initAccessibility();
        this.resultModelChanged();
        if (isMacLaf) {
            this.tree.setBackground(macBackground);
            this.treeView.setBackground(macBackground);
            this.toolBar.setBackground(macBackground);
            this.resultsPanel.setBackground(macBackground);
        }
    }

    ResultModel getResultModel() {
        return this.resultModel;
    }

    void setResultModel(ResultModel resultModel) {
        boolean hadCheckBoxes = this.resultModel != null && this.resultModel.searchAndReplace;
        boolean hasCheckBoxes = resultModel != null && resultModel.searchAndReplace;
        this.resultModel = resultModel;
        this.basicSearchCriteria = resultModel.basicCriteria;
        this.searchTypes = Arrays.asList(resultModel.getSearchGroup().getSearchTypes());
        this.searchScopeType = resultModel.getSearchGroup().getSearchScope().getTypeId();
        this.treeModel = new ResultTreeModel(resultModel);
        this.tree.setModel(this.treeModel);
        if (hasCheckBoxes != hadCheckBoxes) {
            this.tree.setCellRenderer(new NodeRenderer(hasCheckBoxes));
            this.setBtnReplaceVisible(hasCheckBoxes);
        }
        if (resultModel != null) {
            this.hasResults = resultModel.size() != 0;
            this.hasDetails = this.hasResults && resultModel.hasDetails();
            resultModel.setObserver(this);
        } else {
            this.hasResults = false;
            this.hasDetails = false;
        }
        this.resultModelChanged();
    }

    private void initAccessibility() {
        ResourceBundle bundle = NbBundle.getBundle(ResultView.class);
        AccessibleContext accessCtx = this.treeView.getHorizontalScrollBar().getAccessibleContext();
        accessCtx.setAccessibleName(bundle.getString("ACSN_HorizontalScrollbar"));
        accessCtx = this.treeView.getVerticalScrollBar().getAccessibleContext();
        accessCtx.setAccessibleName(bundle.getString("ACSN_VerticalScrollbar"));
        accessCtx = this.treeView.getAccessibleContext();
        accessCtx.setAccessibleName(bundle.getString("ACSN_ResultTree"));
        accessCtx.setAccessibleDescription(bundle.getString("ACSD_ResultTree"));
        this.btnReplace.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_TEXT_BUTTON_REPLACE"));
        this.btnModifySearch.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_TEXT_BUTTON_CUSTOMIZE"));
        this.btnShowDetails.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_TEXT_BUTTON_FILL"));
        this.btnStop.getAccessibleContext().setAccessibleDescription(bundle.getString("ACS_TEXT_BUTTON_STOP"));
    }

    public void fillOutput() {
        this.btnShowDetails.setEnabled(false);
        Manager.getInstance().schedulePrintTask(new PrintDetailsTask(this.resultModel.getMatchingObjects(), this.basicSearchCriteria, this.searchTypes));
    }

    private synchronized void updateObjectsCount(int totalDetailsCount) {
        assert (EventQueue.isDispatchThread());
        if (this.resultModel == null) {
            return;
        }
        ++this.objectsCount;
        this.hasResults = true;
        this.setRootDisplayName(this.resultModel.isBasicCriteriaOnly && this.resultModel.basicCriteria.isFullText() ? this.nodeCountFormatFullText.format(new Object[]{new Integer(this.objectsCount), new Integer(totalDetailsCount)}) : this.nodeCountFormat.format(new Object[]{new Integer(this.objectsCount)}));
    }

    void objectFound(Object foundObject, final int totalDetailsCount) {
        assert (!EventQueue.isDispatchThread());
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ResultViewPanel.this.updateObjectsCount(totalDetailsCount);
            }
        });
    }

    void rememberInput(String searchScopeType, BasicSearchCriteria basicSearchCriteria, List<SearchType> searchTypes) {
        this.searchScopeType = searchScopeType;
        this.basicSearchCriteria = basicSearchCriteria;
        this.searchTypes = searchTypes;
    }

    void componentOpened() {
        if (this.searchScopeType == null) {
            this.setBtnModifyEnabled(false);
        }
    }

    void componentClosed() {
        this.rememberInput(null, null, null);
        if (this.contextView != null) {
            this.contextView.unbindFromTreeSelection(this.tree);
            this.contextView = null;
        }
        if (this.splitPane != null) {
            this.rememberDividerLocation();
            this.resultsPanel.remove(this.splitPane);
            this.splitPane = null;
        }
        this.contextViewVisible = false;
    }

    void resultModelChanged() {
        this.updateDisplayContextButton();
        this.updateContextViewVisibility();
        if (this.contextView != null) {
            this.contextView.setResultModel(this.resultModel);
        }
        this.nodeListener.setSelectionChangeEnabled(true);
        this.btnPrev.setEnabled(this.resultModel != null);
        this.btnNext.setEnabled(this.resultModel != null);
        this.resetMatchingObjIndexCache();
        this.objectsCount = 0;
    }

    private SearchTask getTask() {
        return this.task;
    }

    private void resetMatchingObjIndexCache() {
        this.matchingObjIndexCacheObj = null;
        this.matchingObjIndexCacheIndex = -1;
    }

    private ResultTreeModel createTreeModel() {
        ResultTreeModel newTreeModel = new ResultTreeModel(null);
        newTreeModel.setRootDisplayName(this.getInitialRootNodeText());
        return newTreeModel;
    }

    private JTree createTree(ResultTreeModel treeModel, NodeListener nodeListener, ArrowStatusUpdater arrowUpdater) {
        JTree newTree = new JTree(treeModel);
        NodeRenderer cellRenderer = new NodeRenderer(false);
        newTree.setCellRenderer(cellRenderer);
        newTree.setRowHeight(cellRenderer.getTreeCellRendererComponent((JTree)newTree, (Object)treeModel, (boolean)true, (boolean)true, (boolean)false, (int)0, (boolean)true).getPreferredSize().height + 2);
        newTree.putClientProperty("JTree.lineStyle", "Angled");
        newTree.addMouseListener(nodeListener);
        newTree.addKeyListener(nodeListener);
        newTree.addTreeWillExpandListener(nodeListener);
        newTree.addTreeExpansionListener(nodeListener);
        newTree.setToggleClickCount(0);
        newTree.addMouseListener(arrowUpdater);
        newTree.addKeyListener(arrowUpdater);
        return newTree;
    }

    private String getInitialRootNodeText() {
        return NbBundle.getMessage(ResultView.class, (String)"TEXT_Search_in_filesystems");
    }

    void setRootDisplayName(String displayName) {
        this.treeModel.setRootDisplayName(displayName);
    }

    private boolean isSearchAndReplace() {
        return this.resultModel != null && this.resultModel.searchAndReplace;
    }

    private void setFinalRootNodeText() {
        String baseMsg;
        assert (EventQueue.isDispatchThread());
        int resultSize = this.resultModel.size();
        if (this.resultModel.wasLimitReached()) {
            this.setRootDisplayName(NbBundle.getMessage(ResultView.class, (String)"TEXT_MSG_FOUND_X_NODES_LIMIT", (Object)resultSize, (Object)this.resultModel.getTotalDetailsCount()) + ' ' + this.resultModel.getLimitDisplayName());
            return;
        }
        if (resultSize == 0) {
            baseMsg = NbBundle.getMessage(ResultView.class, (String)"TEXT_MSG_NO_NODE_FOUND");
        } else {
            Object[] args;
            String bundleKey;
            if (this.resultModel.searchAndReplace) {
                bundleKey = "TEXT_MSG_FOUND_X_NODES_REPLACE";
                args = new Object[4];
            } else if (this.resultModel.isBasicCriteriaOnly && this.resultModel.basicCriteria.isFullText()) {
                bundleKey = "TEXT_MSG_FOUND_X_NODES_FULLTEXT";
                args = new Object[2];
            } else {
                bundleKey = "TEXT_MSG_FOUND_X_NODES";
                args = new Object[]{new Integer(this.objectsCount)};
            }
            if (args.length > 1) {
                args[1] = new Integer(this.resultModel.getTotalDetailsCount());
            }
            if (args.length > 2) {
                args[2] = this.resultModel.basicCriteria.getTextPatternExpr();
                args[3] = this.resultModel.basicCriteria.getReplaceExpr();
            }
            baseMsg = NbBundle.getMessage(this.getClass(), (String)bundleKey, (Object[])args);
        }
        String exMsg = this.resultModel.getExceptionMsg();
        String msg = exMsg == null ? baseMsg : baseMsg + " (" + exMsg + ")";
        this.setRootDisplayName(msg);
    }

    boolean isSearchInProgress() {
        return this.searchInProgress;
    }

    void updateShowAllDetailsBtn() {
        assert (EventQueue.isDispatchThread());
        if (this.hasResults && !this.searchInProgress) {
            this.tree.setSelectionPath(new TreePath(this.tree.getModel().getRoot()));
        }
        this.setBtnShowDetailsEnabled(this.hasResults && !this.searchInProgress && this.hasDetails);
    }

    void searchStarted() {
        this.setRootDisplayName(NbBundle.getMessage(ResultView.class, (String)"TEXT_SEARCHING___"));
        this.nodeCountFormat = new MessageFormat(NbBundle.getMessage(this.getClass(), (String)"TXT_RootSearchedNodes"));
        this.nodeCountFormatFullText = new MessageFormat(NbBundle.getMessage(this.getClass(), (String)"TXT_RootSearchedNodesFulltext"));
        this.searchInProgress = true;
        this.updateShowAllDetailsBtn();
        this.setBtnModifyEnabled(true);
        this.setBtnStopEnabled(true);
        this.setBtnReplaceEnabled(false);
        this.arrowUpdater.update();
    }

    void searchFinished() {
        this.setFinalRootNodeText();
        this.searchInProgress = false;
        this.hasDetails = this.resultModel != null ? this.resultModel.hasDetails() : false;
        this.updateShowAllDetailsBtn();
        this.setBtnStopEnabled(false);
        this.setBtnReplaceEnabled(true);
        this.arrowUpdater.update();
    }

    void searchInterrupted() {
        this.searchFinished();
    }

    void searchCancelled() {
        this.setRootDisplayName(NbBundle.getMessage(ResultView.class, (String)"TEXT_TASK_CANCELLED"));
        this.searchInProgress = true;
        this.updateShowAllDetailsBtn();
        this.setBtnStopEnabled(false);
        this.setBtnReplaceEnabled(true);
        this.arrowUpdater.update();
    }

    void displayIssues(IssuesPanel issuesPanel) {
        if (issuesPanel != null) {
            this.issuesPanel = issuesPanel;
            this.remove(this.toolBar);
            this.remove(this.toolbarSeparator);
            this.remove(this.resultsPanel);
            this.add((Component)issuesPanel, this.getMainPanelConstraints());
            this.validate();
            this.repaint();
        }
    }

    void removeIssuesPanel() {
        if (this.issuesPanel != null) {
            this.remove(this.issuesPanel);
            this.add((Component)this.toolBar, this.getToolbarConstraints());
            this.add((Component)this.toolbarSeparator, this.getToolbarSeparatorConstraints());
            this.add((Component)this.resultsPanel, this.getMainPanelConstraints());
            this.issuesPanel = null;
            this.validate();
            this.repaint();
        }
    }

    private GridBagConstraints getMainPanelConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        return gridBagConstraints;
    }

    private GridBagConstraints getToolbarConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        return gridBagConstraints;
    }

    private GridBagConstraints getToolbarSeparatorConstraints() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        return gridBagConstraints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDisplayContextButton() {
        boolean searchAndReplace = this.isSearchAndReplace();
        this.btnDisplayContext.setVisible(searchAndReplace);
        this.sepDisplayContext.setVisible(searchAndReplace);
        this.ignoreContextButtonToggle = true;
        try {
            this.btnDisplayContext.setSelected(searchAndReplace && this.contextViewEnabled);
        }
        finally {
            this.ignoreContextButtonToggle = false;
        }
    }

    private void updateContextViewVisibility() {
        this.setContextViewVisible(this.isSearchAndReplace() && this.contextViewEnabled);
    }

    private void setContextViewVisible(boolean visible) {
        String cardName;
        assert (EventQueue.isDispatchThread());
        assert (this.splitPane == null == (this.contextView == null));
        int componentCount = this.resultsPanel.getComponentCount();
        if (visible == this.contextViewVisible && componentCount != 0) {
            return;
        }
        this.contextViewVisible = visible;
        if (!visible) {
            cardName = "tree only";
            assert (componentCount < 2);
            this.resultsPanel.add((Component)this.treeView, cardName);
            if (this.contextView != null) {
                this.contextView.unbindFromTreeSelection(this.tree);
                this.rememberDividerLocation();
            }
        } else {
            assert (this.resultModel != null);
            cardName = "tree and context";
            if (this.splitPane == null) {
                this.contextView = new ContextView(this.resultModel);
                this.splitPane = new JSplitPane(1, true, this.treeView, this.contextView);
                this.splitPane.setBorder(BorderFactory.createEmptyBorder());
                this.splitPane.setResizeWeight(0.4);
                if (isMacLaf) {
                    this.contextView.setBackground(macBackground);
                    this.splitPane.setBackground(macBackground);
                }
                this.resultsPanel.add((Component)this.splitPane, cardName);
            } else {
                this.splitPane.setLeftComponent(this.treeView);
            }
            this.setDividerLocation();
            this.contextView.bindToTreeSelection(this.tree);
        }
        this.resultViewCards.show(this.resultsPanel, cardName);
        this.treeView.setVisible(true);
    }

    void goToNext(boolean forward) {
        TreePath nextPath;
        assert (EventQueue.isDispatchThread());
        assert (this.resultModel != null);
        if (!this.hasResults) {
            return;
        }
        TreePath leadPath = this.tree.getLeadSelectionPath();
        if (leadPath == null) {
            leadPath = new TreePath(this.tree.getModel().getRoot());
        }
        if ((nextPath = this.findNextPath(leadPath, forward)) != null) {
            this.tree.expandPath(nextPath.getParentPath());
            this.tree.setSelectionPath(nextPath);
            this.tree.scrollRectToVisible(this.tree.getPathBounds(nextPath));
            this.arrowUpdater.update();
            this.goToDetail(nextPath);
        }
    }

    private void goToDetail(TreePath treePath) {
        Object comp = treePath.getLastPathComponent();
        if (comp != null && comp instanceof TextDetail.DetailNode) {
            TextDetail.DetailNode nodeDetail = (TextDetail.DetailNode)((Object)comp);
            nodeDetail.gotoDetail();
        }
    }

    private TreePath findNextPath(TreePath forPath, boolean forward) {
        TreePath nextPath;
        TreePath parentPath = forPath.getParentPath();
        if (parentPath == null) {
            Object root = forPath.getLastPathComponent();
            nextPath = forward ? this.getNextDetail(root, null, -1, forward) : null;
        } else {
            Object lastComp = forPath.getLastPathComponent();
            if (lastComp.getClass() == MatchingObject.class) {
                Object root = parentPath.getLastPathComponent();
                MatchingObject matchingObj = (MatchingObject)lastComp;
                nextPath = this.getNextDetail(root, matchingObj, -1, forward);
            } else {
                Object root = parentPath.getParentPath().getLastPathComponent();
                Object parentComp = parentPath.getLastPathComponent();
                assert (parentComp.getClass() == MatchingObject.class);
                MatchingObject matchingObj = (MatchingObject)parentComp;
                int parentPathRow = this.tree.getRowForPath(parentPath);
                int row = this.tree.getRowForPath(forPath);
                int index = row - parentPathRow - 1;
                nextPath = this.getNextDetail(root, matchingObj, index, forward);
            }
        }
        return nextPath;
    }

    private TreePath getNextDetail(Object root, MatchingObject matchingObj, int detailIndex, boolean forward) {
        if (matchingObj != null) {
            int nextDetailIndex;
            int n = nextDetailIndex = forward ? detailIndex + 1 : detailIndex - 1;
            if (nextDetailIndex >= 0 && nextDetailIndex < this.resultModel.getDetailsCount(matchingObj)) {
                return new TreePath(new Object[]{root, matchingObj, this.resultModel.getDetails(matchingObj)[nextDetailIndex]});
            }
        } else if (!forward) {
            return null;
        }
        List<MatchingObject> matchingObjs = this.resultModel.getMatchingObjects();
        int currMatchingObjIndex = this.getMatchingObjIndex(matchingObjs, matchingObj, forward);
        MatchingObject nextMatchingObj = null;
        Node detail = null;
        if (forward) {
            for (int i = currMatchingObjIndex + 1; i < matchingObjs.size(); ++i) {
                nextMatchingObj = matchingObjs.get(i);
                Node[] details = this.resultModel.getDetails(nextMatchingObj);
                if (details == null) continue;
                detail = details[0];
                break;
            }
        } else {
            for (int i = currMatchingObjIndex - 1; i >= 0; --i) {
                nextMatchingObj = matchingObjs.get(i);
                Node[] details = this.resultModel.getDetails(nextMatchingObj);
                if (details == null) continue;
                detail = details[details.length - 1];
                break;
            }
        }
        return detail == null ? null : new TreePath(new Object[]{root, nextMatchingObj, detail});
    }

    private int getMatchingObjIndex(List<MatchingObject> matchingObjs, MatchingObject matchingObj, boolean forward) {
        if (matchingObj == null) {
            return -1;
        }
        if (matchingObj == this.matchingObjIndexCacheObj) {
            assert (this.matchingObjIndexCacheIndex != -1);
            return this.matchingObjIndexCacheIndex;
        }
        int foundIndex = -1;
        if (this.matchingObjIndexCacheIndex != -1) {
            int i;
            int endIndex;
            int startIndex;
            int quickSearchRange = 3;
            if (forward) {
                startIndex = Math.min(this.matchingObjIndexCacheIndex + 1, matchingObjs.size() - 1);
                endIndex = Math.min(this.matchingObjIndexCacheIndex + 3, matchingObjs.size() - 1);
                for (i = startIndex; i <= endIndex; ++i) {
                    if (matchingObjs.get(i) != matchingObj) continue;
                    foundIndex = i;
                    break;
                }
                if (foundIndex == -1 && this.matchingObjIndexCacheIndex > 0 && matchingObjs.get(i = this.matchingObjIndexCacheIndex - 1) == matchingObj) {
                    foundIndex = i;
                }
            } else {
                startIndex = Math.max(this.matchingObjIndexCacheIndex - 1, 0);
                endIndex = Math.max(this.matchingObjIndexCacheIndex - 3, 0);
                for (i = startIndex; i >= endIndex; --i) {
                    if (matchingObjs.get(i) != matchingObj) continue;
                    foundIndex = i;
                    break;
                }
                if (foundIndex == -1 && this.matchingObjIndexCacheIndex < matchingObjs.size() - 1 && matchingObjs.get(i = this.matchingObjIndexCacheIndex + 1) == matchingObj) {
                    foundIndex = i;
                }
            }
        }
        if (foundIndex == -1) {
            for (int i = 0; i < matchingObjs.size(); ++i) {
                if (matchingObj != matchingObjs.get(i)) continue;
                foundIndex = i;
                break;
            }
        }
        if (foundIndex != -1) {
            this.matchingObjIndexCacheObj = matchingObj;
            this.matchingObjIndexCacheIndex = foundIndex;
        }
        return foundIndex;
    }

    private static List<SearchType> cloneAvailableSearchTypes(List<SearchType> searchTypes) {
        Collection<? extends SearchType> availableSearchTypes = Utils.getSearchTypes();
        ArrayList<String> availableSearchTypeNames = new ArrayList<String>(availableSearchTypes.size());
        for (SearchType searchType : availableSearchTypes) {
            availableSearchTypeNames.add(searchType.getClass().getName());
        }
        if (availableSearchTypeNames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SearchType> clones = new ArrayList<SearchType>(searchTypes.size());
        for (SearchType searchType : searchTypes) {
            if (!availableSearchTypeNames.contains(searchType.getClass().getName())) continue;
            clones.add((SearchType)searchType.clone());
        }
        return clones;
    }

    private void customizeCriteria() {
        assert (EventQueue.isDispatchThread());
        BasicSearchCriteria basicSearchCriteriaClone = this.basicSearchCriteria != null ? new BasicSearchCriteria(this.basicSearchCriteria) : new BasicSearchCriteria();
        List<SearchType> extraSearchTypesClones = ResultViewPanel.cloneAvailableSearchTypes(this.searchTypes);
        SearchPanel searchPanel = new SearchPanel(SearchScopeRegistry.getDefault().getSearchScopes(), this.searchScopeType, basicSearchCriteriaClone, extraSearchTypesClones);
        searchPanel.showDialog();
        if (searchPanel.getReturnStatus() != 1) {
            return;
        }
        SearchScope searchScope = searchPanel.getSearchScope();
        this.searchScopeType = searchScope.getTypeId();
        this.basicSearchCriteria = searchPanel.getBasicSearchCriteria();
        this.searchTypes = searchPanel.getSearchTypes();
        Manager.getInstance().stopSearching(this.task);
        this.task = new SearchTask(searchScope, this.basicSearchCriteria, searchPanel.getCustomizedSearchTypes());
        ResultView.getInstance().addSearchPair(this, this.task);
        Manager.getInstance().scheduleSearchTask(this.task);
    }

    private void replaceMatches() {
        assert (EventQueue.isDispatchThread());
        this.nodeListener.setSelectionChangeEnabled(false);
        this.btnReplace.setEnabled(false);
        ReplaceTask taskReplace = new ReplaceTask(this.resultModel.getMatchingObjects());
        ResultView.getInstance().addReplacePair(taskReplace, this);
        Manager.getInstance().scheduleReplaceTask(taskReplace);
    }

    void setBtnModifyEnabled(boolean enabled) {
        this.btnModifySearch.setEnabled(enabled);
    }

    void setBtnStopEnabled(boolean enabled) {
        this.btnStop.setEnabled(enabled);
    }

    void setBtnReplaceEnabled(boolean enabled) {
        this.btnReplace.setEnabled(enabled && !this.basicSearchCriteria.isReplacePatternInvalid());
    }

    void setBtnShowDetailsEnabled(boolean enabled) {
        this.btnShowDetails.setEnabled(enabled);
    }

    void setBtnReplaceVisible(boolean visible) {
        this.btnReplace.setVisible(visible);
    }

    private void rememberDividerLocation() {
        if (this.splitPane == null) {
            return;
        }
        this.dividerLocation = (double)this.splitPane.getDividerLocation() / (double)(this.splitPane.getWidth() - this.splitPane.getDividerSize());
    }

    private void setDividerLocation() {
        assert (this.splitPane != null);
        if (this.dividerLocation != -1.0) {
            this.splitPane.setDividerLocation(this.dividerLocation);
        }
    }

    private class ArrowStatusUpdater
    implements KeyListener,
    MouseListener {
        private ResultViewPanel resultViewPanel;

        public ArrowStatusUpdater(ResultViewPanel component) {
            this.resultViewPanel = component;
        }

        private void update() {
            if (ResultViewPanel.this.resultModel == null || ResultViewPanel.this.tree == null) {
                return;
            }
            if (!this.resultViewPanel.hasResults) {
                ResultViewPanel.this.btnPrev.setEnabled(false);
                ResultViewPanel.this.btnNext.setEnabled(false);
            } else {
                TreePath leadPath = ResultViewPanel.this.tree.getLeadSelectionPath();
                if (leadPath == null) {
                    ResultViewPanel.this.btnPrev.setEnabled(false);
                    ResultViewPanel.this.btnNext.setEnabled(true);
                } else {
                    ResultViewPanel.this.btnPrev.setEnabled(ResultViewPanel.this.findNextPath(leadPath, false) != null);
                    ResultViewPanel.this.btnNext.setEnabled(ResultViewPanel.this.findNextPath(leadPath, true) != null);
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            int key = e.getKeyCode();
            if (key == 10 || key == 32 || key == 38 || key == 40 || key == 37 || key == 39) {
                this.update();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.update();
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

