/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbPreferences;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class RecentFiles {
    private static List<HistoryItem> history = new ArrayList<HistoryItem>();
    private static Preferences prefs;
    private static final Object HISTORY_LOCK;
    private static final String PREFS_NODE = "RecentFilesHistory";
    private static final String PROP_URL_PREFIX = "RecentFilesURL.";
    static final int MAX_HISTORY_ITEMS = 15;
    private static volatile boolean historyProbablyValid;

    private RecentFiles() {
    }

    public static void init() {
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List<HistoryItem> loaded = RecentFiles.load();
                Object object = HISTORY_LOCK;
                synchronized (object) {
                    history.addAll(0, loaded);
                }
                TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)new WindowRegistryL());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<HistoryItem> getRecentFiles() {
        Object object = HISTORY_LOCK;
        synchronized (object) {
            RecentFiles.checkHistory();
            return Collections.unmodifiableList(history);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasRecentFiles() {
        if (!historyProbablyValid) {
            Object object = HISTORY_LOCK;
            synchronized (object) {
                RecentFiles.checkHistory();
                return !history.isEmpty();
            }
        }
        return historyProbablyValid;
    }

    static List<HistoryItem> load() {
        String[] keys;
        Preferences _prefs = RecentFiles.getPrefs();
        try {
            keys = _prefs.keys();
        }
        catch (BackingStoreException ex) {
            Logger.getLogger(RecentFiles.class.getName()).log(Level.FINE, ex.getMessage(), ex);
            return Collections.emptyList();
        }
        ArrayList<HistoryItem> result = new ArrayList<HistoryItem>();
        for (String curKey : keys) {
            String value = _prefs.get(curKey, null);
            if (value != null) {
                try {
                    int id = new Integer(curKey.substring(PROP_URL_PREFIX.length()));
                    HistoryItem hItem = new HistoryItem(id, value);
                    int ind = result.indexOf(hItem);
                    if (ind == -1) {
                        result.add(hItem);
                        continue;
                    }
                    _prefs.remove(PROP_URL_PREFIX + Math.max(((HistoryItem)result.get(ind)).id, id));
                    ((HistoryItem)result.get(ind)).id = Math.min(((HistoryItem)result.get(ind)).id, id);
                }
                catch (Exception ex) {
                    Logger.getLogger(RecentFiles.class.getName()).log(Level.FINE, ex.getMessage(), ex);
                    _prefs.remove(curKey);
                }
                continue;
            }
            _prefs.remove(curKey);
        }
        Collections.sort(result);
        RecentFiles.store(result);
        return result;
    }

    static void store() {
        RecentFiles.store(history);
    }

    static void store(List<HistoryItem> history) {
        Preferences _prefs = RecentFiles.getPrefs();
        for (int i = 0; i < history.size(); ++i) {
            HistoryItem hi = history.get(i);
            if (hi.id != i && hi.id >= history.size()) {
                _prefs.remove(PROP_URL_PREFIX + hi.id);
            }
            hi.id = i;
            _prefs.put(PROP_URL_PREFIX + i, hi.getPath());
        }
    }

    static Preferences getPrefs() {
        if (prefs == null) {
            prefs = NbPreferences.forModule(RecentFiles.class).node(PREFS_NODE);
        }
        return prefs;
    }

    private static void addFile(TopComponent tc) {
        if (tc instanceof CloneableTopComponent) {
            RecentFiles.addFile(RecentFiles.obtainPath(tc));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void addFile(String path) {
        if (path != null) {
            historyProbablyValid = false;
            Object object = HISTORY_LOCK;
            synchronized (object) {
                HistoryItem hItem = null;
                while (history.remove(hItem = RecentFiles.findHistoryItem(path))) {
                }
                hItem = new HistoryItem(0, path);
                history.add(0, hItem);
                for (int i = 15; i < history.size(); ++i) {
                    history.remove(i);
                }
                RecentFiles.store();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeFile(TopComponent tc) {
        String path;
        historyProbablyValid = false;
        if (tc instanceof CloneableTopComponent && (path = RecentFiles.obtainPath(tc)) != null) {
            Object object = HISTORY_LOCK;
            synchronized (object) {
                HistoryItem hItem = RecentFiles.findHistoryItem(path);
                if (hItem != null) {
                    history.remove(hItem);
                }
                RecentFiles.store();
            }
        }
    }

    private static String obtainPath(TopComponent tc) {
        FileObject fo;
        DataObject dObj = (DataObject)tc.getLookup().lookup(DataObject.class);
        if (dObj != null && (fo = dObj.getPrimaryFile()) != null) {
            return RecentFiles.convertFile2Path(fo);
        }
        return null;
    }

    private static HistoryItem findHistoryItem(String path) {
        for (HistoryItem hItem : history) {
            if (!path.equals(hItem.getPath())) continue;
            return hItem;
        }
        return null;
    }

    static String convertFile2Path(FileObject fo) {
        File f = FileUtil.toFile((FileObject)fo);
        return f == null ? null : f.getPath();
    }

    static FileObject convertPath2File(String path) {
        File f = new File(path);
        return (f = FileUtil.normalizeFile((File)f)) == null ? null : FileUtil.toFileObject((File)f);
    }

    private static void checkHistory() {
        assert (Thread.holdsLock(HISTORY_LOCK));
        historyProbablyValid = !history.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void pruneHistory() {
        Object object = HISTORY_LOCK;
        synchronized (object) {
            Iterator<HistoryItem> it = history.iterator();
            while (it.hasNext()) {
                HistoryItem historyItem = it.next();
                File f = new File(historyItem.getPath());
                if (f.exists()) continue;
                it.remove();
            }
        }
    }

    static {
        HISTORY_LOCK = new Object();
    }

    private static class WindowRegistryL
    implements PropertyChangeListener {
        private WindowRegistryL() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if ("tcClosed".equals(name)) {
                RecentFiles.addFile((TopComponent)evt.getNewValue());
            }
            if ("tcOpened".equals(name)) {
                RecentFiles.removeFile((TopComponent)evt.getNewValue());
            }
        }
    }

    static final class HistoryItem
    implements Comparable<HistoryItem> {
        private int id;
        private String path;
        private String fileName;

        HistoryItem(int id, String path) {
            this.path = path;
            this.id = id;
        }

        public String getPath() {
            return this.path;
        }

        public String getFileName() {
            if (this.fileName == null) {
                int pos = this.path.lastIndexOf(File.separatorChar);
                this.fileName = pos != -1 && pos < this.path.length() ? this.path.substring(pos + 1) : this.path;
            }
            return this.fileName;
        }

        @Override
        public int compareTo(HistoryItem o) {
            return this.id - o.id;
        }

        public boolean equals(Object obj) {
            if (obj instanceof HistoryItem) {
                return ((HistoryItem)obj).getPath().equals(this.path);
            }
            return false;
        }

        public int hashCode() {
            int hash = 7;
            hash = 17 * hash + (this.path != null ? this.path.hashCode() : 0);
            return hash;
        }
    }
}

