/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.utils;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.GdbVariable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class GdbUtils {
    public static boolean isSimpleType(Object type) {
        if (type == null || type instanceof Map) {
            return false;
        }
        StringTokenizer tok = new StringTokenizer(type.toString().replaceAll("[\\[\\]()<>,:*]", " "));
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (GdbUtils.isSimpleTypeKeyword(token)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSimplePointer(String type) {
        return type != null && GdbUtils.isSimpleType(type.replaceFirst("[*]", " "));
    }

    private static boolean isSimpleTypeKeyword(String type) {
        return type != null && (type.equals("char") || type.equals("void") || type.equals("short") || type.equals("int") || type.equals("long") || type.equals("float") || type.equals("double") || type.equals("const") || type.equals("volatile") || type.equals("unsigned") || type.equals("signed"));
    }

    public static boolean isClass(Object type) {
        return type instanceof Map || type instanceof String && type.toString().startsWith("class ");
    }

    public static boolean isArray(Object type) {
        return type instanceof String && type.toString().endsWith("]");
    }

    public static boolean isPointer(Object type) {
        return type instanceof String && (type.toString().endsWith("*") || type.toString().endsWith("* const"));
    }

    public static boolean isSinglePointer(Object type) {
        return GdbUtils.isPointer(type) && !GdbUtils.isMultiPointer(type);
    }

    public static boolean isMultiPointer(Object type) {
        return type instanceof String && (type.toString().endsWith("**") || type.toString().endsWith("** const"));
    }

    public static boolean isFunctionPointer(Object type) {
        return type instanceof String && type.toString().contains("(*)(");
    }

    public static String getBaseType(String type) {
        if (type != null) {
            type = type.replace("const ", "");
            type = type.replace("volatile ", "");
            type = type.replace("static ", "");
            int len = type.length();
            for (int i = 0; i < len; ++i) {
                char ch = type.charAt(i);
                if (Character.isLetter(ch) || Character.isDigit(ch) || GdbUtils.isOneOf(ch, " _:<>,")) continue;
                return type.substring(0, i).trim();
            }
            return type.trim();
        }
        return null;
    }

    public static boolean containesOneOf(String str, String chars) {
        for (int i = 0; i < str.length(); ++i) {
            if (!GdbUtils.isOneOf(str.charAt(i), chars)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOneOf(char ch, String chars) {
        for (int i = 0; i < chars.length(); ++i) {
            if (ch != chars.charAt(i)) continue;
            return true;
        }
        return false;
    }

    private static void processString(String info, PairProcessor processor, String encoding) {
        int len = info.length();
        int i = 0;
        block5: while (i < len) {
            int tend;
            int tstart = i++;
            if ((i = info.indexOf(61, i)) == -1) break;
            String key = info.substring(tstart, i);
            switch (info.charAt(++i)) {
                case '{': {
                    tend = GdbUtils.findMatchingCurly(info, i++);
                    break;
                }
                case '\"': {
                    tend = GdbUtils.findEndOfString(info, ++i);
                    break;
                }
                case '[': {
                    tend = GdbUtils.findMatchingBrace(info, i++);
                    break;
                }
                default: {
                    break block5;
                }
            }
            if (tend == -1) break;
            String value = info.substring(i, tend);
            if (key.equals("fullname") || key.equals("file")) {
                value = GdbUtils.gdbToUserEncoding(value, encoding);
            }
            processor.onPair(key, value);
            i = tend + 2;
        }
    }

    public static Map<String, String> createMapFromString(String info, String encoding) {
        final HashMap<String, String> map = new HashMap<String, String>();
        GdbUtils.processString(info, new PairProcessor(){

            @Override
            public void onPair(String key, String value) {
                map.put(key, value);
            }
        }, encoding);
        return map;
    }

    private static String gdbToUserEncoding(String string, String encoding) {
        char[] chars = string.toCharArray();
        int last = 0;
        ArrayList<Byte> _bytes = new ArrayList<Byte>();
        for (int i = 0; i < chars.length; ++i) {
            char next;
            char ch = chars[i];
            char c = next = i + 1 < chars.length ? chars[i + 1] : (char)'\u0000';
            if (ch == '\\' && last != 92 && next != '\\') {
                char[] charVal = new char[]{chars[++i], chars[++i], chars[++i]};
                ch = (char)Integer.parseInt(String.valueOf(charVal), 8);
            }
            _bytes.add((byte)ch);
            last = chars[i];
        }
        byte[] bytes = new byte[_bytes.size()];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (Byte)_bytes.get(i);
        }
        try {
            string = new String(bytes, encoding);
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        return string;
    }

    public static boolean isMultiByte(String file) {
        char[] ch = file.toCharArray();
        for (int i = 0; i < file.length(); ++i) {
            if (ch[i] <= '\u0080') continue;
            return true;
        }
        return false;
    }

    public static List<String> createListFromString(String info, String encoding) {
        final ArrayList<String> list = new ArrayList<String>();
        GdbUtils.processString(info, new PairProcessor(){

            @Override
            public void onPair(String key, String value) {
                list.add(value);
            }
        }, encoding);
        return list;
    }

    public static List<String> createListOfValues(String info) {
        int end;
        ArrayList<String> list = new ArrayList<String>();
        int start = info.indexOf(123);
        while (start != -1 && (end = GdbUtils.findMatchingCurly(info, start)) != -1) {
            list.add(info.substring(start + 1, end));
            start = info.indexOf(123, end);
        }
        return list;
    }

    public static List<GdbVariable> createLocalsList(String info) {
        ArrayList<GdbVariable> list = new ArrayList<GdbVariable>();
        int idx = 0;
        int pos = 0;
        while ((pos = GdbUtils.findMatchingCurly(info, idx)) != -1 && pos < info.length()) {
            String frag = info.substring(idx, pos + 1);
            int pos2 = GdbUtils.findNextComma(frag, 0, 1);
            if (pos2 != -1) {
                String name = frag.substring(7, pos2 - 1);
                String value = frag.substring(pos2 + 8, frag.length() - 2);
                list.add(new GdbVariable(name, value));
            }
            idx = info.indexOf(123, pos);
        }
        return list;
    }

    public static List<GdbVariable> createArgumentList(String info) {
        String frag;
        ArrayList<GdbVariable> list = new ArrayList<GdbVariable>();
        int idx = 0;
        for (int len = info.length(); len > 0; len -= frag.length() + 1) {
            int pos;
            frag = info.substring(idx, GdbUtils.findMatchingCurly(info, idx) + 1);
            idx += frag.length() + 1;
            if (!frag.startsWith("{name=\"") || !frag.endsWith("\"}") || (pos = frag.indexOf("\",value=\"")) <= 0) continue;
            String name = frag.substring(7, pos);
            String value = frag.substring(pos + 9, frag.length() - 2);
            list.add(new GdbVariable(name, value));
        }
        return list;
    }

    public static String mackHack(String info) {
        if (info != null && info.indexOf("\\n") != -1) {
            StringBuilder s = new StringBuilder();
            int idx = 0;
            boolean inDoubleQuote = false;
            boolean inSingleQuote = false;
            int pos1 = info.indexOf("&) @0x");
            int pos2 = info.indexOf(123);
            int pos3 = info.indexOf(58);
            if (info.charAt(0) == '(' && pos1 != -1 && pos2 != -1 && pos3 != -1 && pos3 < pos2) {
                idx = pos2;
            }
            while (idx < info.length()) {
                char ch = info.charAt(idx);
                if (inDoubleQuote) {
                    if (ch == '\"' && !GdbUtils.isSlashBefore(info, idx)) {
                        inDoubleQuote = false;
                    }
                } else if (inSingleQuote) {
                    if (ch == '\'' && !GdbUtils.isSlashBefore(info, idx)) {
                        inSingleQuote = false;
                    }
                } else if (ch == '\"' && !GdbUtils.isSlashBefore(info, idx)) {
                    inDoubleQuote = !inDoubleQuote;
                } else if (ch == '\'') {
                    inSingleQuote = true;
                } else if (ch == 'n' && GdbUtils.isSlashBefore(info, idx)) {
                    s.deleteCharAt(s.length() - 1);
                    ch = '\u0000';
                } else if (info.substring(idx).startsWith("members of ")) {
                    pos1 = info.indexOf(58, idx);
                    pos2 = info.indexOf(32, idx + 11);
                    if (pos1 != -1 && pos2 != -1 && pos1 < pos2) {
                        idx = pos1 + 1;
                        ch = '\u0000';
                    }
                }
                if (ch != '\u0000') {
                    s.append(ch);
                }
                ++idx;
            }
            return s.toString();
        }
        return info;
    }

    public static int findEndOfString(String s, int idx) {
        int len = s.length();
        while (idx < len) {
            char ch = s.charAt(idx);
            if (ch == '\"' && !GdbUtils.isSlashBefore(s, idx)) {
                return idx;
            }
            ++idx;
        }
        throw new IllegalStateException(NbBundle.getMessage(GdbUtils.class, (String)"ERR_UnexpectedGDBStopMessage"));
    }

    public static int findMatchingBrace(String s, int idx) {
        return GdbUtils.findMatchingPair("[]", s, idx);
    }

    public static int findMatchingCurly(String s, int idx) {
        return GdbUtils.findMatchingPair("{}", s, idx);
    }

    public static int findMatchingParen(String s, int idx) {
        return GdbUtils.findMatchingPair("()", s, idx);
    }

    public static int findMatchingLtGt(String s, int idx) {
        return GdbUtils.findMatchingPair("<>", s, idx);
    }

    private static int findMatchingPair(String pair, String s, int idx) {
        char lbrace = pair.charAt(0);
        char rbrace = pair.charAt(1);
        int count = 0;
        boolean inDoubleQuote = false;
        boolean inSingleQuote = false;
        if (s == null || s.length() == 0 || idx < 0) {
            return -1;
        }
        if (s.charAt(idx) == lbrace) {
            ++idx;
        }
        while (idx < s.length()) {
            char ch = s.charAt(idx);
            if (inDoubleQuote) {
                if (ch == '\"' && !GdbUtils.isSlashBefore(s, idx)) {
                    inDoubleQuote = false;
                }
            } else if (inSingleQuote) {
                if (ch == '\'' && !GdbUtils.isSlashBefore(s, idx)) {
                    inSingleQuote = false;
                }
            } else {
                if (ch == rbrace && count == 0) {
                    return idx;
                }
                if (ch == '\"' && !GdbUtils.isSlashBefore(s, idx)) {
                    inDoubleQuote = !inDoubleQuote;
                } else if (ch == '\'') {
                    inSingleQuote = true;
                } else if (ch == lbrace) {
                    ++count;
                } else if (ch == rbrace) {
                    --count;
                }
            }
            ++idx;
        }
        return -1;
    }

    private static boolean isSlashBefore(String source, int pos) {
        int count = 0;
        --pos;
        while (pos > 0 && source.charAt(pos) == '\\') {
            --pos;
            ++count;
        }
        return count % 2 == 1;
    }

    public static int findNextComma(String s, int idx) {
        return GdbUtils.findNextComma(s, idx, 0);
    }

    public static int findNextComma(String s, int idx, int skipCount) {
        boolean inDoubleQuote = false;
        boolean inSingleQuote = false;
        assert (s != null && s.length() > 0);
        if (idx < 0) {
            return -1;
        }
        idx += skipCount;
        while (idx < s.length()) {
            int i;
            char ch = s.charAt(idx);
            if (inDoubleQuote) {
                if (ch == '\"' && !GdbUtils.isSlashBefore(s, idx)) {
                    inDoubleQuote = false;
                }
            } else if (inSingleQuote) {
                if (ch == '\'' && !GdbUtils.isSlashBefore(s, idx)) {
                    inSingleQuote = false;
                }
            } else if (ch == '{') {
                i = GdbUtils.findMatchingCurly(s, idx);
                if (i == -1) break;
                idx = i;
            } else if (ch == '<') {
                i = GdbUtils.findMatchingLtGt(s, idx);
                if (i == -1) break;
                idx = i;
            } else if (ch == '[') {
                i = GdbUtils.findMatchingBrace(s, idx);
                if (i == -1) break;
                idx = i;
            } else {
                if (ch == ',' && !GdbUtils.isMultiString(s, idx)) {
                    return idx;
                }
                if (ch == '\"' && !GdbUtils.isSlashBefore(s, idx)) {
                    inDoubleQuote = !inDoubleQuote;
                } else if (ch == '\'' && !GdbUtils.isSlashBefore(s, idx)) {
                    inSingleQuote = true;
                }
            }
            ++idx;
        }
        return -1;
    }

    private static boolean isMultiString(String s, int idx) {
        int pos;
        String frag;
        return ++idx < s.length() && (frag = (pos = s.indexOf(44, idx)) == -1 ? s.substring(idx) : s.substring(idx, pos)).startsWith("<repeats ") && frag.contains(" times>");
    }

    public static int findNextSemi(String s, int idx) {
        boolean inDoubleQuote = false;
        boolean inSingleQuote = false;
        assert (s != null && s.length() > 0);
        if (idx < 0) {
            return -1;
        }
        char ch = s.charAt(idx);
        if (ch == ';' || ch == '{') {
            ++idx;
        }
        while (idx < s.length()) {
            int i;
            ch = s.charAt(idx);
            if (inDoubleQuote) {
                if (ch == '\"' && !GdbUtils.isSlashBefore(s, idx)) {
                    inDoubleQuote = false;
                }
            } else if (inSingleQuote) {
                if (ch == '\'' && !GdbUtils.isSlashBefore(s, idx)) {
                    inSingleQuote = false;
                }
            } else if (ch == '{') {
                i = GdbUtils.findMatchingCurly(s, idx);
                if (i == -1) break;
                idx = i;
            } else if (ch == '<') {
                i = GdbUtils.findMatchingLtGt(s, idx);
                if (i == -1) break;
                idx = i;
            } else if (ch == '[') {
                i = GdbUtils.findMatchingBrace(s, idx);
                if (i == -1) break;
                idx = i;
            } else {
                if (ch == ';') {
                    return idx;
                }
                if (ch == '\"' && !GdbUtils.isSlashBefore(s, idx)) {
                    inDoubleQuote = !inDoubleQuote;
                } else if (ch == '\'' && !GdbUtils.isSlashBefore(s, idx)) {
                    inSingleQuote = true;
                }
            }
            ++idx;
        }
        return -1;
    }

    public static int firstNonWhite(String info, int idx) {
        int len = info.length();
        if (idx >= 0 && idx < len) {
            char ch;
            while (idx < len && ((ch = info.charAt(idx)) == ' ' || ch == '\t' || ch == '\n' || ch == '\r')) {
                ++idx;
            }
            if (idx < len) {
                return idx;
            }
        }
        return -1;
    }

    public static String threadId() {
        Thread cur = Thread.currentThread();
        return cur.getName() + ':' + Long.toString(cur.getId());
    }

    public static boolean compareUnixPaths(String path1, String path2) {
        assert (path1.equals(path1.trim())) : "Only trimmed paths allowed";
        assert (path2.equals(path2.trim())) : "Only trimmed paths allowed";
        assert (path1.charAt(0) == '/') : "Only unix paths supported";
        assert (path2.charAt(0) == '/') : "Only unix paths supported";
        if (path1.equals(path2)) {
            return true;
        }
        try {
            String norPath1 = new URI(path1).normalize().getPath();
            String norPath2 = new URI(path2).normalize().getPath();
            path1 = norPath1;
            path2 = norPath2;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return path1.equals(path2);
    }

    public static String removeExe(String exe) {
        if (exe.endsWith(".exe")) {
            return exe.substring(0, exe.length() - 4);
        }
        return exe;
    }

    public static double parseVersionString(String msg) throws NumberFormatException {
        int last;
        int first;
        int dot = msg.indexOf(46);
        for (first = dot - 1; first > 0 && Character.isDigit(msg.charAt(first)); --first) {
        }
        for (last = dot + 1; last < msg.length() && Character.isDigit(msg.charAt(last)); ++last) {
        }
        return Double.parseDouble(msg.substring(first + 1, last));
    }

    public static RequestProcessor getGdbRequestProcessor() {
        GdbDebugger gdbDebugger = GdbDebugger.getGdbDebugger();
        if (gdbDebugger != null) {
            return gdbDebugger.getRequestProcessor();
        }
        return RequestProcessor.getDefault();
    }

    private static abstract class PairProcessor {
        private PairProcessor() {
        }

        public abstract void onPair(String var1, String var2);
    }
}

