/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.modules.cnd.debugger.gdb.attach.GdbAttachPanel;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.NbBundle;

public class SelectCorePanel
extends JPanel {
    private final JButton okButton;
    private JButton coreBrowseButton;
    private JTextField corePathText;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JComboBox projectCB;

    public SelectCorePanel(JButton okButton) {
        this.okButton = okButton;
        this.initComponents();
        GdbAttachPanel.fillProjectsCombo(this.projectCB);
        this.corePathText.getDocument().addDocumentListener(new GdbAttachPanel.AnyChangeDocumentListener(){

            @Override
            public void documentChanged(DocumentEvent e) {
                SelectCorePanel.this.setValid();
            }
        });
        this.setValid();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.corePathText = new JTextField();
        this.coreBrowseButton = new JButton();
        this.jLabel2 = new JLabel();
        this.projectCB = new JComboBox();
        this.jLabel1.setText(NbBundle.getMessage(SelectCorePanel.class, (String)"SelectCorePanel.jLabel1.text"));
        this.coreBrowseButton.setText(NbBundle.getMessage(SelectCorePanel.class, (String)"SelectCorePanel.coreBrowseButton.text"));
        this.coreBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectCorePanel.this.coreBrowseButtonActionPerformed(evt);
            }
        });
        this.jLabel2.setText(NbBundle.getMessage(SelectCorePanel.class, (String)"SelectCorePanel.jLabel2.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.corePathText, -2, 337, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.coreBrowseButton)).addComponent(this.projectCB, 0, 430, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.corePathText, -2, -1, -2).addComponent(this.coreBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.projectCB, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void coreBrowseButtonActionPerformed(ActionEvent evt) {
        File file = new FileChooserBuilder(SelectCorePanel.class).setTitle(NbBundle.getMessage(SelectCorePanel.class, (String)"SelectCorePanel.coreBrowse.title")).setFilesOnly(true).showOpenDialog();
        if (file != null) {
            this.corePathText.setText(file.getAbsolutePath());
        }
    }

    public String getCorePath() {
        return this.corePathText.getText();
    }

    private void setValid() {
        String text = this.corePathText.getText();
        this.okButton.setEnabled(text != null && text.length() > 0 && this.projectCB.getSelectedItem() != null);
    }

    public ProjectInformation getProjectInformation() {
        GdbAttachPanel.ProjectCBItem pi = (GdbAttachPanel.ProjectCBItem)this.projectCB.getSelectedItem();
        if (pi == null) {
            return null;
        }
        return pi.getProjectInformation();
    }
}

