/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.models;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.netbeans.modules.cnd.debugger.gdb.models.AbstractVariable;
import org.netbeans.modules.cnd.debugger.gdb.models.GdbWatchVariable;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public class NumericDisplayFilter
implements TableModelFilter,
NodeActionsProviderFilter,
Constants {
    private final Map<String, NumericDisplaySettings> variableToDisplaySettings = new HashMap<String, NumericDisplaySettings>();
    private final Map<String, NumericDisplaySettings> watchToDisplaySettings = new HashMap<String, NumericDisplaySettings>();
    private HashSet<ModelListener> listeners;

    private Map<String, NumericDisplaySettings> getNodeCollection(AbstractVariable var) {
        if (var instanceof GdbWatchVariable) {
            return this.watchToDisplaySettings;
        }
        if (var instanceof AbstractVariable.AbstractField) {
            return this.getNodeCollection(((AbstractVariable.AbstractField)var).getAncestor());
        }
        return this.variableToDisplaySettings;
    }

    private NumericDisplaySettings getDisplaySettings(AbstractVariable var) {
        return this.getNodeCollection(var).get(var.getFullName(true));
    }

    private void setDisplaySettings(AbstractVariable var, NumericDisplaySettings nds) {
        this.getNodeCollection(var).put(var.getFullName(true), nds);
    }

    public Object getValueAt(TableModel original, Object node, String columnID) throws UnknownTypeException {
        AbstractVariable var;
        NumericDisplaySettings nds;
        if ((columnID == "WatchValue" || columnID == "WatchToString" || columnID == "LocalsValue" || columnID == "LocalsToString") && node instanceof AbstractVariable && (nds = this.getDisplaySettings(var = (AbstractVariable)node)) != null && nds != NumericDisplaySettings.AUTO) {
            return this.getValue(var, nds);
        }
        return original.getValueAt(node, columnID);
    }

    public boolean isReadOnly(TableModel original, Object node, String columnID) throws UnknownTypeException {
        return original.isReadOnly(node, columnID);
    }

    public void setValueAt(TableModel original, Object node, String columnID, Object value) throws UnknownTypeException {
        AbstractVariable var;
        NumericDisplaySettings nds;
        if ((columnID == "WatchValue" || columnID == "WatchToString" || columnID == "LocalsValue" || columnID == "LocalsToString") && node instanceof AbstractVariable && value instanceof String && (nds = this.getDisplaySettings(var = (AbstractVariable)node)) != null && nds != NumericDisplaySettings.AUTO) {
            value = this.formatValue((String)value, nds);
        }
        original.setValueAt(node, columnID, value);
    }

    public void addModelListener(ModelListener l) {
        HashSet newListeners = this.listeners == null ? new HashSet() : (HashSet)this.listeners.clone();
        newListeners.add(l);
        this.listeners = newListeners;
    }

    public void removeModelListener(ModelListener l) {
        if (this.listeners == null) {
            return;
        }
        HashSet newListeners = (HashSet)this.listeners.clone();
        newListeners.remove(l);
        this.listeners = newListeners;
    }

    public void performDefaultAction(NodeActionsProvider original, Object node) throws UnknownTypeException {
        original.performDefaultAction(node);
    }

    public Action[] getActions(NodeActionsProvider original, Object node) throws UnknownTypeException {
        if (!(node instanceof AbstractVariable)) {
            return original.getActions(node);
        }
        AbstractVariable var = (AbstractVariable)node;
        if (this.getDisplaySettings(var) != null || NumericDisplayFilter.isIntegralType(var)) {
            Action[] actions;
            try {
                actions = original.getActions(node);
            }
            catch (UnknownTypeException e) {
                actions = new Action[]{};
            }
            ArrayList<Action> myActions = new ArrayList<Action>();
            myActions.add(new DisplayAsAction(var));
            myActions.addAll(Arrays.asList(actions));
            return myActions.toArray(new Action[myActions.size()]);
        }
        return original.getActions(node);
    }

    private static int getChar(String val) {
        if (val.length() >= 3 && val.charAt(0) == '\'' && val.charAt(2) == '\'') {
            return val.charAt(1);
        }
        if (!val.isEmpty()) {
            return val.charAt(0);
        }
        return 0;
    }

    private Object getValue(AbstractVariable var, NumericDisplaySettings settings) {
        try {
            switch (settings) {
                case DECIMAL: {
                    return Long.toString(NumericDisplayFilter.getValue(var));
                }
                case HEXADECIMAL: {
                    return "0x" + Long.toHexString(NumericDisplayFilter.getValue(var));
                }
                case OCTAL: {
                    return "0" + Long.toOctalString(NumericDisplayFilter.getValue(var));
                }
                case BINARY: {
                    return Long.toBinaryString(NumericDisplayFilter.getValue(var));
                }
                case CHAR: {
                    return "'" + (char)NumericDisplayFilter.getValue(var) + "'";
                }
            }
            return var.getValue();
        }
        catch (NumberFormatException nfex) {
            return nfex.getLocalizedMessage();
        }
    }

    private String formatValue(String origValue, NumericDisplaySettings settings) {
        if (origValue.isEmpty()) {
            return origValue;
        }
        try {
            switch (settings) {
                case BINARY: {
                    return Long.toString(Long.parseLong(origValue, 2));
                }
                case CHAR: {
                    return String.valueOf(NumericDisplayFilter.getChar(origValue));
                }
            }
            return origValue;
        }
        catch (NumberFormatException nfex) {
            return nfex.getLocalizedMessage();
        }
    }

    private static long getValue(AbstractVariable v) throws NumberFormatException {
        return Long.decode(v.getValue());
    }

    private static boolean isIntegralType(AbstractVariable v) {
        try {
            NumericDisplayFilter.getValue(v);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private class DisplayAsAction
    extends AbstractAction
    implements Presenter.Popup {
        private AbstractVariable variable;

        public DisplayAsAction(AbstractVariable variable) {
            this.variable = variable;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        public JMenuItem getPopupPresenter() {
            JMenu displayAsPopup = new JMenu(NbBundle.getMessage(NumericDisplayFilter.class, (String)"CTL_Variable_DisplayAs_Popup"));
            DisplayAsMenuItem autoItem = new DisplayAsMenuItem("CTL_Variable_DisplayAs_Auto", NumericDisplaySettings.AUTO);
            DisplayAsMenuItem decimalItem = new DisplayAsMenuItem("CTL_Variable_DisplayAs_Decimal", NumericDisplaySettings.DECIMAL);
            DisplayAsMenuItem hexadecimalItem = new DisplayAsMenuItem("CTL_Variable_DisplayAs_Hexadecimal", NumericDisplaySettings.HEXADECIMAL);
            DisplayAsMenuItem octalItem = new DisplayAsMenuItem("CTL_Variable_DisplayAs_Octal", NumericDisplaySettings.OCTAL);
            DisplayAsMenuItem binaryItem = new DisplayAsMenuItem("CTL_Variable_DisplayAs_Binary", NumericDisplaySettings.BINARY);
            DisplayAsMenuItem charItem = new DisplayAsMenuItem("CTL_Variable_DisplayAs_Character", NumericDisplaySettings.CHAR);
            DisplayAsMenuItem timeItem = new DisplayAsMenuItem("CTL_Variable_DisplayAs_Time", NumericDisplaySettings.TIME);
            NumericDisplaySettings lds = NumericDisplayFilter.this.getDisplaySettings(this.variable);
            if (lds != null) {
                switch (lds) {
                    case AUTO: {
                        autoItem.setSelected(true);
                        break;
                    }
                    case DECIMAL: {
                        decimalItem.setSelected(true);
                        break;
                    }
                    case HEXADECIMAL: {
                        hexadecimalItem.setSelected(true);
                        break;
                    }
                    case OCTAL: {
                        octalItem.setSelected(true);
                        break;
                    }
                    case BINARY: {
                        binaryItem.setSelected(true);
                        break;
                    }
                    case CHAR: {
                        charItem.setSelected(true);
                        break;
                    }
                    case TIME: {
                        timeItem.setSelected(true);
                    }
                }
            } else {
                autoItem.setSelected(true);
            }
            displayAsPopup.add(autoItem);
            displayAsPopup.add(decimalItem);
            displayAsPopup.add(hexadecimalItem);
            displayAsPopup.add(octalItem);
            displayAsPopup.add(binaryItem);
            displayAsPopup.add(charItem);
            return displayAsPopup;
        }

        private void onDisplayAs(NumericDisplaySettings how) {
            NumericDisplaySettings lds = NumericDisplayFilter.this.getDisplaySettings(this.variable);
            if (lds == null) {
                lds = NumericDisplaySettings.AUTO;
            }
            if (lds == how) {
                return;
            }
            NumericDisplayFilter.this.setDisplaySettings(this.variable, how);
            this.fireModelChanged();
        }

        private void fireModelChanged() {
            if (NumericDisplayFilter.this.listeners == null) {
                return;
            }
            ModelEvent.TableValueChanged evt = new ModelEvent.TableValueChanged((Object)this, (Object)this.variable, null);
            for (ModelListener listener : NumericDisplayFilter.this.listeners) {
                listener.modelChanged((ModelEvent)evt);
            }
        }

        private class DisplayAsMenuItem
        extends JRadioButtonMenuItem {
            public DisplayAsMenuItem(String message, final NumericDisplaySettings as) {
                super(new AbstractAction(NbBundle.getMessage(NumericDisplayFilter.class, (String)message)){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DisplayAsAction.this.onDisplayAs(as);
                    }
                });
            }
        }
    }

    static enum NumericDisplaySettings {
        AUTO,
        DECIMAL,
        HEXADECIMAL,
        OCTAL,
        BINARY,
        CHAR,
        TIME;

    }
}

